/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common.misc;

import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;

public class SpecificWrapper
implements IItemHandlerModifiable {
    private final IItemHandlerModifiable compose;
    private final int[] slots;

    public SpecificWrapper(IItemHandlerModifiable compose, int ... slots) {
        this.compose = compose;
        this.slots = slots;
    }

    public int getSlots() {
        return this.slots.length;
    }

    private int getIndex(int input) {
        return this.slots[input];
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        if (this.checkSlot(slot)) {
            return this.compose.getStackInSlot(this.getIndex(slot));
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (this.checkSlot(slot)) {
            return this.compose.insertItem(this.getIndex(slot), stack, simulate);
        }
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.checkSlot(slot)) {
            return this.compose.extractItem(this.getIndex(slot), amount, simulate);
        }
        return ItemStack.field_190927_a;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        if (this.checkSlot(slot)) {
            this.compose.setStackInSlot(this.getIndex(slot), stack);
        }
    }

    private boolean checkSlot(int localSlot) {
        return localSlot < this.slots.length;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }
}

