/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common.network;

import flaxbeard.cyberware.api.item.ICyberware;
import flaxbeard.cyberware.common.block.tile.TileEntitySurgery;
import io.netty.buffer.ByteBuf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SurgeryRemovePacket
implements IMessage {
    private BlockPos pos;
    private int dimensionId;
    private int slotNumber;
    private boolean isNull;

    public SurgeryRemovePacket() {
    }

    public SurgeryRemovePacket(BlockPos pos, int dimensionId, int slotNumber, boolean isNull) {
        this.pos = pos;
        this.dimensionId = dimensionId;
        this.slotNumber = slotNumber;
        this.isNull = isNull;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeInt(this.dimensionId);
        buf.writeInt(this.slotNumber);
        buf.writeBoolean(this.isNull);
    }

    public void fromBytes(ByteBuf buf) {
        int x = buf.readInt();
        int y = buf.readInt();
        int z = buf.readInt();
        this.pos = new BlockPos(x, y, z);
        this.dimensionId = buf.readInt();
        this.slotNumber = buf.readInt();
        this.isNull = buf.readBoolean();
    }

    private static class DoSync
    implements Runnable {
        private BlockPos pos;
        private int dimensionId;
        private int slotNumber;
        private boolean isNull;

        private DoSync(BlockPos pos, int dimensionId, int slotNumber, boolean isNull) {
            this.pos = pos;
            this.dimensionId = dimensionId;
            this.slotNumber = slotNumber;
            this.isNull = isNull;
        }

        @Override
        public void run() {
            WorldServer world = DimensionManager.getWorld((int)this.dimensionId);
            TileEntity te = world.func_175625_s(this.pos);
            if (te instanceof TileEntitySurgery) {
                TileEntitySurgery surgery = (TileEntitySurgery)te;
                surgery.discardSlots[this.slotNumber] = this.isNull;
                if (this.isNull) {
                    surgery.disableDependants(surgery.slotsPlayer.getStackInSlot(this.slotNumber), ICyberware.EnumSlot.values()[this.slotNumber / 10], this.slotNumber % 10);
                } else {
                    surgery.enableDependsOn(surgery.slotsPlayer.getStackInSlot(this.slotNumber), ICyberware.EnumSlot.values()[this.slotNumber / 10], this.slotNumber % 10);
                }
                surgery.updateEssential(ICyberware.EnumSlot.values()[this.slotNumber / 10]);
                surgery.updateEssence();
            }
        }
    }

    public static class SurgeryRemovePacketHandler
    implements IMessageHandler<SurgeryRemovePacket, IMessage> {
        public IMessage onMessage(SurgeryRemovePacket message, MessageContext ctx) {
            DimensionManager.getWorld((int)message.dimensionId).func_152344_a((Runnable)new DoSync(message.pos, message.dimensionId, message.slotNumber, message.isNull));
            return null;
        }
    }
}

