/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.texture;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import slimeknights.tconstruct.library.client.texture.MetalColoredTexture;
import slimeknights.tconstruct.library.client.texture.TextureColoredTexture;

public class MetalTextureTexture
extends MetalColoredTexture {
    private final ResourceLocation addTextureLocation;
    protected TextureColoredTexture texture2;

    public MetalTextureTexture(ResourceLocation addTextureLocation, ResourceLocation baseTexture, String spriteName, int baseColor, float shinyness, float brightness, float hueshift) {
        super(baseTexture, spriteName, baseColor, shinyness, brightness, hueshift);
        this.addTextureLocation = addTextureLocation;
        this.texture2 = new TextureColoredTexture(addTextureLocation, baseTexture, spriteName);
    }

    @Override
    public Collection<ResourceLocation> getDependencies() {
        return ImmutableList.builder().addAll(super.getDependencies()).add((Object)this.addTextureLocation).build();
    }

    @Override
    public boolean load(IResourceManager manager, ResourceLocation location, Function<ResourceLocation, TextureAtlasSprite> textureGetter) {
        this.texture2.load(manager, location, textureGetter);
        return super.load(manager, location, textureGetter);
    }

    @Override
    protected void processData(int[] data) {
        int[] textureData = this.texture2.func_147965_a(0)[0];
        for (int i = 0; i < data.length && i < textureData.length; ++i) {
            data[i] = textureData[i];
        }
        super.processData(data);
    }
}

