/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.tileentity;

import com.mrcrayfish.furniture.tileentity.TileEntitySyncClient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityModernSlidingDoor
extends TileEntitySyncClient
implements ITickable {
    private boolean powered = false;
    private int maxProgress = 10;
    private int slideProgress;
    private int prevSlideProgress;

    public void func_73660_a() {
        this.prevSlideProgress = this.slideProgress;
        if (this.powered) {
            if (this.slideProgress < Math.max(0, this.maxProgress)) {
                ++this.slideProgress;
            }
        } else if (this.slideProgress > 0) {
            --this.slideProgress;
        }
    }

    public float getSlideProgress(float partialTicks) {
        float partialSlideProgress = (float)this.prevSlideProgress + (float)(this.slideProgress - this.prevSlideProgress) * partialTicks;
        float normalProgress = partialSlideProgress / (float)this.maxProgress;
        return 0.815f * (1.0f - ((float)Math.sin(Math.toRadians(90.0 + 180.0 * (double)normalProgress)) / 2.0f + 0.5f));
    }

    public void setPowered(boolean powered) {
        this.powered = powered;
    }

    public boolean isPowered() {
        return this.powered;
    }

    public double func_145833_n() {
        return 16384.0;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_150297_b("powered", 1)) {
            this.powered = compound.func_74767_n("powered");
        }
        if (compound.func_150297_b("maxProgress", 3)) {
            this.maxProgress = compound.func_74762_e("maxProgress");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74757_a("powered", this.powered);
        compound.func_74768_a("maxProgress", this.maxProgress);
        return compound;
    }
}

