/*
 * Decompiled with CFR 0.152.
 */
package shadows.spawn;

import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import shadows.Apotheosis;
import shadows.ApotheosisObjects;
import shadows.spawn.BlockSpawnerExt;
import shadows.spawn.EnchantmentCapturing;
import shadows.spawn.SpawnerModifiers;
import shadows.spawn.TileSpawnerExt;
import shadows.spawn.modifiers.SpawnerModifier;

public class SpawnerModule {
    public static final Logger LOG = LogManager.getLogger((String)"Apotheosis : Spawner");
    public static Configuration config;
    public static int spawnerSilkLevel;

    @SubscribeEvent
    public void preInit(Apotheosis.ApotheosisPreInit e) {
        config = new Configuration(new File(Apotheosis.configDir, "spawner.cfg"));
        if (Apotheosis.enableSpawner) {
            TileEntity.func_190560_a((String)"mob_spawner", TileSpawnerExt.class);
        }
    }

    @SubscribeEvent
    public void init(Apotheosis.ApotheosisInit e) {
        spawnerSilkLevel = config.getInt("Spawner Silk Level", "general", 1, -1, 127, "The level of silk touch needed to harvest a spawner.  Set to -1 to disable, 0 to always drop.  The enchantment module can increase the max level of silk touch.");
        SpawnerModifiers.init();
        if (config.hasChanged()) {
            config.save();
        }
    }

    @SubscribeEvent
    public void blocks(RegistryEvent.Register<Block> e) {
        Apotheosis.registerOverrideBlock((IForgeRegistry<Block>)e.getRegistry(), (Block)new BlockSpawnerExt(), "apotheosis");
    }

    @SubscribeEvent
    public void enchants(RegistryEvent.Register<Enchantment> e) {
        e.getRegistry().register(new EnchantmentCapturing().setRegistryName("apotheosis", "capturing"));
    }

    @SubscribeEvent
    public void handleCapturing(LivingDropsEvent e) {
        Entity killer = e.getSource().func_76346_g();
        if (killer instanceof EntityLivingBase) {
            int level = EnchantmentHelper.func_77506_a((Enchantment)ApotheosisObjects.CAPTURING, (ItemStack)((EntityLivingBase)killer).func_184614_ca());
            if (e.getEntityLiving().field_70170_p.field_73012_v.nextFloat() < (float)level / 250.0f) {
                ItemStack egg = new ItemStack(Items.field_151063_bx);
                EntityLivingBase killed = e.getEntityLiving();
                ItemMonsterPlacer.func_185078_a((ItemStack)egg, (ResourceLocation)EntityList.func_191301_a((Entity)killed));
                e.getDrops().add(new EntityItem(killed.field_70170_p, killed.field_70165_t, killed.field_70163_u, killed.field_70161_v, egg));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void drops(BlockEvent.HarvestDropsEvent e) {
        if (e.getState().func_177230_c() == Blocks.field_150474_ac && e.getHarvester() != null && spawnerSilkLevel != -1 && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)e.getHarvester().func_184614_ca()) >= spawnerSilkLevel) {
            e.getDrops().clear();
        }
    }

    @SubscribeEvent
    public void handleUseItem(PlayerInteractEvent.RightClickBlock e) {
        TileEntity te = e.getWorld().func_175625_s(e.getPos());
        if (te instanceof TileSpawnerExt) {
            ItemStack s = e.getItemStack();
            boolean inverse = SpawnerModifiers.inverseItem.apply(e.getEntityPlayer().func_184586_b(e.getHand() == EnumHand.MAIN_HAND ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND));
            for (SpawnerModifier sm : SpawnerModifiers.MODIFIERS) {
                if (!sm.canModify((TileSpawnerExt)te, s, inverse)) continue;
                e.setUseBlock(Event.Result.ALLOW);
            }
        }
    }

    static {
        spawnerSilkLevel = 1;
    }
}

