/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.decoration.feature;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import vazkii.arl.client.RetexturedModel;
import vazkii.quark.base.handler.OverrideRegistryHandler;
import vazkii.quark.base.module.Feature;
import vazkii.quark.decoration.block.BlockCustomFlowerPot;
import vazkii.quark.decoration.client.state.FlowerPotStateMapper;
import vazkii.quark.decoration.feature.ColoredFlowerPots;

public class BetterVanillaFlowerPot
extends Feature {
    private static BlockCustomFlowerPot flowerPot;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        flowerPot = new BlockCustomFlowerPot();
        flowerPot.func_149663_c("flowerPot");
        OverrideRegistryHandler.registerBlock((Block)flowerPot, "flower_pot");
    }

    @Override
    public void init() {
        ColoredFlowerPots.loadFlowersFromConfig();
    }

    @Override
    public String[] getIncompatibleMods() {
        return new String[]{"inspirations"};
    }

    @Override
    public String getFeatureDescription() {
        return "Adds the colored flower pot features of supporting additional flowers and comparator power to the vanilla flower pot using a block substitution";
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    @Override
    public boolean hasSubscriptions() {
        return this.isClient();
    }

    @SubscribeEvent
    public void onModelRegister(ModelRegistryEvent event) {
        ModelLoader.setCustomStateMapper((Block)flowerPot, (IStateMapper)flowerPot.getStateMapper());
    }

    @SubscribeEvent
    public void onModelRegister(ColorHandlerEvent.Block event) {
        event.getBlockColors().func_186722_a(flowerPot.getBlockColor(), new Block[]{flowerPot});
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) {
        ModelResourceLocation location = FlowerPotStateMapper.LOCATION;
        IModel model = ModelLoaderRegistry.getModelOrLogError((ResourceLocation)location, (String)("Error loading model for " + location));
        IBakedModel standard = (IBakedModel)event.getModelRegistry().func_82594_a((Object)location);
        RetexturedModel finalModel = new RetexturedModel(standard, model, DefaultVertexFormats.field_176600_a, "plant");
        event.getModelRegistry().func_82595_a((Object)location, (Object)finalModel);
    }
}

