/*
 * Decompiled with CFR 0.152.
 */
package de.keridos.floodlights.block;

import de.keridos.floodlights.block.BlockFLColorableMachine;
import de.keridos.floodlights.init.ModBlocks;
import de.keridos.floodlights.tileentity.TileEntitySmallFloodlight;
import de.keridos.floodlights.util.MathUtil;
import de.keridos.floodlights.util.PropertiesEnum;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSmallElectricFloodlight
extends BlockFLColorableMachine
implements ITileEntityProvider {
    public static final PropertyEnum MODEL = PropertyEnum.func_177709_a((String)"model", PropertiesEnum.EnumModelSmallLight.class);
    public static final PropertyBool ROTATIONSTATE = PropertyBool.func_177716_a((String)"rotationstate");

    public BlockSmallElectricFloodlight() {
        super("smallElectricFloodlightMetaBlock", Material.field_151576_e, SoundType.field_185852_e, 2.5f);
        this.setHarvestLevel("pickaxe", 1);
        this.guiId = 1;
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)MODEL, (Comparable)((Object)PropertiesEnum.EnumModelSmallLight.values()[0])).func_177226_a((IProperty)ROTATIONSTATE, (Comparable)Boolean.valueOf(false)));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)MODEL, (Comparable)((Object)PropertiesEnum.EnumModelSmallLight.values()[meta]));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((PropertiesEnum.EnumModelSmallLight)((Object)state.func_177229_b((IProperty)MODEL))).getID();
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntitySmallFloodlight) {
            return super.func_176221_a(state, worldIn, pos).func_177226_a((IProperty)ROTATIONSTATE, (Comparable)Boolean.valueOf(((TileEntitySmallFloodlight)tile).getRotationState()));
        }
        return super.func_176221_a(state, worldIn, pos);
    }

    @Override
    protected void buildBlockState(BlockStateContainer.Builder builder) {
        super.buildBlockState(builder);
        builder.add(new IProperty[]{MODEL}).add(new IProperty[]{ROTATIONSTATE});
    }

    public TileEntitySmallFloodlight createNewTileEntity(World world, int metadata) {
        return new TileEntitySmallFloodlight();
    }

    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state.func_177230_c() != this) {
            return super.func_185496_a(state, world, pos);
        }
        IBlockState actualState = state.func_185899_b(world, pos);
        boolean rotated = (Boolean)actualState.func_177229_b((IProperty)ROTATIONSTATE);
        switch ((PropertiesEnum.EnumModelSmallLight)((Object)actualState.func_177229_b((IProperty)MODEL))) {
            case SMALL_ELECTRIC_FLOODLIGHTS_STRIP: {
                switch ((EnumFacing)actualState.func_177229_b((IProperty)FACING)) {
                    case NORTH: {
                        return rotated ? BoundingBoxes.StripRotated.NORTH : BoundingBoxes.Strip.NORTH;
                    }
                    case SOUTH: {
                        return rotated ? BoundingBoxes.StripRotated.SOUTH : BoundingBoxes.Strip.SOUTH;
                    }
                    default: {
                        return rotated ? BoundingBoxes.StripRotated.EAST : BoundingBoxes.Strip.EAST;
                    }
                    case WEST: {
                        return rotated ? BoundingBoxes.StripRotated.WEST : BoundingBoxes.Strip.WEST;
                    }
                    case UP: {
                        return rotated ? BoundingBoxes.StripRotated.UP : BoundingBoxes.Strip.UP;
                    }
                    case DOWN: 
                }
                return rotated ? BoundingBoxes.StripRotated.DOWN : BoundingBoxes.Strip.DOWN;
            }
        }
        switch ((EnumFacing)actualState.func_177229_b((IProperty)FACING)) {
            case NORTH: {
                return BoundingBoxes.Square.NORTH;
            }
            case SOUTH: {
                return BoundingBoxes.Square.SOUTH;
            }
            default: {
                return BoundingBoxes.Square.EAST;
            }
            case WEST: {
                return BoundingBoxes.Square.WEST;
            }
            case UP: {
                return BoundingBoxes.Square.UP;
            }
            case DOWN: 
        }
        return BoundingBoxes.Square.DOWN;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(0, new ItemStack(ModBlocks.blockSmallElectricLight, 1, this.func_176201_c(state)));
        return drops;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (int i = 0; i < 2; ++i) {
            items.add((Object)new ItemStack(ModBlocks.blockSmallElectricLight, 1, i));
        }
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    private static AxisAlignedBB rotateAABB(AxisAlignedBB source, EnumFacing direction) {
        double[] min = MathUtil.rotateD(source.field_72340_a, source.field_72338_b, source.field_72339_c, direction);
        double[] max = MathUtil.rotateD(source.field_72336_d, source.field_72337_e, source.field_72334_f, direction);
        return new AxisAlignedBB(min[0], min[1], min[2], max[0], max[1], max[2]);
    }

    static {
        BoundingBoxes.Strip.EAST = new AxisAlignedBB(0.0, 0.3125, 0.0, 0.1875, 0.6875, 1.0);
        BoundingBoxes.Strip.NORTH = BlockSmallElectricFloodlight.rotateAABB(BoundingBoxes.Strip.EAST, EnumFacing.NORTH);
        BoundingBoxes.Strip.SOUTH = BlockSmallElectricFloodlight.rotateAABB(BoundingBoxes.Strip.EAST, EnumFacing.SOUTH);
        BoundingBoxes.Strip.WEST = BlockSmallElectricFloodlight.rotateAABB(BoundingBoxes.Strip.EAST, EnumFacing.WEST);
        BoundingBoxes.Strip.UP = BlockSmallElectricFloodlight.rotateAABB(BoundingBoxes.Strip.EAST, EnumFacing.UP);
        BoundingBoxes.Strip.DOWN = BlockSmallElectricFloodlight.rotateAABB(BoundingBoxes.Strip.EAST, EnumFacing.DOWN);
        BoundingBoxes.StripRotated.EAST = new AxisAlignedBB(0.0, 0.0, 0.3125, 0.1875, 1.0, 0.6875);
        BoundingBoxes.StripRotated.NORTH = BlockSmallElectricFloodlight.rotateAABB(BoundingBoxes.StripRotated.EAST, EnumFacing.NORTH);
        BoundingBoxes.StripRotated.SOUTH = BlockSmallElectricFloodlight.rotateAABB(BoundingBoxes.StripRotated.EAST, EnumFacing.SOUTH);
        BoundingBoxes.StripRotated.WEST = BlockSmallElectricFloodlight.rotateAABB(BoundingBoxes.StripRotated.EAST, EnumFacing.WEST);
        BoundingBoxes.StripRotated.UP = BlockSmallElectricFloodlight.rotateAABB(BoundingBoxes.StripRotated.EAST, EnumFacing.UP);
        BoundingBoxes.StripRotated.DOWN = BlockSmallElectricFloodlight.rotateAABB(BoundingBoxes.StripRotated.EAST, EnumFacing.DOWN);
        BoundingBoxes.Square.EAST = new AxisAlignedBB(0.0, 0.0, 0.0, 0.1875, 1.0, 1.0);
        BoundingBoxes.Square.NORTH = BlockSmallElectricFloodlight.rotateAABB(BoundingBoxes.Square.EAST, EnumFacing.NORTH);
        BoundingBoxes.Square.SOUTH = BlockSmallElectricFloodlight.rotateAABB(BoundingBoxes.Square.EAST, EnumFacing.SOUTH);
        BoundingBoxes.Square.WEST = BlockSmallElectricFloodlight.rotateAABB(BoundingBoxes.Square.EAST, EnumFacing.WEST);
        BoundingBoxes.Square.UP = BlockSmallElectricFloodlight.rotateAABB(BoundingBoxes.Square.EAST, EnumFacing.UP);
        BoundingBoxes.Square.DOWN = BlockSmallElectricFloodlight.rotateAABB(BoundingBoxes.Square.EAST, EnumFacing.DOWN);
    }

    private static class BoundingBoxes {
        private BoundingBoxes() {
        }

        static class Square {
            static AxisAlignedBB NORTH;
            static AxisAlignedBB SOUTH;
            static AxisAlignedBB EAST;
            static AxisAlignedBB WEST;
            static AxisAlignedBB UP;
            static AxisAlignedBB DOWN;

            Square() {
            }
        }

        static class StripRotated {
            static AxisAlignedBB NORTH;
            static AxisAlignedBB SOUTH;
            static AxisAlignedBB EAST;
            static AxisAlignedBB WEST;
            static AxisAlignedBB UP;
            static AxisAlignedBB DOWN;

            StripRotated() {
            }
        }

        static class Strip {
            static AxisAlignedBB NORTH;
            static AxisAlignedBB SOUTH;
            static AxisAlignedBB EAST;
            static AxisAlignedBB WEST;
            static AxisAlignedBB UP;
            static AxisAlignedBB DOWN;

            Strip() {
            }
        }
    }
}

