/*
 * Decompiled with CFR 0.152.
 */
package de.keridos.floodlights.core.network.message;

import de.keridos.floodlights.handler.PacketHandler;
import de.keridos.floodlights.tileentity.TileEntityFL;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntitySyncMessage
implements IMessage {
    private NonNullList<Object> data;
    private ByteBuf buffer;
    private int x;
    private int y;
    private int z;
    private int dim;

    public TileEntitySyncMessage() {
    }

    public TileEntitySyncMessage(BlockPos pos, World world, NonNullList<Object> data) {
        this.data = data;
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
        this.dim = world.field_73011_w.getDimension();
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.dim = buf.readInt();
        this.buffer = buf.copy();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.dim);
        PacketHandler.encode(this.data.toArray(), buf);
    }

    public static class Handler
    implements IMessageHandler<TileEntitySyncMessage, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(TileEntitySyncMessage message, MessageContext ctx) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            BlockPos pos = new BlockPos(message.x, message.y, message.z);
            if (!player.field_70170_p.func_175667_e(pos)) {
                return null;
            }
            Minecraft.func_71410_x().func_152344_a(() -> Handler.lambda$onMessage$0((EntityPlayer)player, pos, message));
            return null;
        }

        private static /* synthetic */ void lambda$onMessage$0(EntityPlayer player, BlockPos pos, TileEntitySyncMessage message) {
            TileEntity tileEntity = player.field_70170_p.func_175625_s(pos);
            if (tileEntity instanceof TileEntityFL) {
                ((TileEntityFL)tileEntity).applySyncData(message.buffer);
                ((TileEntityFL)tileEntity).rerenderBlock();
            }
        }
    }
}

