/*
 * Decompiled with CFR 0.152.
 */
package de.keridos.floodlights.tileentity;

import de.keridos.floodlights.core.NetworkDataList;
import de.keridos.floodlights.core.network.message.TileEntitySyncMessage;
import de.keridos.floodlights.handler.PacketHandler;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class TileEntityFL
extends TileEntity {
    protected static final int LIGHT_MODE_STRAIGHT = 0;
    protected static final int LIGHT_MODE_NARROW_CONE = 1;
    protected static final int LIGHT_MODE_WIDE_CONE = 2;
    protected HashSet<EntityPlayer> inventoryAccessors = new HashSet();
    protected boolean shouldRerender;
    protected EnumFacing orientation = EnumFacing.SOUTH;
    protected String customName = "";
    protected String owner = "";
    protected int mode;
    protected boolean inverted;
    protected int color = 0;
    private IBlockState cloak;

    public EnumFacing getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = EnumFacing.func_82600_a((int)orientation);
        this.syncData();
    }

    public void setOrientation(EnumFacing orientation) {
        this.orientation = orientation;
        this.syncData();
    }

    public String getCustomName() {
        return this.customName;
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        if (mode >= 0 && mode <= 2) {
            this.mode = mode;
        }
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
        this.syncData();
    }

    public boolean supportsCloak() {
        return false;
    }

    public IBlockState getCloak() {
        return this.supportsCloak() ? this.cloak : null;
    }

    public void setCloak(IBlockState cloak) {
        if (this.supportsCloak()) {
            this.cloak = cloak;
            this.func_70296_d();
            if (this.func_145830_o()) {
                this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
            }
        }
    }

    public final void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.readOwnFromNBT(nbtTagCompound);
    }

    public void readOwnFromNBT(NBTTagCompound nbtTagCompound) {
        Block cloakBlock;
        if (nbtTagCompound.func_74764_b("teDirection")) {
            this.orientation = EnumFacing.func_82600_a((int)nbtTagCompound.func_74771_c("teDirection"));
        }
        if (nbtTagCompound.func_74764_b("inverted")) {
            this.inverted = nbtTagCompound.func_74767_n("inverted");
        }
        if (nbtTagCompound.func_74764_b("CustomName")) {
            this.customName = nbtTagCompound.func_74779_i("CustomName");
        }
        if (nbtTagCompound.func_74764_b("owner")) {
            this.owner = nbtTagCompound.func_74779_i("owner");
        }
        if (nbtTagCompound.func_74764_b("teState")) {
            this.mode = nbtTagCompound.func_74762_e("teState");
        }
        if (nbtTagCompound.func_74764_b("color")) {
            this.color = nbtTagCompound.func_74762_e("color");
        }
        if (this.supportsCloak() && nbtTagCompound.func_74764_b("cloakBlock") && nbtTagCompound.func_74764_b("cloakBlockState") && (cloakBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(nbtTagCompound.func_74779_i("cloakBlock")))) != null) {
            this.cloak = cloakBlock.func_176203_a((int)nbtTagCompound.func_74771_c("cloakBlockState"));
        }
    }

    public final NBTTagCompound func_189515_b(NBTTagCompound nbtTagCompound) {
        nbtTagCompound = super.func_189515_b(nbtTagCompound);
        return this.writeOwnToNBT(nbtTagCompound);
    }

    public NBTTagCompound writeOwnToNBT(NBTTagCompound nbtTagCompound) {
        nbtTagCompound.func_74774_a("teDirection", (byte)this.getOrientation().ordinal());
        nbtTagCompound.func_74757_a("inverted", this.inverted);
        nbtTagCompound.func_74768_a("teState", this.mode);
        nbtTagCompound.func_74768_a("color", this.color);
        if (this.hasCustomName()) {
            nbtTagCompound.func_74778_a("CustomName", this.customName);
        }
        if (this.hasOwner()) {
            nbtTagCompound.func_74778_a("owner", this.owner);
        }
        if (this.supportsCloak() && this.cloak != null && !Block.func_149680_a((Block)Blocks.field_150350_a, (Block)this.cloak.func_177230_c())) {
            nbtTagCompound.func_74778_a("cloakBlock", this.cloak.func_177230_c().getRegistryName().toString());
            nbtTagCompound.func_74774_a("cloakBlockState", (byte)this.cloak.func_177230_c().func_176201_c(this.cloak));
        }
        return nbtTagCompound;
    }

    public void onInventoryOpen(EntityPlayer player) {
        this.inventoryAccessors.add(player);
        this.syncData(player);
    }

    public void onInventoryClose(EntityPlayer player) {
        this.inventoryAccessors.remove(player);
    }

    public void syncData(EntityPlayer player) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        NetworkDataList data = this.getSyncData(new NetworkDataList());
        PacketHandler.INSTANCE.sendTo((IMessage)new TileEntitySyncMessage(this.func_174877_v(), this.func_145831_w(), data), (EntityPlayerMP)player);
    }

    public void syncData() {
        if (!this.func_145830_o() || this.field_145850_b.field_72995_K) {
            return;
        }
        this.func_70296_d();
        NetworkDataList data = this.getSyncData(new NetworkDataList());
        PacketHandler.INSTANCE.sendToAll((IMessage)new TileEntitySyncMessage(this.field_174879_c, this.field_145850_b, data));
    }

    public NetworkDataList getSyncData(@Nonnull NetworkDataList data) {
        data.add(this.mode);
        data.add(this.inverted);
        data.add(this.color);
        data.add(this.getOrientation().func_176745_a());
        return data;
    }

    public void applySyncData(ByteBuf buffer) {
        this.mode = buffer.readInt();
        boolean inverted = buffer.readBoolean();
        int color = buffer.readInt();
        EnumFacing orientation = EnumFacing.func_82600_a((int)buffer.readInt());
        if (this.inverted != inverted || this.color != color || this.orientation != orientation) {
            this.shouldRerender = true;
        }
        this.inverted = inverted;
        this.color = color;
        this.orientation = orientation;
    }

    protected void syncWithAccessors() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        NetworkDataList data = this.getSyncData(new NetworkDataList());
        for (EntityPlayer player : this.inventoryAccessors) {
            PacketHandler.INSTANCE.sendTo((IMessage)new TileEntitySyncMessage(this.func_174877_v(), this.func_145831_w(), data), (EntityPlayerMP)player);
        }
    }

    public void rerenderBlock() {
        if (!this.shouldRerender) {
            return;
        }
        this.shouldRerender = false;
        if (this.func_145830_o()) {
            this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        }
    }

    public boolean hasCustomName() {
        return this.customName != null && this.customName.length() > 0;
    }

    public boolean hasOwner() {
        return this.owner != null && this.owner.length() > 0;
    }

    public boolean getInverted() {
        return this.inverted;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(super.func_189517_E_());
    }
}

