/*
 * Decompiled with CFR 0.152.
 */
package de.keridos.floodlights.tileentity;

import de.keridos.floodlights.block.BlockPhantomLight;
import de.keridos.floodlights.core.NetworkDataList;
import de.keridos.floodlights.handler.ConfigHandler;
import de.keridos.floodlights.init.ModBlocks;
import de.keridos.floodlights.tileentity.TileEntityFL;
import de.keridos.floodlights.tileentity.TileEntityPhantomLight;
import de.keridos.floodlights.util.GeneralUtil;
import de.keridos.floodlights.util.MathUtil;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAir;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public abstract class TileEntityMetaFloodlight
extends TileEntityFL
implements ITickable {
    protected boolean active;
    protected boolean wasActive;
    protected boolean hasRedstone;
    protected int timeout;
    protected ItemStackHandler inventory;
    protected Block lightBlock = ModBlocks.blockPhantomLight;
    protected int rangeStraight = ConfigHandler.rangeStraightFloodlight;
    protected int rangeCone = ConfigHandler.rangeConeFloodlight;
    protected int currentRange = this.rangeStraight;
    protected int lightBlockStep = 2;
    protected int floodlightId = new Random().nextInt();
    private AtomicBoolean executorActive = new AtomicBoolean(false);
    private boolean hasLight;

    public TileEntityMetaFloodlight() {
        this.inventory = this.createInventory();
    }

    public void setHasRedstoneSignal(boolean hasSignal) {
        this.hasRedstone = hasSignal;
        this.active = this.hasRedstone ^ this.inverted;
        this.syncData();
    }

    public void toggleInverted() {
        this.inverted = !this.inverted;
        this.active = this.hasRedstone ^ this.inverted;
        this.syncData();
    }

    public void notifyBlockRemoved() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.lightSource(true);
    }

    protected void createPhantomLight(BlockPos pos) {
        if (this.field_145850_b.func_180501_a(pos, this.lightBlock.func_176223_P(), 19)) {
            TileEntityPhantomLight light = (TileEntityPhantomLight)this.field_145850_b.func_175625_s(pos);
            light.addSource(this.field_174879_c, this.floodlightId);
        }
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.timeout > 0) {
            --this.timeout;
            return;
        }
        if (this.active && this.hasEnergy() && (this.wasActive != this.active || !this.hasLight)) {
            this.lightSource(false);
            this.wasActive = this.active;
        } else if (this.active && !this.hasEnergy() || !this.active && this.wasActive) {
            this.lightSource(true);
            this.timeout = ConfigHandler.timeoutFloodlights + 10;
            this.wasActive = false;
        }
    }

    protected boolean isCooledDown() {
        return this.timeout == 0 && !this.executorActive.get();
    }

    protected boolean hasEnergy() {
        return false;
    }

    protected boolean isReady() {
        return this.timeout == 0;
    }

    protected ItemStackHandler createInventory() {
        return new ItemStackHandler(this.getInventorySize()){

            protected void onContentsChanged(int slot) {
                if (slot == 1 && TileEntityMetaFloodlight.this.supportsCloak()) {
                    Item item = this.getStackInSlot(slot).func_77973_b();
                    if (item instanceof ItemAir) {
                        TileEntityMetaFloodlight.this.setCloak(null);
                    } else if (item instanceof ItemBlock && (TileEntityMetaFloodlight.this.getCloak() == null || !Block.func_149680_a((Block)((ItemBlock)item).func_179223_d(), (Block)TileEntityMetaFloodlight.this.getCloak().func_177230_c()))) {
                        TileEntityMetaFloodlight.this.setCloak(((ItemBlock)item).func_179223_d().func_176223_P());
                    }
                }
                super.onContentsChanged(slot);
                TileEntityMetaFloodlight.this.func_70296_d();
            }
        };
    }

    protected int getInventorySize() {
        return 1;
    }

    @Override
    public void readOwnFromNBT(NBTTagCompound nbtTagCompound) {
        super.readOwnFromNBT(nbtTagCompound);
        if (nbtTagCompound.func_74764_b("wasActive")) {
            this.wasActive = nbtTagCompound.func_74767_n("wasActive");
        }
        if (nbtTagCompound.func_74764_b("teLight")) {
            this.hasLight = nbtTagCompound.func_74767_n("teLight");
        }
        if (nbtTagCompound.func_74764_b("teRedstone")) {
            this.setHasRedstoneSignal(nbtTagCompound.func_74767_n("teRedstone"));
        }
        if (nbtTagCompound.func_74764_b("Items")) {
            this.inventory.deserializeNBT(nbtTagCompound.func_74775_l("Items"));
            if (this.inventory.getSlots() != this.getInventorySize()) {
                ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
                for (int i = 0; i < this.inventory.getSlots(); ++i) {
                    itemStacks.add(this.inventory.getStackInSlot(i));
                }
                ItemStackHandler newInventory = this.createInventory();
                for (ItemStack current : itemStacks) {
                    for (int j = 0; j < newInventory.getSlots() && !current.func_190926_b(); ++j) {
                        current = newInventory.insertItem(j, current, false);
                    }
                    if (current.func_190926_b()) continue;
                    EntityItem entityItem = new EntityItem(this.func_145831_w(), (double)this.func_174877_v().func_177958_n(), (double)(this.func_174877_v().func_177956_o() + 1), (double)this.func_174877_v().func_177952_p(), current);
                    this.func_145831_w().func_72838_d((Entity)entityItem);
                }
                this.inventory = newInventory;
            }
        }
        if (nbtTagCompound.func_74764_b("teRange")) {
            this.currentRange = nbtTagCompound.func_74762_e("teRange");
        }
        if (nbtTagCompound.func_74764_b("floodlightId")) {
            this.floodlightId = nbtTagCompound.func_74762_e("floodlightId");
        }
    }

    @Override
    public NBTTagCompound writeOwnToNBT(NBTTagCompound nbtTagCompound) {
        nbtTagCompound = super.writeOwnToNBT(nbtTagCompound);
        nbtTagCompound.func_74757_a("wasActive", this.wasActive);
        nbtTagCompound.func_74757_a("teLight", this.hasLight);
        nbtTagCompound.func_74757_a("teRedstone", this.hasRedstone);
        nbtTagCompound.func_74782_a("Items", (NBTBase)this.inventory.serializeNBT());
        nbtTagCompound.func_74768_a("teRange", this.currentRange);
        nbtTagCompound.func_74768_a("floodlightId", this.floodlightId);
        return nbtTagCompound;
    }

    @Override
    public NetworkDataList getSyncData(@Nonnull NetworkDataList data) {
        super.getSyncData(data);
        data.add(this.active);
        data.add(this.hasLight);
        return data;
    }

    @Override
    public void applySyncData(ByteBuf buffer) {
        super.applySyncData(buffer);
        this.active = buffer.readBoolean();
        this.hasLight = buffer.readBoolean();
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this.inventory : super.getCapability(capability, facing));
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    private void lightSource(boolean remove) {
        this.lightSource(remove, true);
    }

    private void lightSource(boolean remove, boolean wait) {
        if (this.hasLight == !remove) {
            return;
        }
        if (this.executorActive.get() && wait) {
            new Thread(() -> {
                for (int i = 0; i < 10; ++i) {
                    if (this.executorActive.get()) {
                        try {
                            Thread.sleep(400L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    this.lightSource(remove, false);
                }
            }).start();
        }
        if (this.mode >= 0 && this.mode <= 2) {
            this.hasLight = !remove;
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
        this.updateCurrentRange();
        switch (this.mode) {
            case 0: {
                this.straightSource(remove);
                break;
            }
            case 1: {
                this.narrowConeSource(remove);
                break;
            }
            case 2: {
                this.wideConeSource(remove);
            }
        }
    }

    public boolean hasLight() {
        return this.hasLight;
    }

    protected void straightSource(boolean remove) {
        int z;
        int y;
        int x;
        BlockPos blockPos;
        LightSwitchExecutor executor = new LightSwitchExecutor(remove);
        for (int i = 1; i <= this.currentRange && (this.field_145850_b.func_175623_d(blockPos = new BlockPos(x = this.field_174879_c.func_177958_n() + this.getOrientation().func_82601_c() * i, y = this.field_174879_c.func_177956_o() + this.getOrientation().func_96559_d() * i, z = this.field_174879_c.func_177952_p() + this.getOrientation().func_82599_e() * i)) || this.field_145850_b.func_180495_p(blockPos).func_177230_c() == this.lightBlock || remove); ++i) {
            if ((i - 1) % this.lightBlockStep != 0) continue;
            executor.add(blockPos);
        }
        executor.execute();
    }

    protected void wideConeSource(boolean remove) {
        LightSwitchExecutor executor = new LightSwitchExecutor(remove);
        boolean[] failedBeams = new boolean[9];
        if (!remove && this.field_145850_b.func_180495_p(GeneralUtil.getPosFromPosFacing(this.field_174879_c, this.getOrientation())).func_185914_p()) {
            return;
        }
        block20: for (int j = 0; j <= 16; ++j) {
            int z;
            int y;
            int x;
            int[] rotatedCoords;
            int c;
            int b;
            int i;
            if (j <= 8) {
                for (i = 1; i <= this.currentRange / 4; ++i) {
                    b = 0;
                    c = 0;
                    switch (j) {
                        case 0: {
                            b += i;
                            break;
                        }
                        case 1: {
                            b -= i;
                            break;
                        }
                        case 2: {
                            c += i;
                            break;
                        }
                        case 3: {
                            c -= i;
                            break;
                        }
                        case 4: {
                            b += i;
                            c += i;
                            break;
                        }
                        case 5: {
                            b += i;
                            c -= i;
                            break;
                        }
                        case 6: {
                            b -= i;
                            c += i;
                            break;
                        }
                        case 7: {
                            b -= i;
                            c -= i;
                        }
                    }
                    rotatedCoords = MathUtil.rotate(i, b, c, this.getOrientation());
                    x = this.field_174879_c.func_177958_n() + rotatedCoords[0];
                    y = this.field_174879_c.func_177956_o() + rotatedCoords[1];
                    z = this.field_174879_c.func_177952_p() + rotatedCoords[2];
                    if (this.field_145850_b.func_180495_p(new BlockPos(x, y, z)).func_185914_p() && !remove) {
                        if (i >= 4) continue block20;
                        failedBeams[j] = true;
                        continue block20;
                    }
                    if ((i - 1) % this.lightBlockStep != 0) continue;
                    executor.add(new BlockPos(x, y, z));
                }
                continue;
            }
            if (failedBeams[j - 9] && !remove) continue;
            for (i = 4; i <= this.rangeCone / 4; ++i) {
                b = 0;
                c = 0;
                switch (j) {
                    case 9: {
                        b += i / 2;
                        break;
                    }
                    case 10: {
                        b -= i / 2;
                        break;
                    }
                    case 11: {
                        c += i / 2;
                        break;
                    }
                    case 12: {
                        c -= i / 2;
                        break;
                    }
                    case 13: {
                        b += i / 2;
                        c += i / 2;
                        break;
                    }
                    case 14: {
                        b += i / 2;
                        c -= i / 2;
                        break;
                    }
                    case 15: {
                        b -= i / 2;
                        c += i / 2;
                        break;
                    }
                    case 16: {
                        b -= i / 2;
                        c -= i / 2;
                    }
                }
                rotatedCoords = MathUtil.rotate(i, b, c, this.getOrientation());
                x = this.field_174879_c.func_177958_n() + rotatedCoords[0];
                y = this.field_174879_c.func_177956_o() + rotatedCoords[1];
                z = this.field_174879_c.func_177952_p() + rotatedCoords[2];
                if (this.field_145850_b.func_180495_p(new BlockPos(x, y, z)).func_185914_p() && !remove) continue block20;
                if ((i - 1) % this.lightBlockStep != 0) continue;
                executor.add(new BlockPos(x, y, z));
            }
        }
        executor.execute();
    }

    protected void narrowConeSource(boolean remove) {
        LightSwitchExecutor executor = new LightSwitchExecutor(remove);
        boolean[] failedBeams = new boolean[9];
        block20: for (int j = 0; j <= 16; ++j) {
            BlockPos sourcePos;
            int z;
            int y;
            int x;
            int[] rotatedCoords;
            int c;
            int b;
            int i;
            if (j <= 8) {
                for (i = 1; i <= this.currentRange; ++i) {
                    if (i == 1) {
                        int z2;
                        int y2;
                        int x2 = this.field_174879_c.func_177958_n() + this.getOrientation().func_82601_c();
                        if (this.field_145850_b.func_180495_p(new BlockPos(x2, y2 = this.field_174879_c.func_177956_o() + this.getOrientation().func_96559_d(), z2 = this.field_174879_c.func_177952_p() + this.getOrientation().func_82599_e())).func_185914_p() && !remove) {
                            return;
                        }
                        executor.add(new BlockPos(x2, y2, z2));
                    }
                    b = 0;
                    c = 0;
                    switch (j) {
                        case 0: {
                            b += i / 2;
                            break;
                        }
                        case 1: {
                            b -= i / 2;
                            break;
                        }
                        case 2: {
                            c += i / 2;
                            break;
                        }
                        case 3: {
                            c -= i / 2;
                            break;
                        }
                        case 4: {
                            b += i / 2;
                            c += i / 2;
                            break;
                        }
                        case 5: {
                            b += i / 2;
                            c -= i / 2;
                            break;
                        }
                        case 6: {
                            b -= i / 2;
                            c += i / 2;
                            break;
                        }
                        case 7: {
                            b -= i / 2;
                            c -= i / 2;
                        }
                    }
                    rotatedCoords = MathUtil.rotate(i, b, c, this.getOrientation());
                    x = this.field_174879_c.func_177958_n() + rotatedCoords[0];
                    y = this.field_174879_c.func_177956_o() + rotatedCoords[1];
                    z = this.field_174879_c.func_177952_p() + rotatedCoords[2];
                    sourcePos = new BlockPos(x, y, z);
                    if (this.field_145850_b.func_180495_p(sourcePos).func_185914_p() && !remove) {
                        if (i >= 8) continue block20;
                        failedBeams[j] = true;
                        continue block20;
                    }
                    if ((i - 1) % this.lightBlockStep != 0) continue;
                    executor.add(sourcePos);
                }
                continue;
            }
            if (failedBeams[j - 9] && !remove) continue;
            for (i = 8; i <= this.rangeCone; ++i) {
                b = 0;
                c = 0;
                switch (j) {
                    case 9: {
                        b += i / 4;
                        break;
                    }
                    case 10: {
                        b -= i / 4;
                        break;
                    }
                    case 11: {
                        c += i / 4;
                        break;
                    }
                    case 12: {
                        c -= i / 4;
                        break;
                    }
                    case 13: {
                        b += i / 4;
                        c += i / 4;
                        break;
                    }
                    case 14: {
                        b += i / 4;
                        c -= i / 4;
                        break;
                    }
                    case 15: {
                        b -= i / 4;
                        c += i / 4;
                        break;
                    }
                    case 16: {
                        b -= i / 4;
                        c -= i / 4;
                    }
                }
                rotatedCoords = MathUtil.rotate(i, b, c, this.getOrientation());
                x = this.field_174879_c.func_177958_n() + rotatedCoords[0];
                y = this.field_174879_c.func_177956_o() + rotatedCoords[1];
                z = this.field_174879_c.func_177952_p() + rotatedCoords[2];
                sourcePos = new BlockPos(x, y, z);
                if (this.field_145850_b.func_180495_p(sourcePos).func_185914_p() && !remove) continue block20;
                if ((i - 1) % this.lightBlockStep != 0) continue;
                executor.add(sourcePos);
            }
        }
        executor.execute();
    }

    @Override
    public void setMode(int mode) {
        super.setMode(mode);
        this.updateCurrentRange();
    }

    public void changeMode(EntityPlayer player) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        String modeString = "";
        if (!this.active && this.isCooledDown()) {
            this.mode = this.mode == 2 ? 0 : this.mode + 1;
            this.updateCurrentRange();
            switch (this.mode) {
                case 0: {
                    modeString = "gui.floodlights:straight";
                    break;
                }
                case 1: {
                    modeString = "gui.floodlights:narrowCone";
                    break;
                }
                case 2: {
                    modeString = "gui.floodlights:wideCone";
                }
            }
        } else {
            modeString = "gui.floodlights:machineEnabledError";
        }
        player.func_145747_a((ITextComponent)new TextComponentTranslation("gui.floodlights:mode", new Object[]{GeneralUtil.safeLocalize(modeString)}));
    }

    private void updateCurrentRange() {
        this.currentRange = this.mode == 0 ? this.rangeStraight : this.rangeCone;
    }

    protected class LightSwitchExecutor
    implements Runnable {
        private static final int BATCH_SIZE = 5;
        private static final int BATCH_DELAY = 150;
        private static final int SOURCE_MODE_DISABLE_UPDATES = 0;
        private static final int SOURCE_MODE_CHANGE = 1;
        private static final int SOURCE_MODE_ENABLE_UPDATES = 2;
        private List<BlockPos> blocks = new ArrayList<BlockPos>();
        private IThreadListener threadListener;
        private int batches;
        private boolean remove;

        public LightSwitchExecutor(boolean remove) {
            this.remove = remove;
            this.threadListener = FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT ? Minecraft.func_71410_x() : FMLCommonHandler.instance().getMinecraftServerInstance();
        }

        public void add(BlockPos pos) {
            this.blocks.add(pos);
        }

        public void execute() {
            this.batches = (int)Math.ceil((float)this.blocks.size() / 5.0f);
            try {
                this.doExecute();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                TileEntityMetaFloodlight.this.executorActive.set(false);
            }
        }

        private void doExecute() {
            TileEntityMetaFloodlight.this.executorActive.set(true);
            this.executeMode(0, false);
            new Thread(this).start();
        }

        @Override
        public void run() {
            try {
                this.executeMode(1, true);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            TileEntityMetaFloodlight.this.executorActive.set(false);
        }

        private void executeMode(int mode, boolean async) {
            for (int batch = 0; batch < this.batches; ++batch) {
                int finalBatch = batch;
                Runnable task = () -> {
                    for (int i = finalBatch * 5; i < finalBatch * 5 + 5 && i < this.blocks.size(); ++i) {
                        this.setSource(this.blocks.get(i), mode);
                    }
                    if (mode == 1 && finalBatch == this.batches - 1 && !this.remove) {
                        this.executeMode(2, false);
                    }
                };
                if (async) {
                    this.threadListener.func_152344_a(task);
                } else {
                    task.run();
                }
                if (!async || mode != 1 || batch >= this.batches - 1) continue;
                try {
                    Thread.sleep(150L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        private void setSource(BlockPos blockPos, int sourceMode) {
            boolean lightExists = TileEntityMetaFloodlight.this.field_145850_b.func_180495_p(blockPos).func_177230_c() == TileEntityMetaFloodlight.this.lightBlock;
            switch (sourceMode) {
                case 0: {
                    if (!lightExists) break;
                    TileEntityMetaFloodlight.this.field_145850_b.func_180501_a(blockPos, TileEntityMetaFloodlight.this.field_145850_b.func_180495_p(blockPos).func_177226_a((IProperty)BlockPhantomLight.UPDATE, (Comparable)Boolean.valueOf(false)), 1);
                    break;
                }
                case 1: {
                    if (this.remove && lightExists) {
                        TileEntityPhantomLight light = (TileEntityPhantomLight)TileEntityMetaFloodlight.this.field_145850_b.func_175625_s(blockPos);
                        light.removeSource(TileEntityMetaFloodlight.this.field_174879_c);
                        break;
                    }
                    if (!this.remove && lightExists) {
                        TileEntityPhantomLight light = (TileEntityPhantomLight)TileEntityMetaFloodlight.this.field_145850_b.func_175625_s(blockPos);
                        light.addSource(TileEntityMetaFloodlight.this.field_174879_c, TileEntityMetaFloodlight.this.floodlightId);
                        break;
                    }
                    if (this.remove || lightExists || !TileEntityMetaFloodlight.this.field_145850_b.func_175623_d(blockPos)) break;
                    TileEntityMetaFloodlight.this.createPhantomLight(blockPos);
                    break;
                }
                case 2: {
                    if (!lightExists) break;
                    TileEntityMetaFloodlight.this.field_145850_b.func_180501_a(blockPos, TileEntityMetaFloodlight.this.field_145850_b.func_180495_p(blockPos).func_177226_a((IProperty)BlockPhantomLight.UPDATE, (Comparable)Boolean.valueOf(true)), 1);
                }
            }
        }
    }
}

