/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.block;

import doggytalents.DoggyTalents;
import doggytalents.ModBlocks;
import doggytalents.api.inferface.IBedMaterial;
import doggytalents.api.inferface.IDogBedRegistry;
import doggytalents.block.BedMaterial;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class DogBedRegistry
implements IDogBedRegistry {
    public static final DogBedRegistry CASINGS = new DogBedRegistry("casing");
    public static final DogBedRegistry BEDDINGS = new DogBedRegistry("bedding");
    private final List<IBedMaterial> REGISTRY = new ArrayList<IBedMaterial>();
    private final String key;

    public DogBedRegistry(String key) {
        this.key = key;
    }

    @Override
    public IBedMaterial registerMaterial(@Nonnull Block block, int meta, ResourceLocation textureLocation) {
        return this.registerMaterial(new BedMaterial(block, meta, textureLocation, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(block, 1, meta)})));
    }

    @Override
    public IBedMaterial registerMaterial(IBedMaterial material) {
        if (this.REGISTRY.contains(material)) {
            DoggyTalents.LOGGER.warn("Tried to register a dog bed material with the id {} more that once", (Object)material);
            return null;
        }
        this.REGISTRY.add(material.setRegName(this.key));
        DoggyTalents.LOGGER.debug("Register dog bed {} under the key {}", (Object)this.key, (Object)material);
        return material;
    }

    public List<IBedMaterial> getKeys() {
        return this.REGISTRY;
    }

    public IBedMaterial get(String saveId) {
        if (saveId == null || saveId.equals("missing")) {
            return IBedMaterial.NULL;
        }
        for (IBedMaterial thing : this.REGISTRY) {
            if (!thing.getSaveId().equals(saveId)) continue;
            return thing;
        }
        return IBedMaterial.getHolder(saveId);
    }

    public IBedMaterial getFromStack(ItemStack stack) {
        for (IBedMaterial m : this.REGISTRY) {
            if (!m.getIngredient().test((Object)stack)) continue;
            return m;
        }
        return IBedMaterial.NULL;
    }

    public static ItemStack createItemStack(IBedMaterial casingId, IBedMaterial beddingId) {
        ItemStack stack = new ItemStack(ModBlocks.DOG_BED, 1);
        stack.func_77982_d(new NBTTagCompound());
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("casingId", casingId.getSaveId());
        tag.func_74778_a("beddingId", beddingId.getSaveId());
        stack.func_77978_p().func_74782_a("doggytalents", (NBTBase)tag);
        return stack;
    }
}

