/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.ucw;

import com.google.gson.JsonObject;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import pl.asie.ucw.UCWJsonUtils;
import pl.asie.ucw.UCWObjectFactory;

public class UCWBlockRule {
    protected final List<IBlockState> from;
    protected final List<IBlockState> overlay;
    protected final List<IBlockState> through;
    protected final List<IBlockState> basedUpon;
    @Nonnull
    protected final Block fromBlock;
    @Nonnull
    protected final Block throughBlock;
    @Nonnull
    protected final Block basedUponBlock;
    @Nonnull
    protected final Block overlayBlock;
    protected final TIntObjectMap<UCWObjectFactory> objectFactories = new TIntObjectHashMap();
    protected final String prefix;
    protected final String group;
    @Nullable
    protected final String customBlockClass;
    @Nullable
    protected final String customItemClass;
    @Nullable
    protected final String customColorClass;
    protected final BlendMode mode;
    protected final int fromCount;
    private final boolean hasColor;

    public UCWBlockRule(JsonObject object) throws Exception {
        this.from = UCWJsonUtils.parseStateList(object.get("from").getAsJsonObject(), true);
        this.through = UCWJsonUtils.parseStateList(object.get("through").getAsJsonObject(), true);
        this.basedUpon = UCWJsonUtils.parseStateList(object.get("based_upon").getAsJsonObject(), true);
        this.fromBlock = UCWBlockRule.getBlock(this.from);
        this.throughBlock = UCWBlockRule.getBlock(this.through);
        this.basedUponBlock = UCWBlockRule.getBlock(this.basedUpon);
        if (object.has("overlay")) {
            this.overlay = UCWJsonUtils.parseStateList(object.get("overlay").getAsJsonObject(), true);
            this.overlayBlock = UCWBlockRule.getBlock(this.overlay);
        } else {
            this.overlay = this.from;
            this.overlayBlock = this.fromBlock;
        }
        this.mode = object.has("mode") ? BlendMode.valueOf(object.get("mode").getAsString().toUpperCase()) : BlendMode.NONE;
        this.customBlockClass = object.has("custom_block_class") ? object.get("custom_block_class").getAsString() : null;
        this.customItemClass = object.has("custom_item_class") ? object.get("custom_item_class").getAsString() : null;
        this.customColorClass = object.has("custom_color_class") ? object.get("custom_color_class").getAsString() : null;
        this.hasColor = this.customColorClass != null || object.has("has_color");
        int fc = 0;
        for (IBlockState state : this.from) {
            if (state == null) continue;
            ++fc;
        }
        this.fromCount = fc;
        this.group = object.has("group") ? object.get("group").getAsString() : this.fromBlock.getRegistryName().toString();
        String s1 = this.throughBlock.getRegistryName().toString().trim().replaceAll("[^A-Za-z0-9]", "_");
        String s2 = this.fromBlock.getRegistryName().toString().trim().replaceAll("[^A-Za-z0-9]", "_");
        this.prefix = s1 + "_" + s2 + "_";
        for (int i = 0; i < this.from.size(); ++i) {
            if (this.from.get(i) == null) continue;
            IBlockState state = this.from.get(i);
            String s = this.prefix + state.func_177230_c().func_176201_c(state);
            this.objectFactories.put(i, (Object)new UCWObjectFactory(this, state, new ResourceLocation("unlimitedchiselworks", s)));
        }
    }

    public boolean hasColor() {
        return this.hasColor;
    }

    public int hashCode() {
        return 7 * (17 * this.from.hashCode() + this.through.hashCode()) + this.basedUpon.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof UCWBlockRule) {
            UCWBlockRule other = (UCWBlockRule)o;
            return other.from.equals(this.from) && other.through.equals(this.through) && other.basedUpon.equals(this.basedUpon);
        }
        return false;
    }

    public String toString() {
        return "[UCWBlockRule: " + this.fromBlock.getRegistryName() + " -> " + this.throughBlock.getRegistryName() + " (" + this.basedUponBlock.getRegistryName() + ")]";
    }

    public boolean isValid() {
        return !this.from.isEmpty() && !this.overlay.isEmpty() && !this.through.isEmpty() && (this.basedUpon.size() == 1 || this.basedUpon.size() == this.through.size()) && this.fromBlock != Blocks.field_150350_a && this.overlayBlock != Blocks.field_150350_a && this.throughBlock != Blocks.field_150350_a && this.basedUponBlock != Blocks.field_150350_a;
    }

    public void registerBlocks(IForgeRegistry<Block> blocks) {
        for (UCWObjectFactory objectFactory : this.objectFactories.valueCollection()) {
            if (blocks.containsKey(objectFactory.getBlock().getRegistryName())) continue;
            blocks.register((IForgeRegistryEntry)objectFactory.getBlock());
        }
    }

    public void registerItems(IForgeRegistry<Item> items) {
        for (UCWObjectFactory objectFactory : this.objectFactories.valueCollection()) {
            if (items.containsKey(objectFactory.getItem().getRegistryName())) continue;
            items.register((IForgeRegistryEntry)objectFactory.getItem());
        }
    }

    private static Block getBlock(List<IBlockState> list) {
        for (IBlockState state : list) {
            if (state == null) continue;
            return state.func_177230_c();
        }
        return Blocks.field_150350_a;
    }

    public static enum BlendMode {
        NONE,
        BLEND,
        PLANK;

    }
}

