/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.ucw;

public final class UCWColorspaceUtils {
    private static final float[] D65_WHITE = new float[]{0.9504f, 1.0f, 1.0888f};
    private static final float E = 0.008856f;
    private static final float K = 903.3f;
    private static final float KE = 7.999625f;
    private static final float E_CBRT = 0.20689304f;

    private UCWColorspaceUtils() {
    }

    public static float sRGBtoLuma(float[] v) {
        float v1 = (float)(0.2126729 * (double)v[0] + 0.7151522 * (double)v[1] + 0.072175 * (double)v[2]);
        float yr = v1 / D65_WHITE[1];
        float fy = yr > 0.008856f ? (float)Math.cbrt(yr) : (903.3f * yr + 16.0f) / 116.0f;
        return 116.0f * fy - 16.0f;
    }

    public static float[] XYZtoLAB(float[] v) {
        float xr = v[0] / D65_WHITE[0];
        float yr = v[1] / D65_WHITE[1];
        float zr = v[2] / D65_WHITE[2];
        float fx = xr > 0.008856f ? (float)Math.cbrt(xr) : (903.3f * xr + 16.0f) / 116.0f;
        float fy = yr > 0.008856f ? (float)Math.cbrt(yr) : (903.3f * yr + 16.0f) / 116.0f;
        float fz = zr > 0.008856f ? (float)Math.cbrt(zr) : (903.3f * zr + 16.0f) / 116.0f;
        return new float[]{116.0f * fy - 16.0f, 500.0f * (fx - fy), 200.0f * (fy - fz)};
    }

    public static float[] LABtoXYZ(float[] v) {
        float yr;
        float zr;
        float fy = (v[0] + 16.0f) / 116.0f;
        float fx = v[1] / 500.0f + fy;
        float fz = fy - v[2] / 200.0f;
        float xr = fx > 0.20689304f ? fx * fx * fx : (116.0f * fx - 16.0f) / 903.3f;
        float f = zr = fz > 0.20689304f ? fz * fz * fz : (116.0f * fz - 16.0f) / 903.3f;
        if (v[0] > 7.999625f) {
            yr = (v[0] + 16.0f) / 116.0f;
            yr *= yr * yr;
        } else {
            yr = v[0] / 903.3f;
        }
        return new float[]{xr * D65_WHITE[0], yr * D65_WHITE[1], zr * D65_WHITE[2]};
    }

    private static int asFF(float f) {
        if (f >= 1.0f) {
            return 255;
        }
        if (f <= 0.0f) {
            return 0;
        }
        return Math.round(f * 255.0f) & 0xFF;
    }

    public static int asInt(float[] v) {
        return UCWColorspaceUtils.asFF(v[0]) << 16 | UCWColorspaceUtils.asFF(v[1]) << 8 | UCWColorspaceUtils.asFF(v[2]);
    }

    public static float[] fromInt(int v) {
        return new float[]{(float)(v >> 16 & 0xFF) / 255.0f, (float)(v >> 8 & 0xFF) / 255.0f, (float)(v & 0xFF) / 255.0f};
    }

    public static float[] sRGBtoXYZ(float[] v) {
        return new float[]{(float)(0.4124564 * (double)v[0] + 0.3575761 * (double)v[1] + 0.1804375 * (double)v[2]), (float)(0.2126729 * (double)v[0] + 0.7151522 * (double)v[1] + 0.072175 * (double)v[2]), (float)(0.0193339 * (double)v[0] + 0.119192 * (double)v[1] + 0.9503041 * (double)v[2])};
    }

    public static float[] XYZtosRGB(float[] v) {
        return new float[]{(float)(3.2404542 * (double)v[0] + -1.5371385 * (double)v[1] + -0.4985314 * (double)v[2]), (float)(-0.969266 * (double)v[0] + 1.8760108 * (double)v[1] + 0.041556 * (double)v[2]), (float)(0.0556434 * (double)v[0] + -0.2040259 * (double)v[1] + 1.0572252 * (double)v[2])};
    }

    private static void printArray(float[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            System.out.printf(i > 0 ? ", " : "[", new Object[0]);
            System.out.printf("%.3f", Float.valueOf(arr[i]));
        }
        System.out.println("]");
    }

    public static void main(String[] args) {
        int rgb = 0x800080;
        float[] tmp = UCWColorspaceUtils.fromInt(rgb);
        UCWColorspaceUtils.printArray(tmp);
        tmp = UCWColorspaceUtils.sRGBtoXYZ(tmp);
        UCWColorspaceUtils.printArray(tmp);
        tmp = UCWColorspaceUtils.XYZtoLAB(tmp);
        UCWColorspaceUtils.printArray(tmp);
        tmp = UCWColorspaceUtils.LABtoXYZ(tmp);
        UCWColorspaceUtils.printArray(tmp);
        tmp = UCWColorspaceUtils.XYZtosRGB(tmp);
        UCWColorspaceUtils.printArray(tmp);
    }
}

