/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.ucw;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.data.IMetadataSection;
import net.minecraft.client.resources.data.MetadataSerializer;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import pl.asie.ucw.UCWUtils;
import pl.asie.ucw.UnlimitedChiselWorks;

public class UCWFakeResourcePack
implements IResourcePack,
IResourceManagerReloadListener {
    public static final UCWFakeResourcePack INSTANCE = new UCWFakeResourcePack();
    private static final boolean DEBUG = false;
    private final Map<ResourceLocation, byte[]> data = new HashMap<ResourceLocation, byte[]>();
    private final Map<ResourceLocation, JsonElement> jsonCache = new HashMap<ResourceLocation, JsonElement>();
    private final Set<String> domains = ImmutableSet.of((Object)"ucw_generated");
    private final Minecraft mc = Minecraft.func_71410_x();

    private UCWFakeResourcePack() {
    }

    public JsonElement parseJsonElement(String[] str, JsonElement element) {
        if (element.isJsonObject()) {
            JsonObject parent = element.getAsJsonObject();
            JsonObject object = new JsonObject();
            for (Map.Entry entry : parent.entrySet()) {
                object.add((String)entry.getKey(), this.parseJsonElement(str, (JsonElement)entry.getValue()));
            }
            return object;
        }
        if (element.isJsonArray()) {
            JsonArray parent = element.getAsJsonArray();
            JsonArray array = new JsonArray();
            for (JsonElement element1 : parent) {
                array.add(this.parseJsonElement(str, element1));
            }
            return array;
        }
        if (!element.isJsonNull()) {
            String s = element.getAsString();
            if (s != null && s.startsWith(str[1] + ":")) {
                String ns = UCWUtils.toUcwGenerated(ResourceLocation.func_177516_a((String)s), str[0]);
                return new JsonPrimitive(ns);
            }
            return element;
        }
        return element;
    }

    public InputStream func_110590_a(ResourceLocation location) throws IOException {
        if (location.func_110623_a().endsWith(".png")) {
            return new ByteArrayInputStream(new byte[0]);
        }
        if (!this.data.containsKey(location)) {
            byte[] out;
            JsonElement element;
            String[] str = UCWUtils.getUcwLocationData(location);
            ResourceLocation nonProxiedLoc = new ResourceLocation(str[1], str[2]);
            if (this.jsonCache.containsKey(nonProxiedLoc)) {
                element = this.jsonCache.get(nonProxiedLoc);
            } else {
                try (IResource nonProxiedResource = this.mc.func_110442_L().func_110536_a(nonProxiedLoc);
                     InputStream nonProxied = nonProxiedResource.func_110527_b();
                     InputStreamReader reader = new InputStreamReader(nonProxied);){
                    element = (JsonElement)JsonUtils.func_193839_a((Gson)UnlimitedChiselWorks.GSON, (Reader)reader, JsonElement.class);
                }
                catch (Exception e) {
                    element = null;
                }
            }
            if (element != null) {
                JsonElement newElement = this.parseJsonElement(str, element);
                out = UnlimitedChiselWorks.GSON.toJson(newElement).getBytes(Charsets.UTF_8);
            } else if (this.data.containsKey(nonProxiedLoc)) {
                out = this.data.get(nonProxiedLoc);
            } else {
                try (IResource nonProxiedResource = this.mc.func_110442_L().func_110536_a(nonProxiedLoc);
                     InputStream nonProxied = nonProxiedResource.func_110527_b();){
                    out = ByteStreams.toByteArray((InputStream)nonProxied);
                    this.data.put(nonProxiedLoc, out);
                }
                catch (Exception e) {
                    out = null;
                }
            }
            this.data.put(location, out);
            return new ByteArrayInputStream(out);
        }
        return new ByteArrayInputStream(this.data.get(location));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean func_110589_b(ResourceLocation location) {
        if (location.func_110623_a().endsWith(".png")) {
            return true;
        }
        String[] str = UCWUtils.getUcwLocationData(location);
        if (str == null) return false;
        if (str[1].isEmpty()) {
            return false;
        }
        try (IResource resource = this.mc.func_110442_L().func_110536_a(new ResourceLocation(str[1], str[2]));){
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Set<String> func_110587_b() {
        return this.domains;
    }

    @Nullable
    public <T extends IMetadataSection> T func_135058_a(MetadataSerializer metadataSerializer, String metadataSectionName) throws IOException {
        return null;
    }

    public BufferedImage func_110586_a() throws IOException {
        return null;
    }

    public String func_130077_b() {
        return "UCWFakePack";
    }

    public void func_110549_a(IResourceManager resourceManager) {
        this.invalidate();
    }

    public void invalidate() {
        this.data.clear();
        this.jsonCache.clear();
    }
}

