/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.ucw;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import gnu.trove.set.hash.TIntHashSet;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import pl.asie.ucw.UCWUtils;

public final class UCWJsonUtils {
    private static final Method WITH_PROPERTY = ReflectionHelper.findMethod(IBlockState.class, (String)"withProperty", (String)"func_177226_a", (Class[])new Class[]{IProperty.class, Comparable.class});
    private static final Class CARVABLE_CLASS = UCWUtils.findClass("team.chisel.common.block.BlockCarvable");

    private UCWJsonUtils() {
    }

    private static IBlockState parseState(String s) throws Exception {
        String[] stateStr = s.split("#", 2);
        ResourceLocation blockLoc = new ResourceLocation(stateStr[0]);
        if (ForgeRegistries.BLOCKS.containsKey(blockLoc)) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(blockLoc);
            IBlockState state = block.func_176223_P();
            if (stateStr.length > 1) {
                for (String stateParam : stateStr[1].split(",")) {
                    Optional optValue;
                    IProperty property;
                    String[] stateKv = stateParam.split("=", 2);
                    if (stateKv.length <= 1 || (property = block.func_176194_O().func_185920_a(stateKv[0])) == null || !(optValue = property.func_185929_b(stateKv[1])).isPresent()) continue;
                    state = (IBlockState)WITH_PROPERTY.invoke((Object)state, property, optValue.get());
                }
            }
            return state;
        }
        return null;
    }

    public static List<IBlockState> parseStateList(JsonObject object, boolean orderMatters) throws Exception {
        if (object.has("block")) {
            ResourceLocation blockLoc = new ResourceLocation(object.get("block").getAsString());
            if (ForgeRegistries.BLOCKS.containsKey(blockLoc)) {
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(blockLoc);
                ArrayList<IBlockState> stateList = new ArrayList<IBlockState>(16);
                if (CARVABLE_CLASS != null && CARVABLE_CLASS.isAssignableFrom(block.getClass())) {
                    try {
                        IBlockState nextState;
                        IBlockState lastState = null;
                        int i = 0;
                        while (i < 16 && (nextState = block.func_176203_a(i++)) != lastState) {
                            stateList.add(nextState);
                            lastState = nextState;
                        }
                    }
                    catch (IllegalArgumentException lastState) {
                        // empty catch block
                    }
                    return stateList;
                }
                Set states = Sets.newIdentityHashSet();
                states.addAll(block.func_176194_O().func_177619_a());
                TIntHashSet validMetas = new TIntHashSet();
                for (int i = 0; i < 16; ++i) {
                    stateList.add(null);
                }
                for (IBlockState state : block.func_176194_O().func_177619_a()) {
                    validMetas.add(block.func_176201_c(state));
                }
                for (int i : validMetas) {
                    try {
                        IBlockState state = block.func_176203_a(i);
                        if (!states.remove(state)) continue;
                        stateList.set(i, state);
                    }
                    catch (Exception exception) {}
                }
                while (stateList.size() >= 1 && stateList.get(stateList.size() - 1) == null) {
                    stateList.remove(stateList.size() - 1);
                }
                return stateList;
            }
            return Collections.emptyList();
        }
        if (object.has("state")) {
            JsonElement element = object.get("state");
            if (element.isJsonArray()) {
                ArrayList stateList = Lists.newArrayList();
                for (int i = 0; i < 16; ++i) {
                    stateList.add(i, null);
                }
                for (JsonElement el : element.getAsJsonArray()) {
                    IBlockState state = UCWJsonUtils.parseState(el.getAsString());
                    if (state == null) continue;
                    stateList.set(state.func_177230_c().func_176201_c(state), state);
                }
                return stateList;
            }
            IBlockState state = UCWJsonUtils.parseState(element.getAsString());
            if (state != null) {
                return Collections.singletonList(state);
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }
}

