/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.ucw;

import com.google.common.collect.ImmutableList;
import java.awt.image.BufferedImage;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import pl.asie.ucw.UCWBlockRule;
import pl.asie.ucw.UCWColorspaceUtils;
import pl.asie.ucw.UnlimitedChiselWorks;

public final class UCWMagic {
    private static final List<int[][]> fakeTextureFrameList = ImmutableList.of((Object)new int[1][256]);
    public static final BufferedImage missingNo = new BufferedImage(16, 16, 2);

    private UCWMagic() {
    }

    public static ResourceLocation getLocation(IBlockState state, ModelResourceLocation location, IModel model) {
        boolean hasTextureList;
        String variant;
        IProperty variantProp;
        String[] name;
        String domain = location.func_110624_b();
        if ("forestry".equals(domain)) {
            name = state.func_177230_c().getRegistryName().func_110623_a().split("\\.", 2);
            variantProp = state.func_177230_c().func_176194_O().func_185920_a("variant");
            if (variantProp != null) {
                variant = variantProp.func_177702_a(state.func_177229_b(variantProp));
                if (name.length == 2 && "planks".equals(name[0])) {
                    return new ResourceLocation("forestry", "blocks/wood/" + name[0] + "." + variant);
                }
            }
        } else if ("extratrees".equals(domain)) {
            name = state.func_177230_c().getRegistryName().func_110623_a().split("\\.", 2);
            variantProp = state.func_177230_c().func_176194_O().func_185920_a("variant");
            if (variantProp != null) {
                variant = variantProp.func_177702_a(state.func_177229_b(variantProp));
                if (name.length == 2 && "planks".equals(name[0])) {
                    return new ResourceLocation("extratrees", "blocks/planks/" + variant);
                }
            }
        }
        if (model == null) {
            UnlimitedChiselWorks.LOGGER.error("Could not find model for " + location + " (" + state.func_177230_c() + ")");
            return TextureMap.field_174945_f;
        }
        boolean bl = hasTextureList = model.getTextures() != null;
        if (hasTextureList && model.getTextures().size() == 1) {
            return (ResourceLocation)model.getTextures().iterator().next();
        }
        try {
            IBakedModel bakedModel = model.bake((IModelState)TRSRTransformation.identity(), DefaultVertexFormats.field_176599_b, FakeSprite::new);
            List quadList = bakedModel.func_188616_a(state, EnumFacing.NORTH, 0L);
            if (quadList.size() > 0) {
                return new ResourceLocation(((BakedQuad)quadList.iterator().next()).func_187508_a().func_94215_i());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (hasTextureList) {
            return (ResourceLocation)model.getTextures().iterator().next();
        }
        UnlimitedChiselWorks.LOGGER.error("Bug? Model for " + location + " (" + state.func_177230_c() + ") provides null texture list!");
        return TextureMap.field_174945_f;
    }

    private static float toLuma(int rgb) {
        return UCWColorspaceUtils.sRGBtoLuma(UCWColorspaceUtils.fromInt(rgb));
    }

    private static float[] toLAB(int rgb) {
        return UCWColorspaceUtils.XYZtoLAB(UCWColorspaceUtils.sRGBtoXYZ(UCWColorspaceUtils.fromInt(rgb)));
    }

    private static int fromLAB(float[] lab) {
        return UCWColorspaceUtils.asInt(UCWColorspaceUtils.XYZtosRGB(UCWColorspaceUtils.LABtoXYZ(lab)));
    }

    private static float[] calculateContrast(int[] data) {
        float[] contrast = new float[]{Float.MAX_VALUE, Float.MIN_VALUE};
        for (int i : data) {
            float d = UCWMagic.toLuma(i);
            if (contrast[0] > d) {
                contrast[0] = d;
            }
            if (!(contrast[1] < d)) continue;
            contrast[1] = d;
        }
        contrast[1] = contrast[1] - contrast[0];
        return contrast;
    }

    public static int[][] createBaseForColorMultiplier(TextureAtlasSprite texture, boolean keepTinting) {
        int i;
        int[][] frames = new int[texture.func_110970_k()][texture.func_94211_a() * texture.func_94216_b()];
        int divider = texture.func_94211_a() * texture.func_94216_b() * texture.func_110970_k();
        double avgLuma = 0.0;
        for (i = 0; i < texture.func_110970_k(); ++i) {
            for (int v : texture.func_147965_a(i)[0]) {
                avgLuma += (double)UCWMagic.toLuma(v);
            }
        }
        avgLuma /= (double)divider;
        for (i = 0; i < texture.func_110970_k(); ++i) {
            int[] data = texture.func_147965_a(i)[0];
            for (int j = 0; j < texture.func_94211_a() * texture.func_94216_b(); ++j) {
                float[] hd = UCWMagic.toLAB(data[j]);
                frames[i][j] = data[j] & 0xFF000000 | UCWMagic.fromLAB(new float[]{(float)((double)hd[0] / avgLuma * 100.0), keepTinting ? hd[1] : 0.0f, keepTinting ? hd[2] : 0.0f});
            }
        }
        return frames;
    }

    public static int[] transform(TextureAtlasSprite sprite, int frame, TextureAtlasSprite from, TextureAtlasSprite overlay, TextureAtlasSprite basedUpon, UCWBlockRule.BlendMode mode) {
        int[] texture = sprite.func_147965_a(frame)[0];
        int width = sprite.func_94211_a();
        int height = sprite.func_94216_b();
        float[] contrastFrom = UCWMagic.calculateContrast(from.func_147965_a(0)[0]);
        float[] contrastBasedUpon = UCWMagic.calculateContrast(basedUpon.func_147965_a(0)[0]);
        double avgA = 0.0;
        double avgB = 0.0;
        double[] rangeA = new double[2];
        double[] rangeB = new double[2];
        int[] rangeDiv = new int[2];
        if (mode == UCWBlockRule.BlendMode.PLANK) {
            for (int i : from.func_147965_a(0)[0]) {
                float[] hd = UCWMagic.toLAB(i);
                double normV = (double)(hd[0] - contrastFrom[0]) / (double)contrastFrom[1];
                if (normV < 0.5) {
                    rangeA[0] = rangeA[0] + (double)hd[1];
                    rangeB[0] = rangeB[0] + (double)hd[2];
                    rangeDiv[0] = rangeDiv[0] + 1;
                    continue;
                }
                rangeA[1] = rangeA[1] + (double)hd[1];
                rangeB[1] = rangeB[1] + (double)hd[2];
                rangeDiv[1] = rangeDiv[1] + 1;
            }
            if (rangeDiv[0] > 0) {
                rangeA[0] = rangeA[0] / (double)rangeDiv[0];
                rangeB[0] = rangeB[0] / (double)rangeDiv[0];
            }
            if (rangeDiv[1] > 0) {
                rangeA[1] = rangeA[1] / (double)rangeDiv[1];
                rangeB[1] = rangeB[1] / (double)rangeDiv[1];
            }
        }
        if (mode == UCWBlockRule.BlendMode.BLEND) {
            for (int i : from.func_147965_a(0)[0]) {
                float[] data = UCWMagic.toLAB(i);
                avgA += (double)data[1];
                avgB += (double)data[2];
            }
            avgA /= (double)(from.func_94211_a() * from.func_94216_b());
            avgB /= (double)(from.func_94211_a() * from.func_94216_b());
        }
        int[] texData = new int[texture.length];
        for (int iy = 0; iy < height; ++iy) {
            for (int ix = 0; ix < width; ++ix) {
                int i;
                i = iy * width + ix;
                int it = texture[i];
                int ibu = overlay.func_147965_a(0)[0][iy % from.func_94216_b() * from.func_94211_a() + ix % from.func_94211_a()];
                float[] hsbTex = UCWMagic.toLAB(it);
                float[] hsbBu = UCWMagic.toLAB(ibu);
                double normV = (double)contrastBasedUpon[1] != 0.0 ? (double)(hsbTex[0] - contrastBasedUpon[0]) / (double)contrastBasedUpon[1] : 0.5;
                float v = (float)(normV * (double)contrastFrom[1] + (double)contrastFrom[0]);
                if (mode == UCWBlockRule.BlendMode.BLEND) {
                    hsbBu[1] = (float)avgA;
                    hsbBu[2] = (float)avgB;
                } else if (mode == UCWBlockRule.BlendMode.PLANK) {
                    double nv2 = normV;
                    if (nv2 < 0.0) {
                        nv2 = 0.0;
                    } else if (nv2 > 1.0) {
                        nv2 = 1.0;
                    }
                    hsbBu[1] = (float)(rangeA[1] * nv2 + rangeA[0] * (1.0 - nv2));
                    hsbBu[2] = (float)(rangeB[1] * nv2 + rangeB[0] * (1.0 - nv2));
                }
                if (v < 0.0f) {
                    v = 0.0f;
                } else if (v > 100.0f) {
                    v = 100.0f;
                }
                texData[i] = it & 0xFF000000 | UCWMagic.fromLAB(new float[]{v, hsbBu[1], hsbBu[2]});
            }
        }
        return texData;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            missingNo.setRGB(i & 0xF, i >> 4, ((i ^ i >> 4) & 8) != 0 ? -16777216 : -65281);
        }
    }

    private static class FakeSprite
    extends TextureAtlasSprite {
        protected FakeSprite(ResourceLocation spriteName) {
            super(spriteName.toString());
            this.func_110966_b(16);
            this.func_110969_c(16);
            this.func_110971_a(16, 16, 0, 0, false);
            this.func_110968_a(fakeTextureFrameList);
        }
    }
}

