/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.ucw;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import pl.asie.ucw.BlockUCWProxy;
import pl.asie.ucw.IUCWBlock;
import pl.asie.ucw.ItemUCWProxy;
import pl.asie.ucw.UCWBlockRule;
import pl.asie.ucw.UCWObjectBroker;

public class UCWObjectFactory {
    private final UCWBlockRule rule;
    private final ResourceLocation location;
    protected final IBlockState base;
    protected Block block;
    protected Item item;

    public UCWObjectFactory(UCWBlockRule rule, IBlockState base, ResourceLocation location) {
        this.rule = rule;
        this.base = base;
        this.location = location;
    }

    public IBlockState getBase() {
        return this.base;
    }

    public Block getBlock() {
        if (this.block == null) {
            UCWObjectBroker broker;
            block5: {
                broker = UCWObjectBroker.get();
                broker.begin(this.rule, this.base);
                if (this.rule.customBlockClass != null) {
                    try {
                        Class<?> c = Class.forName(this.rule.customBlockClass);
                        this.block = (Block)c.getConstructor(new Class[0]).newInstance(new Object[0]);
                        if (!(this.block instanceof IUCWBlock)) {
                            throw new RuntimeException("Not an UCW block!");
                        }
                        break block5;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                this.block = new BlockUCWProxy();
            }
            this.block.setRegistryName(this.location);
            broker.end();
        }
        return this.block;
    }

    public Item getItem() {
        if (this.item == null) {
            UCWObjectBroker broker = UCWObjectBroker.get();
            broker.begin(this.rule, this.base);
            if (this.rule.customItemClass != null) {
                try {
                    Class<?> c = Class.forName(this.rule.customItemClass);
                    this.item = (Item)c.getConstructor(Block.class).newInstance(this.block);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else {
                this.item = new ItemUCWProxy(this.block);
            }
            this.item.setRegistryName(this.location);
            broker.end();
        }
        return this.item;
    }

    public boolean isBlockRegistered() {
        return this.block != null && ForgeRegistries.BLOCKS.containsValue((IForgeRegistryEntry)this.block);
    }

    public boolean isItemRegistered() {
        return this.item != null && ForgeRegistries.ITEMS.containsValue((IForgeRegistryEntry)this.item);
    }
}

