/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.ucw;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import pl.asie.ucw.TintApplyingModel;
import pl.asie.ucw.UCWBlockRule;
import pl.asie.ucw.UCWColorProxy;
import pl.asie.ucw.UCWFakeResourcePack;
import pl.asie.ucw.UCWFakeTextureMap;
import pl.asie.ucw.UCWMagic;
import pl.asie.ucw.UCWObjectFactory;
import pl.asie.ucw.UCWProxyCommon;
import pl.asie.ucw.UCWUtils;
import pl.asie.ucw.UCWVanillaModelRemapper;
import pl.asie.ucw.UnlimitedChiselWorks;
import pl.asie.ucw.util.BlockStateUtil;
import pl.asie.ucw.util.ModelLoaderEarlyView;
import team.chisel.ctm.api.event.TextureCollectedEvent;

public class UCWProxyClient
extends UCWProxyCommon {
    private Map<String, JsonObject> chiselCache = new HashMap<String, JsonObject>();
    private Boolean chiselUsesSeparatedStates;
    private final Deque<ProgressManager.ProgressBar> progressBarDeque = new ArrayDeque<ProgressManager.ProgressBar>();

    private boolean isChiselUsingSeparatedStates() {
        if (this.chiselUsesSeparatedStates == null) {
            IResourceManager manager = Minecraft.func_71410_x().func_110442_L();
            try (IResource resource = manager.func_110536_a(new ResourceLocation("chisel", "blockstates/default.json"));){
                this.chiselUsesSeparatedStates = false;
            }
            catch (IOException e) {
                this.chiselUsesSeparatedStates = true;
            }
        }
        return this.chiselUsesSeparatedStates;
    }

    /*
     * Exception decompiling
     */
    private JsonObject getChiselCache(ResourceLocation throughLoc) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void asLateAsPossible(ModelBakeEvent event) {
        this.chiselCache.clear();
        UCWFakeResourcePack.INSTANCE.invalidate();
    }

    @SubscribeEvent
    public void onModelRegistry(ModelRegistryEvent event) {
        this.chiselCache.clear();
        for (UCWBlockRule rule : UnlimitedChiselWorks.BLOCK_RULES) {
            for (int i = 0; i < rule.from.size(); ++i) {
                IBlockState state = rule.from.get(i);
                if (state == null) continue;
                UCWObjectFactory factory = (UCWObjectFactory)rule.objectFactories.get(i);
                for (int j = 0; j < rule.through.size(); ++j) {
                    IBlockState throughState = rule.through.get(j);
                    if (throughState == null) continue;
                    String variant = BlockStateUtil.getVariantString(factory.getBlock().func_176203_a(j));
                    ModelResourceLocation targetLoc = new ModelResourceLocation(factory.getBlock().getRegistryName(), variant);
                    ModelLoader.setCustomModelResourceLocation((Item)factory.getItem(), (int)j, (ModelResourceLocation)targetLoc);
                }
            }
        }
    }

    @SubscribeEvent
    public void onTextureStitchPre(TextureStitchEvent.Pre event) {
        if (event.getMap() != Minecraft.func_71410_x().func_147117_R()) {
            UnlimitedChiselWorks.LOGGER.warn("Mod called TextureStitchEvent.Pre for non-default texture atlas - this is not handled well by 1.12 mods; please hold off to 1.14+...");
            return;
        }
        ModelLoaderEarlyView loaderEarlyView = new ModelLoaderEarlyView();
        IResourceManager manager = Minecraft.func_71410_x().func_110442_L();
        UnlimitedChiselWorks.proxy.progressPush("UCW: generating models", UnlimitedChiselWorks.BLOCK_RULES.size());
        int cc = 0;
        for (final UCWBlockRule rule : UnlimitedChiselWorks.BLOCK_RULES) {
            UnlimitedChiselWorks.proxy.progressStep(String.format("%d%%", ++cc * 100 / UnlimitedChiselWorks.BLOCK_RULES.size()));
            Map<IBlockState, ModelResourceLocation> fromVariants = loaderEarlyView.getVariants(rule.fromBlock);
            Map<IBlockState, ModelResourceLocation> overlayVariants = loaderEarlyView.getVariants(rule.overlayBlock);
            Map<IBlockState, ModelResourceLocation> throughVariants = loaderEarlyView.getVariants(rule.throughBlock);
            Map<IBlockState, ModelResourceLocation> basedUponVariants = loaderEarlyView.getVariants(rule.basedUponBlock);
            Block lastFromBlock = null;
            String lastFromBlockString = null;
            for (int i = 0; i < rule.from.size(); ++i) {
                IBlockState state = rule.from.get(i);
                if (state == null) continue;
                if (lastFromBlock != rule.fromBlock) {
                    lastFromBlock = rule.fromBlock;
                    lastFromBlockString = rule.fromBlock.getRegistryName().toString().trim().replaceAll("[^A-Za-z0-9]", "_");
                }
                String s2 = lastFromBlockString + "_" + state.func_177230_c().func_176201_c(state);
                IBlockState stateOverlay = rule.overlay.get(i);
                IModel modelFrom = loaderEarlyView.getModel(fromVariants.get(state));
                IModel modelOverlay = loaderEarlyView.getModel(overlayVariants.get(stateOverlay));
                IBlockState stateBasedUpon = rule.basedUpon.size() == 1 ? rule.basedUpon.get(0) : rule.basedUpon.get(i);
                IModel modelBasedUpon = loaderEarlyView.getModel(basedUponVariants.get(stateBasedUpon));
                final ResourceLocation textureFrom = UCWMagic.getLocation(state, fromVariants.get(state), modelFrom);
                final ResourceLocation textureOverlay = UCWMagic.getLocation(stateOverlay, overlayVariants.get(stateOverlay), modelOverlay);
                final ResourceLocation textureBasedUpon = UCWMagic.getLocation(stateBasedUpon, basedUponVariants.get(stateBasedUpon), modelBasedUpon);
                UCWObjectFactory factory = (UCWObjectFactory)rule.objectFactories.get(i);
                UCWFakeTextureMap fakeTextureMap = new UCWFakeTextureMap(event.getMap(), newLocation -> {
                    final ResourceLocation oldLocation = UCWUtils.fromUcwGenerated(newLocation);
                    return new TextureAtlasSprite(newLocation.toString()){

                        public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
                            return true;
                        }

                        public boolean load(IResourceManager manager, ResourceLocation location, Function<ResourceLocation, TextureAtlasSprite> textureGetter) {
                            TextureAtlasSprite fromTex = textureGetter.apply(textureFrom);
                            TextureAtlasSprite overlayTex = textureGetter.apply(textureOverlay);
                            TextureAtlasSprite basedUponTex = textureGetter.apply(textureBasedUpon);
                            TextureAtlasSprite locationTex = textureGetter.apply(oldLocation);
                            this.func_110966_b(locationTex.func_94211_a());
                            this.func_110969_c(locationTex.func_94216_b());
                            this.func_130103_l();
                            for (int i = 0; i < locationTex.func_110970_k(); ++i) {
                                int[][] pixels = new int[Minecraft.func_71410_x().field_71474_y.field_151442_I + 1][];
                                pixels[0] = UCWMagic.transform(locationTex, i, fromTex, overlayTex, basedUponTex, rule.mode);
                                this.field_110976_a.add(pixels);
                            }
                            return false;
                        }

                        public Collection<ResourceLocation> getDependencies() {
                            return ImmutableList.of((Object)textureFrom, (Object)textureBasedUpon, (Object)oldLocation, (Object)textureOverlay);
                        }
                    };
                });
                System.out.println(rule.through.get(0).func_177230_c().getRegistryName() + ": " + rule.through.size());
                for (int j = 0; j < rule.through.size(); ++j) {
                    ImmutableMap origRemapMap;
                    IBlockState throughState = rule.through.get(j);
                    if (throughState == null) continue;
                    ModelResourceLocation throughLoc = throughVariants.get(throughState);
                    IModel modelThrough = loaderEarlyView.getModel(throughLoc);
                    ImmutableMap.Builder textureRemapMap = ImmutableMap.builder();
                    for (ResourceLocation oldLocation : modelThrough.getTextures()) {
                        ResourceLocation newLocation2 = UCWUtils.toUcwGenerated(oldLocation, s2);
                        textureRemapMap.put((Object)oldLocation.toString(), (Object)newLocation2.toString());
                        TextureAtlasSprite sprite = fakeTextureMap.func_174942_a(newLocation2);
                        if (!Loader.isModLoaded((String)"ctm")) continue;
                        this.ctmOnSpriteAddedHook(fakeTextureMap, sprite);
                    }
                    String variant = BlockStateUtil.getVariantString(factory.getBlock().func_176203_a(j));
                    ModelResourceLocation targetLoc = new ModelResourceLocation(factory.getBlock().getRegistryName(), variant);
                    IModel target = null;
                    if (throughLoc.func_110624_b().equals("chisel")) {
                        if (!this.isChiselUsingSeparatedStates()) {
                            try {
                                JsonObject variants = this.getChiselCache((ResourceLocation)throughLoc).get("variants").getAsJsonObject();
                                if (variants.has(throughLoc.func_177518_c())) {
                                    String modelPath = variants.get(throughLoc.func_177518_c()).getAsJsonObject().get("model").getAsString();
                                    modelPath = modelPath.replaceFirst("chisel:", "ucw_generated:ucw_ucw_" + s2 + "/chisel/");
                                    target = ModelLoaderRegistry.getModel((ResourceLocation)new ModelResourceLocation(modelPath));
                                }
                            }
                            catch (Exception e) {
                                UnlimitedChiselWorks.LOGGER.error("Remapping model " + throughLoc + " failed!", (Throwable)e);
                            }
                        } else {
                            try {
                                origRemapMap = textureRemapMap.build();
                                ImmutableMap.Builder chisellyRemapMap = ImmutableMap.builder();
                                JsonObject variants = this.getChiselCache((ResourceLocation)throughLoc).get("variants").getAsJsonObject();
                                JsonArray myVariants = variants.get(throughLoc.func_177518_c()).getAsJsonArray();
                                for (int vi = 0; vi < myVariants.size(); ++vi) {
                                    JsonObject myVariant = myVariants.get(vi).getAsJsonObject();
                                    if (!myVariant.has("textures")) continue;
                                    JsonObject myVTextures = myVariant.get("textures").getAsJsonObject();
                                    for (Map.Entry s : myVTextures.entrySet()) {
                                        if (!((JsonElement)s.getValue()).isJsonPrimitive()) continue;
                                        String variable = (String)s.getKey();
                                        String texture = (String)origRemapMap.get((Object)new ResourceLocation(((JsonElement)s.getValue()).getAsString()).toString());
                                        if (texture == null) continue;
                                        chisellyRemapMap.put((Object)variable, (Object)texture);
                                        chisellyRemapMap.put((Object)("#" + variable), (Object)texture);
                                    }
                                }
                                target = UCWVanillaModelRemapper.retexture((ImmutableMap<String, String>)origRemapMap, (ImmutableMap<String, String>)chisellyRemapMap.build(), modelThrough);
                            }
                            catch (Exception e) {
                                UnlimitedChiselWorks.LOGGER.error("Remapping model " + throughLoc + " failed!", (Throwable)e);
                            }
                        }
                    }
                    if (target == null) {
                        try {
                            origRemapMap = textureRemapMap.build();
                            target = UCWVanillaModelRemapper.retexture((ImmutableMap<String, String>)origRemapMap, (ImmutableMap<String, String>)origRemapMap, modelThrough);
                        }
                        catch (Exception e) {
                            UnlimitedChiselWorks.LOGGER.error("Remapping model " + throughLoc + " failed!", (Throwable)e);
                        }
                    }
                    if (target == null) continue;
                    loaderEarlyView.putModel(targetLoc, rule.hasColor() ? new TintApplyingModel(target) : target);
                }
            }
        }
        UnlimitedChiselWorks.proxy.progressPop();
    }

    @Optional.Method(modid="ctm")
    private void ctmOnSpriteAddedHook(TextureMap map, TextureAtlasSprite sprite) {
        MinecraftForge.EVENT_BUS.post((Event)new TextureCollectedEvent(map, sprite));
    }

    @Override
    public void preInit() {
        try {
            Field field = ObfuscationReflectionHelper.findField(Minecraft.class, (String)"field_110449_ao");
            ((List)field.get(Minecraft.func_71410_x())).add(UCWFakeResourcePack.INSTANCE);
            ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)UCWFakeResourcePack.INSTANCE);
            FMLClientHandler.instance().refreshResources(a -> false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onColorHandlerRegister(ColorHandlerEvent.Item event) {
        for (UCWBlockRule rule : UnlimitedChiselWorks.BLOCK_RULES) {
            if (!rule.hasColor()) continue;
            for (int i = 0; i < rule.from.size(); ++i) {
                IBlockState fromState = rule.from.get(i);
                if (fromState == null) continue;
                UCWObjectFactory factory = (UCWObjectFactory)rule.objectFactories.get(i);
                UCWColorProxy o = UCWColorProxy.INSTANCE;
                if (rule.customColorClass != null) {
                    try {
                        o = Class.forName(rule.customColorClass).getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                if (!(o instanceof IBlockColor) || !(o instanceof IItemColor)) {
                    throw new RuntimeException(o.getClass().getName() + " is not IBlockColor and IItemColor!");
                }
                event.getBlockColors().func_186722_a((IBlockColor)o, new Block[]{factory.getBlock()});
                event.getItemColors().func_186730_a((IItemColor)o, new Item[]{factory.getItem()});
            }
        }
    }

    @Override
    public void progressPush(String name, int count) {
        this.progressBarDeque.addFirst(ProgressManager.push((String)name, (int)count));
    }

    @Override
    public void progressStep(String text) {
        this.progressBarDeque.peekFirst().step(text);
    }

    @Override
    public void progressPop() {
        ProgressManager.pop((ProgressManager.ProgressBar)this.progressBarDeque.removeFirst());
    }
}

