/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.ucw;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public final class UCWUtils {
    private UCWUtils() {
    }

    public static Class findClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static String[] getUcwLocationData(ResourceLocation location) {
        String nonProxyPath;
        String path = location.func_110623_a();
        Matcher m = Pattern.compile("ucw_ucw_([A-Za-z0-9_]+)/([a-z]+)").matcher(path);
        String[] str = new String[]{"", "", ""};
        if (m.find()) {
            str[0] = m.group(1);
            str[1] = m.group(2);
        }
        str[2] = nonProxyPath = path.replaceAll("ucw_ucw_[A-Za-z0-9_]+/[a-z]+/", "");
        return str;
    }

    public static ResourceLocation fromUcwGenerated(ResourceLocation location) {
        if (!"ucw_generated".equals(location.func_110624_b())) {
            return location;
        }
        String[] str = UCWUtils.getUcwLocationData(location);
        return new ResourceLocation(str[1], str[2]);
    }

    public static ResourceLocation toUcwGenerated(ResourceLocation oldLocation, String s2) {
        return new ResourceLocation("ucw_generated", "ucw_ucw_" + s2 + "/" + oldLocation.func_110624_b() + "/" + oldLocation.func_110623_a());
    }

    public static String toUcwGenerated(String[] oldLocation, String s2) {
        return "ucw_generated:ucw_ucw_" + s2 + "/" + oldLocation[0] + "/" + oldLocation[1];
    }

    public static ItemStack copyChangeItem(ItemStack stack, Item item) {
        return UCWUtils.copyChangeItem(stack, item, stack.func_77952_i());
    }

    public static ItemStack copyChangeItem(ItemStack stack, Item item, int damage) {
        ItemStack stackCopy = new ItemStack(item, stack.func_190916_E(), damage);
        if (stack.func_77942_o()) {
            stackCopy.func_77982_d(stack.func_77978_p().func_74737_b());
        }
        return stackCopy;
    }
}

