/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.ucw;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;

public final class UCWVanillaModelRemapper {
    private static final Class vanillaModelWrapperClass;
    private static final Class weightedRandomModelClass;
    private static final Field vmwModelBlockField;
    private static final Field wrmModelsField;
    private static final Field wrmTexturesField;
    private static final ImmutableMap<String, String> hackyCloneRetextureMap;

    private UCWVanillaModelRemapper() {
    }

    private static ModelBlock clone(ModelBlock orig) {
        return new ModelBlock(orig.func_178305_e(), orig.func_178298_a(), new HashMap(orig.field_178318_c), orig.func_178309_b(), orig.func_178311_c(), orig.func_181682_g(), orig.func_187966_f());
    }

    private static IModel hackyClone(IModel orig) {
        return orig.retexture(hackyCloneRetextureMap);
    }

    public static IModel retexture(ImmutableMap<String, String> textureValues, ImmutableMap<String, String> textures, IModel model) {
        try {
            if (model.getClass() == vanillaModelWrapperClass) {
                IModel newModel = UCWVanillaModelRemapper.hackyClone(model);
                ModelBlock modelBlock = (ModelBlock)vmwModelBlockField.get(newModel);
                while (modelBlock != null) {
                    HashMap replacements = new HashMap();
                    for (Map.Entry entry : modelBlock.field_178318_c.entrySet()) {
                        if (textureValues.containsKey(entry.getValue())) {
                            replacements.put(entry.getKey(), textureValues.get(entry.getValue()));
                            continue;
                        }
                        String valueLowerCase = ((String)entry.getValue()).toLowerCase(Locale.ROOT);
                        if (textureValues.containsKey((Object)valueLowerCase)) {
                            replacements.put(entry.getKey(), textureValues.get((Object)valueLowerCase));
                            continue;
                        }
                        if (((String)entry.getValue()).indexOf(58) >= 0 || !textureValues.containsKey((Object)("minecraft:" + (String)entry.getValue()))) continue;
                        replacements.put(entry.getKey(), textureValues.get((Object)("minecraft:" + (String)entry.getValue())));
                    }
                    for (Map.Entry entry : replacements.entrySet()) {
                        modelBlock.field_178318_c.put(entry.getKey(), entry.getValue());
                    }
                    if (modelBlock.field_178315_d != null) {
                        modelBlock.field_178315_d = UCWVanillaModelRemapper.clone(modelBlock.field_178315_d);
                    }
                    modelBlock = modelBlock.field_178315_d;
                }
                return newModel;
            }
            if (model.getClass() == weightedRandomModelClass) {
                IModel newModel = UCWVanillaModelRemapper.hackyClone(model);
                List models = (List)wrmModelsField.get(newModel);
                for (int i = 0; i < models.size(); ++i) {
                    IModel submodel = (IModel)models.get(i);
                    if (submodel == null) continue;
                    IModel newSubmodel = UCWVanillaModelRemapper.retexture(textureValues, textures, submodel);
                    if (newSubmodel == null) {
                        newSubmodel = submodel.retexture(textureValues);
                    }
                    models.set(i, newSubmodel);
                }
                Collection newModelTextures = (Collection)wrmTexturesField.get(newModel);
                for (String s : textureValues.values()) {
                    if (s.indexOf(58) <= 0) continue;
                    newModelTextures.add(new ResourceLocation(s));
                }
                return newModel;
            }
            return model.retexture(textures);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            vanillaModelWrapperClass = Class.forName("net.minecraftforge.client.model.ModelLoader$VanillaModelWrapper");
            weightedRandomModelClass = Class.forName("net.minecraftforge.client.model.ModelLoader$WeightedRandomModel");
            vmwModelBlockField = vanillaModelWrapperClass.getDeclaredField("model");
            vmwModelBlockField.setAccessible(true);
            wrmModelsField = weightedRandomModelClass.getDeclaredField("models");
            wrmModelsField.setAccessible(true);
            wrmTexturesField = weightedRandomModelClass.getDeclaredField("textures");
            wrmTexturesField.setAccessible(true);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        hackyCloneRetextureMap = ImmutableMap.of((Object)"\ufd00\ufd01\ufd02\ufd03", (Object)"this does not exist");
    }
}

