/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.ucw;

import com.google.common.base.Charsets;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;
import net.minecraftforge.fml.common.versioning.DefaultArtifactVersion;
import net.minecraftforge.fml.common.versioning.VersionParser;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pl.asie.ucw.CommandUCWDebug;
import pl.asie.ucw.IUCWCustomVariantHandler;
import pl.asie.ucw.UCWBlockRule;
import pl.asie.ucw.UCWCompatUtils;
import pl.asie.ucw.UCWGroupRule;
import pl.asie.ucw.UCWObjectFactory;
import pl.asie.ucw.UCWProxyCommon;

@Mod(modid="unlimitedchiselworks", version="0.3.5", dependencies="after:forge@[14.23.5.2838,);after:undergroundbiomes", updateJSON="http://asie.pl/files/minecraft/update/unlimitedchiselworks.json", acceptedMinecraftVersions="[1.12.2]")
public final class UnlimitedChiselWorks {
    public static final String MODID = "unlimitedchiselworks";
    public static final String VERSION = "0.3.5";
    public static final Set<UCWBlockRule> BLOCK_RULES = new LinkedHashSet<UCWBlockRule>();
    public static final Set<String> GROUP_RULE_NAMES = new HashSet<String>();
    public static final Set<UCWGroupRule> GROUP_RULES = new LinkedHashSet<UCWGroupRule>();
    public static boolean useChiselGetSubItemsWorkaround = false;
    public static Logger LOGGER;
    public static Random RAND;
    static final Gson GSON;
    private static Configuration CONFIG;
    private static ConfigCategory C_ENABLED;
    private static ConfigCategory C_ENABLED_GROUPS;
    private static File configDir;
    private boolean enableDebugFeatures;
    @SidedProxy(clientSide="pl.asie.ucw.UCWProxyClient", serverSide="pl.asie.ucw.UCWProxyCommon")
    public static UCWProxyCommon proxy;
    private boolean loadLate;
    private final List<JsonObject> objectsLoadLate = new ArrayList<JsonObject>();
    private final Object proposeObjectSync = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean proposeObject(JsonObject json) {
        boolean result = false;
        if (json != null) {
            Property prop;
            Object object;
            String fbName;
            boolean jsonLoadLate = false;
            if (json.has("loadLate")) {
                jsonLoadLate = json.get("loadLate").getAsBoolean();
            }
            if (jsonLoadLate != this.loadLate) {
                if (!this.loadLate) {
                    List<JsonObject> list = this.objectsLoadLate;
                    synchronized (list) {
                        this.objectsLoadLate.add(json);
                    }
                }
                return result;
            }
            if (json.has("modid")) {
                JsonElement element = json.get("modid");
                if (element.isJsonArray()) {
                    JsonArray array = element.getAsJsonArray();
                    for (int i = 0; i < array.size(); ++i) {
                        if (Loader.isModLoaded((String)array.get(i).getAsString())) continue;
                        return result;
                    }
                } else if (!Loader.isModLoaded((String)element.getAsString())) {
                    return result;
                }
            }
            if (json.has("blocks")) {
                for (JsonElement element : json.get("blocks").getAsJsonArray()) {
                    if (!element.isJsonObject()) continue;
                    try {
                        UCWBlockRule rule = new UCWBlockRule(element.getAsJsonObject());
                        if (!rule.isValid()) continue;
                        fbName = rule.fromBlock.getRegistryName().toString();
                        object = this.proposeObjectSync;
                        synchronized (object) {
                            if (!C_ENABLED.containsKey(fbName)) {
                                prop = new Property(fbName, "true", Property.Type.BOOLEAN);
                                C_ENABLED.put(fbName, prop);
                            }
                            if (C_ENABLED.get(fbName).getBoolean()) {
                                if (BLOCK_RULES.contains(rule)) {
                                    LOGGER.warn("Duplicate rule found! " + rule);
                                } else {
                                    BLOCK_RULES.add(rule);
                                    result = true;
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if (json.has("groups")) {
                for (JsonElement element : json.get("groups").getAsJsonArray()) {
                    if (!element.isJsonObject()) continue;
                    try {
                        UCWGroupRule rule = new UCWGroupRule(element.getAsJsonObject());
                        fbName = rule.groupName;
                        object = this.proposeObjectSync;
                        synchronized (object) {
                            if (GROUP_RULE_NAMES.contains(fbName)) {
                                LOGGER.warn("Duplicate group name: " + fbName + "!");
                            } else {
                                GROUP_RULE_NAMES.add(fbName);
                                result = true;
                            }
                            if (!C_ENABLED_GROUPS.containsKey(fbName)) {
                                prop = new Property(fbName, "true", Property.Type.BOOLEAN);
                                C_ENABLED_GROUPS.put(fbName, prop);
                            }
                            if (C_ENABLED_GROUPS.get(fbName).getBoolean()) {
                                GROUP_RULES.add(rule);
                                result = true;
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean proposeRule(Path p) throws IOException {
        if (!Files.exists(p, new LinkOption[0])) {
            return false;
        }
        if (Files.isDirectory(p, new LinkOption[0])) {
            List paths;
            AtomicBoolean result = new AtomicBoolean();
            try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(p);){
                paths = StreamSupport.stream(dirStream.spliterator(), false).collect(Collectors.toList());
            }
            paths.parallelStream().forEach(pp -> {
                try {
                    if (this.proposeRule((Path)pp)) {
                        result.set(true);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            return result.get();
        }
        try (BufferedReader reader = Files.newBufferedReader(p, Charsets.UTF_8);){
            JsonObject json = (JsonObject)JsonUtils.func_193839_a((Gson)GSON, (Reader)reader, JsonObject.class);
            boolean bl = this.proposeObject(json);
            return bl;
        }
        catch (Exception e) {
            LOGGER.error("Error parsing " + p.toString(), (Throwable)e);
            return false;
        }
    }

    private boolean findRules() {
        AtomicBoolean result = new AtomicBoolean();
        proxy.progressPush("UCW: scanning rules", 2);
        proxy.progressStep("config/ucwdefs");
        File dir = new File(configDir, "ucwdefs");
        if (dir.exists() && dir.isDirectory()) {
            try {
                if (this.proposeRule(dir.toPath())) {
                    result.set(true);
                }
            }
            catch (NoSuchFileException noSuchFileException) {
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        proxy.progressStep("loaded mods");
        Loader.instance().getActiveModList().parallelStream().forEach(container -> {
            File file = container.getSource();
            try {
                if (file.exists()) {
                    if (file.isDirectory()) {
                        File f = new File(file, "assets/" + container.getModId() + "/ucwdefs");
                        if (f.exists() && f.isDirectory() && this.proposeRule(f.toPath())) {
                            result.set(true);
                        }
                    } else {
                        FileSystem fs = FileSystems.newFileSystem(file.toPath(), null);
                        if (this.proposeRule(fs.getPath("assets/" + container.getModId() + "/ucwdefs", new String[0]))) {
                            result.set(true);
                        }
                    }
                }
            }
            catch (NoSuchFileException fs) {
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        proxy.progressPop();
        if (result.get()) {
            LOGGER.info("So far, UCW found " + BLOCK_RULES.size() + " block rules and " + GROUP_RULES.size() + " group rules.");
            return true;
        }
        return false;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        DefaultArtifactVersion requiredVersion;
        LOGGER = LogManager.getLogger((String)MODID);
        CONFIG = new Configuration(event.getSuggestedConfigurationFile());
        configDir = event.getModConfigurationDirectory();
        if (FMLCommonHandler.instance().getSide() == Side.SERVER && Loader.isModLoaded((String)"chisel") && (requiredVersion = new DefaultArtifactVersion("chisel", VersionParser.parseRange((String)"[,MC1.12-0.0.14.18]"))).containsVersion((ArtifactVersion)new DefaultArtifactVersion("chisel", ((ModContainer)Loader.instance().getIndexedModList().get("chisel")).getVersion()))) {
            LOGGER.info("Buggy version of 1.12.x Chisel detected on dedicated server, enabling workaround.");
            useChiselGetSubItemsWorkaround = true;
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)proxy);
        proxy.preInit();
        C_ENABLED = CONFIG.getCategory("enabled");
        C_ENABLED_GROUPS = CONFIG.getCategory("enabled_groups");
        this.enableDebugFeatures = CONFIG.getBoolean("enableDebugFeatures", "general", false, "Whether or not to enable debug functionality.");
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        this.loadLate = false;
        this.objectsLoadLate.clear();
        BLOCK_RULES.clear();
        this.findRules();
        if (CONFIG.hasChanged()) {
            CONFIG.save();
        }
        for (UCWBlockRule rule : BLOCK_RULES) {
            rule.registerBlocks((IForgeRegistry<Block>)event.getRegistry());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void registerBlocksLate(RegistryEvent.Register<Block> event) {
        this.loadLate = true;
        boolean result = false;
        for (JsonObject o : this.objectsLoadLate) {
            result |= this.proposeObject(o);
        }
        if (result) {
            for (UCWBlockRule rule : BLOCK_RULES) {
                rule.registerBlocks((IForgeRegistry<Block>)event.getRegistry());
            }
        }
        if (CONFIG.hasChanged()) {
            CONFIG.save();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void registerItems(RegistryEvent.Register<Item> event) {
        for (UCWBlockRule rule : BLOCK_RULES) {
            rule.registerItems((IForgeRegistry<Item>)event.getRegistry());
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        for (UCWBlockRule uCWBlockRule : BLOCK_RULES) {
            for (int i = 0; i < uCWBlockRule.from.size(); ++i) {
                IBlockState fromState = uCWBlockRule.from.get(i);
                if (fromState == null) continue;
                UCWObjectFactory factory = (UCWObjectFactory)uCWBlockRule.objectFactories.get(i);
                String groupName = uCWBlockRule.group + "_" + fromState.func_177230_c().func_176201_c(fromState);
                NonNullList stacks = NonNullList.func_191196_a();
                factory.getItem().func_150895_a(CreativeTabs.field_78027_g, stacks);
                if (factory.getBlock() instanceof IUCWCustomVariantHandler) {
                    ((IUCWCustomVariantHandler)factory.getBlock()).registerVariants(groupName, fromState, (List<ItemStack>)stacks);
                    continue;
                }
                UCWCompatUtils.addChiselVariation(groupName, new ItemStack(fromState.func_177230_c(), 1, fromState.func_177230_c().func_180651_a(fromState)));
                for (ItemStack stack : stacks) {
                    UCWCompatUtils.addChiselVariation(groupName, stack);
                }
            }
        }
        for (UCWGroupRule uCWGroupRule : GROUP_RULES) {
            for (IBlockState state : uCWGroupRule.states) {
                if (state == null) continue;
                UCWCompatUtils.addChiselVariation(uCWGroupRule.groupName, new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_180651_a(state)));
            }
        }
        if (CONFIG.hasChanged()) {
            CONFIG.save();
        }
    }

    @Mod.EventHandler
    public void postInit(FMLInitializationEvent event) {
        HashMap<Block, int[]> oreIdMap = new HashMap<Block, int[]>();
        for (UCWBlockRule rule : BLOCK_RULES) {
            int[] oreIds = oreIdMap.computeIfAbsent(rule.fromBlock, b -> {
                ItemStack stack = new ItemStack(b, 1, Short.MAX_VALUE);
                if (!stack.func_190926_b()) {
                    return OreDictionary.getOreIDs((ItemStack)stack);
                }
                return new int[0];
            });
            if (oreIds.length <= 0) continue;
            for (UCWObjectFactory factory : rule.objectFactories.valueCollection()) {
                if (!factory.isBlockRegistered()) continue;
                for (int i : oreIds) {
                    OreDictionary.registerOre((String)OreDictionary.getOreName((int)i), (ItemStack)new ItemStack(factory.getBlock(), 1, Short.MAX_VALUE));
                }
            }
        }
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        if (this.enableDebugFeatures) {
            event.registerServerCommand((ICommand)new CommandUCWDebug());
        }
    }

    static {
        RAND = new Random();
        GSON = new Gson();
    }
}

