/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker;

import crafttweaker.CrafttweakerImplementationAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.BracketHandler;
import crafttweaker.annotations.OnRegister;
import crafttweaker.api.client.IClient;
import crafttweaker.api.event.IEventManager;
import crafttweaker.api.formatting.IFormatter;
import crafttweaker.api.game.IGame;
import crafttweaker.api.item.IItemUtils;
import crafttweaker.api.mods.ILoadedMods;
import crafttweaker.api.oredict.IOreDict;
import crafttweaker.api.recipes.IBrewingManager;
import crafttweaker.api.recipes.IFurnaceManager;
import crafttweaker.api.recipes.IRecipeManager;
import crafttweaker.api.server.IServer;
import crafttweaker.api.vanilla.IVanilla;
import crafttweaker.runtime.CrTTweaker;
import crafttweaker.runtime.ILogger;
import crafttweaker.runtime.ITweaker;
import crafttweaker.util.SuppressErrorFlag;
import crafttweaker.zenscript.GlobalRegistry;
import crafttweaker.zenscript.IBracketHandler;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenExpansion;
import stanhebben.zenscript.symbols.IZenSymbol;
import stanhebben.zenscript.symbols.SymbolJavaStaticField;
import stanhebben.zenscript.symbols.SymbolJavaStaticGetter;
import stanhebben.zenscript.symbols.SymbolJavaStaticMethod;
import stanhebben.zenscript.type.natives.IJavaMethod;
import stanhebben.zenscript.type.natives.JavaMethod;

public class CraftTweakerAPI {
    public static final ITweaker tweaker = new CrTTweaker();
    public static final IEventManager events = CrafttweakerImplementationAPI.events;
    public static IOreDict oreDict = null;
    public static IRecipeManager recipes = null;
    public static IFurnaceManager furnace = null;
    public static IServer server = null;
    public static IClient client = null;
    public static IGame game = null;
    public static ILoadedMods loadedMods = null;
    public static IFormatter format = null;
    public static IVanilla vanilla = null;
    public static IItemUtils itemUtils = null;
    public static IBrewingManager brewingManager = null;
    private static SuppressErrorFlag suppressErrorFlag = SuppressErrorFlag.DEFAULT;
    public static boolean ENABLE_SEARCH_TREE_RECALCULATION = true;
    public static boolean profile = false;

    private CraftTweakerAPI() {
    }

    public static ILogger getLogger() {
        return CrafttweakerImplementationAPI.logger;
    }

    public static void apply(IAction action) {
        long time = 0L;
        if (profile) {
            time = System.nanoTime();
        }
        tweaker.apply(action);
        if (profile) {
            CraftTweakerAPI.logInfo("Took " + (double)(System.nanoTime() - time) / 1000000.0 + " ms");
        }
    }

    public static void logCommand(String message) {
        CraftTweakerAPI.getLogger().logCommand(message);
    }

    public static void logInfo(String message) {
        CraftTweakerAPI.getLogger().logInfo(message);
    }

    public static void logWarning(String message) {
        CraftTweakerAPI.getLogger().logWarning(message);
    }

    public static void logError(String message) {
        CraftTweakerAPI.getLogger().logError(message);
    }

    public static void logError(String message, Throwable exception) {
        CraftTweakerAPI.getLogger().logError(message, exception);
    }

    public static void logDefault(String message) {
        CraftTweakerAPI.getLogger().logDefault(message);
    }

    public static void setSuppressErrorFlag(SuppressErrorFlag flag) {
        if (suppressErrorFlag.isForced()) {
            return;
        }
        suppressErrorFlag = flag;
    }

    public static boolean isSuppressingErrors() {
        return suppressErrorFlag.isSuppressingErrors();
    }

    public static boolean isSuppressingWarnings() {
        return suppressErrorFlag.isSuppressingWarnings();
    }

    public static void registerClass(Class annotatedClass) {
        boolean registered = false;
        for (Annotation annotation : annotatedClass.getAnnotations()) {
            if (annotation instanceof ZenExpansion) {
                GlobalRegistry.registerExpansion(annotatedClass);
                registered = true;
            }
            if (annotation instanceof ZenClass) {
                GlobalRegistry.registerNativeClass(annotatedClass);
                registered = true;
            }
            if (!(annotation instanceof BracketHandler) || !IBracketHandler.class.isAssignableFrom(annotatedClass)) continue;
            try {
                IBracketHandler bracketHandler = (IBracketHandler)annotatedClass.newInstance();
                CraftTweakerAPI.registerBracketHandler(bracketHandler);
            }
            catch (IllegalAccessException | InstantiationException ex) {
                Logger.getLogger(CraftTweakerAPI.class.getName()).log(Level.SEVERE, null, ex);
            }
            registered = true;
        }
        if (registered) {
            for (Method method : annotatedClass.getDeclaredMethods()) {
                if (!Modifier.isStatic(method.getModifiers()) || !Modifier.isPublic(method.getModifiers()) || !method.isAnnotationPresent(OnRegister.class)) continue;
                try {
                    method.invoke(null, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void registerGlobalSymbol(String name, IZenSymbol symbol) {
        GlobalRegistry.registerGlobal(name, symbol);
    }

    public static void registerBracketHandler(IBracketHandler handler) {
        GlobalRegistry.registerBracketHandler(handler);
    }

    public static IZenSymbol getJavaStaticMethodSymbol(Class cls, String name, Class ... arguments) {
        IJavaMethod method = JavaMethod.get(GlobalRegistry.getTypes(), cls, name, arguments);
        return new SymbolJavaStaticMethod(method);
    }

    public static IZenSymbol getJavaStaticGetterSymbol(Class<? extends CraftTweakerAPI> cls, String name) {
        IJavaMethod method = JavaMethod.get(GlobalRegistry.getTypes(), cls, name, new Class[0]);
        return new SymbolJavaStaticGetter(method);
    }

    public static IZenSymbol getJavaStaticFieldSymbol(Class<?> cls, String name) {
        try {
            Field field = cls.getField(name);
            return new SymbolJavaStaticField(cls, field, GlobalRegistry.getTypes());
        }
        catch (NoSuchFieldException | SecurityException ex) {
            return null;
        }
    }

    public static IJavaMethod getJavaMethod(Class<? extends IBracketHandler> cls, String name, Class ... arguments) {
        return JavaMethod.get(GlobalRegistry.getTypes(), cls, name, arguments);
    }

    public static String getScriptFileAndLine() {
        return Arrays.stream(Thread.currentThread().getStackTrace()).filter(s -> s != null && s.getFileName() != null && s.getFileName().endsWith(".zs")).findFirst().map(s -> s.getFileName() + ":" + s.getLineNumber()).orElse("<?>");
    }

    static {
        CraftTweakerAPI.registerGlobalSymbol("logger", CraftTweakerAPI.getJavaStaticGetterSymbol(CraftTweakerAPI.class, "getLogger"));
        CraftTweakerAPI.registerGlobalSymbol("recipes", CraftTweakerAPI.getJavaStaticFieldSymbol(CraftTweakerAPI.class, "recipes"));
        CraftTweakerAPI.registerGlobalSymbol("furnace", CraftTweakerAPI.getJavaStaticFieldSymbol(CraftTweakerAPI.class, "furnace"));
        CraftTweakerAPI.registerGlobalSymbol("oreDict", CraftTweakerAPI.getJavaStaticFieldSymbol(CraftTweakerAPI.class, "oreDict"));
        CraftTweakerAPI.registerGlobalSymbol("events", CraftTweakerAPI.getJavaStaticFieldSymbol(CraftTweakerAPI.class, "events"));
        CraftTweakerAPI.registerGlobalSymbol("server", CraftTweakerAPI.getJavaStaticFieldSymbol(CraftTweakerAPI.class, "server"));
        CraftTweakerAPI.registerGlobalSymbol("client", CraftTweakerAPI.getJavaStaticFieldSymbol(CraftTweakerAPI.class, "client"));
        CraftTweakerAPI.registerGlobalSymbol("game", CraftTweakerAPI.getJavaStaticFieldSymbol(CraftTweakerAPI.class, "game"));
        CraftTweakerAPI.registerGlobalSymbol("loadedMods", CraftTweakerAPI.getJavaStaticFieldSymbol(CraftTweakerAPI.class, "loadedMods"));
        CraftTweakerAPI.registerGlobalSymbol("format", CraftTweakerAPI.getJavaStaticFieldSymbol(CraftTweakerAPI.class, "format"));
        CraftTweakerAPI.registerGlobalSymbol("vanilla", CraftTweakerAPI.getJavaStaticFieldSymbol(CraftTweakerAPI.class, "vanilla"));
        CraftTweakerAPI.registerGlobalSymbol("itemUtils", CraftTweakerAPI.getJavaStaticFieldSymbol(CraftTweakerAPI.class, "itemUtils"));
        CraftTweakerAPI.registerGlobalSymbol("brewing", CraftTweakerAPI.getJavaStaticFieldSymbol(CraftTweakerAPI.class, "brewingManager"));
    }
}

