/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.api.crafting;

import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.common.util.ListUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class DistillerRecipe
extends MultiblockRecipe {
    public static float energyModifier = 1.0f;
    public static float timeModifier = 1.0f;
    public float chance;
    public final FluidStack fluidOutput;
    public final FluidStack fluidInput;
    public final ItemStack itemOutput;
    int totalProcessTime;
    int totalProcessEnergy;
    public static ArrayList<DistillerRecipe> recipeList = new ArrayList();

    public DistillerRecipe(FluidStack fluidOutput, FluidStack fluidInput, ItemStack itemOutput, int energy, int time, float chance) {
        this.fluidOutput = fluidOutput;
        this.fluidInput = fluidInput;
        this.itemOutput = itemOutput;
        this.totalProcessEnergy = (int)Math.floor((float)energy * energyModifier);
        this.totalProcessTime = (int)Math.floor((float)time * timeModifier);
        this.chance = chance;
        this.fluidInputList = Lists.newArrayList((Object[])new FluidStack[]{this.fluidInput});
        this.fluidOutputList = Lists.newArrayList((Object[])new FluidStack[]{this.fluidOutput});
        this.outputList = ListUtils.fromItem((ItemStack)this.itemOutput);
    }

    public static DistillerRecipe addRecipe(FluidStack fluidOutput, FluidStack fluidInput, ItemStack itemOutput, int energy, int time, float chance) {
        DistillerRecipe r = new DistillerRecipe(fluidOutput, fluidInput, itemOutput, energy, time, chance);
        recipeList.add(r);
        return r;
    }

    public static DistillerRecipe findRecipe(FluidStack fluidInput) {
        if (fluidInput == null) {
            return null;
        }
        for (DistillerRecipe recipe : recipeList) {
            if (recipe.fluidInput == null || !fluidInput.containsFluid(recipe.fluidInput)) continue;
            return recipe;
        }
        return null;
    }

    public static DistillerRecipe findRecipeByFluid(Fluid fluidInput) {
        if (fluidInput == null) {
            return null;
        }
        for (DistillerRecipe recipe : recipeList) {
            if (recipe.fluidInput == null || fluidInput != recipe.fluidInput.getFluid()) continue;
            return recipe;
        }
        return null;
    }

    public int getMultipleProcessTicks() {
        return 0;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("input", (NBTBase)this.fluidInput.writeToNBT(new NBTTagCompound()));
        return nbt;
    }

    public static DistillerRecipe loadFromNBT(NBTTagCompound nbt) {
        FluidStack fluidInput = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("input"));
        return DistillerRecipe.findRecipe(fluidInput);
    }

    public int getTotalProcessTime() {
        return this.totalProcessTime;
    }

    public int getTotalProcessEnergy() {
        return this.totalProcessEnergy;
    }

    public NonNullList<ItemStack> getActualItemOutputs(TileEntity tile) {
        if (tile.func_145831_w().field_73012_v.nextFloat() <= this.chance) {
            return this.getItemOutputs();
        }
        return ListUtils.fromItems((ItemStack[])new ItemStack[0]);
    }
}

