/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.blocks.metal.tileentities;

import blusunrize.immersiveengineering.api.crafting.IMultiblockRecipe;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockMetal;
import blusunrize.immersiveengineering.common.util.Utils;
import mctmods.immersivetechnology.ImmersiveTechnology;
import mctmods.immersivetechnology.api.ITUtils;
import mctmods.immersivetechnology.api.crafting.DistillerRecipe;
import mctmods.immersivetechnology.common.Config;
import mctmods.immersivetechnology.common.blocks.metal.tileentities.TileEntityDistillerSlave;
import mctmods.immersivetechnology.common.util.ITFluidTank;
import mctmods.immersivetechnology.common.util.ITSounds;
import mctmods.immersivetechnology.common.util.network.MessageStopSound;
import mctmods.immersivetechnology.common.util.network.MessageTileSync;
import mctmods.immersivetechnology.common.util.sound.ITSoundHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityDistillerMaster
extends TileEntityDistillerSlave
implements ITFluidTank.TankListener {
    private static int inputTankSize = Config.ITConfig.Machines.Distiller.distiller_input_tankSize;
    private static int outputTankSize = Config.ITConfig.Machines.Distiller.distiller_output_tankSize;
    BlockPos fluidOutputPos;
    public FluidTank[] tanks = new FluidTank[]{new ITFluidTank(inputTankSize, this), new ITFluidTank(outputTankSize, this)};
    public static int slotCount = 4;
    public NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)slotCount, (Object)ItemStack.field_190927_a);
    private boolean running;
    private boolean previousRenderState;
    private float soundVolume;

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.tanks[0].readFromNBT(nbt.func_74775_l("tank0"));
        this.tanks[1].readFromNBT(nbt.func_74775_l("tank1"));
        this.running = nbt.func_74767_n("running");
        if (!descPacket) {
            this.inventory = Utils.readInventory((NBTTagList)nbt.func_150295_c("inventory", 10), (int)slotCount);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74782_a("tank0", (NBTBase)this.tanks[0].writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("tank1", (NBTBase)this.tanks[1].writeToNBT(new NBTTagCompound()));
        nbt.func_74757_a("running", this.running);
        if (!descPacket) {
            nbt.func_74782_a("inventory", (NBTBase)Utils.writeInventory(this.inventory));
        }
    }

    private void pumpOutputOut() {
        IFluidHandler output;
        if (this.tanks[1].getFluidAmount() == 0) {
            return;
        }
        if (this.fluidOutputPos == null) {
            this.fluidOutputPos = ITUtils.LocalOffsetToWorldBlockPos(this.func_174877_v(), -2, -1, 0, this.facing, this.mirrored);
        }
        if ((output = FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)this.fluidOutputPos, (EnumFacing)(this.mirrored ? this.facing.func_176735_f() : this.facing.func_176746_e()))) == null) {
            return;
        }
        FluidStack out = this.tanks[1].getFluid();
        int accepted = output.fill(out, false);
        if (accepted == 0) {
            return;
        }
        int drained = output.fill(Utils.copyFluidStackWithAmount((FluidStack)out, (int)Math.min(out.amount, accepted), (boolean)false), true);
        this.tanks[1].drain(drained, true);
    }

    public void handleSounds() {
        if (this.running) {
            if (this.soundVolume < 1.0f) {
                this.soundVolume += 0.01f;
            }
        } else if (this.soundVolume > 0.0f) {
            this.soundVolume -= 0.01f;
        }
        BlockPos center = this.func_174877_v();
        if (this.soundVolume == 0.0f) {
            ITSoundHandler.StopSound(center);
        } else {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            float attenuation = Math.max((float)player.func_70092_e((double)center.func_177958_n(), (double)center.func_177956_o(), (double)center.func_177952_p()) / 8.0f, 1.0f);
            ITSounds.distiller.PlayRepeating(center, this.soundVolume / attenuation, 1.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onChunkUnload() {
        if (!this.isDummy()) {
            ITSoundHandler.StopSound(this.func_174877_v());
        }
        super.onChunkUnload();
    }

    public void disassemble() {
        BlockPos center = this.func_174877_v();
        ImmersiveTechnology.packetHandler.sendToAllTracking((IMessage)new MessageStopSound(center), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)center.func_177958_n(), (double)center.func_177956_o(), (double)center.func_177952_p(), 0.0));
        super.disassemble();
    }

    public void notifyNearbyClients() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("running", this.running);
        BlockPos center = this.func_174877_v();
        ImmersiveTechnology.packetHandler.sendToAllTracking((IMessage)new MessageTileSync((TileEntityIEBase)this, tag), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)center.func_177958_n(), (double)center.func_177956_o(), (double)center.func_177952_p(), 0.0));
    }

    public void efficientMarkDirty() {
        this.field_145850_b.func_175726_f(this.func_174877_v()).func_76630_e();
    }

    @Override
    public void func_73660_a() {
        ItemStack filledContainer;
        TileEntityMultiblockMetal.MultiblockProcessInMachine process;
        DistillerRecipe recipe;
        if (!this.formed) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            this.handleSounds();
            return;
        }
        boolean update = false;
        if (this.energyStorage.getEnergyStored() > 0 && this.processQueue.size() < this.getProcessQueueMaxLength() && this.tanks[0].getFluidAmount() > 0 && (recipe = DistillerRecipe.findRecipe(this.tanks[0].getFluid())) != null && this.addProcessToQueue((TileEntityMultiblockMetal.MultiblockProcess)(process = new TileEntityMultiblockMetal.MultiblockProcessInMachine((IMultiblockRecipe)recipe, new int[0]).setInputTanks(new int[]{0})), false)) {
            update = true;
        }
        super.func_73660_a();
        if (this.tanks[1].getFluidAmount() > 0 && !(filledContainer = Utils.fillFluidContainer((IFluidHandler)this.tanks[1], (ItemStack)((ItemStack)this.inventory.get(2)), (ItemStack)((ItemStack)this.inventory.get(3)), null)).func_190926_b()) {
            if (!((ItemStack)this.inventory.get(3)).func_190926_b() && OreDictionary.itemMatches((ItemStack)((ItemStack)this.inventory.get(3)), (ItemStack)filledContainer, (boolean)true)) {
                ((ItemStack)this.inventory.get(3)).func_190917_f(filledContainer.func_190916_E());
            } else if (((ItemStack)this.inventory.get(3)).func_190926_b()) {
                this.inventory.set(3, (Object)filledContainer.func_77946_l());
            }
            ((ItemStack)this.inventory.get(2)).func_190918_g(1);
            if (((ItemStack)this.inventory.get(2)).func_190916_E() <= 0) {
                this.inventory.set(2, (Object)ItemStack.field_190927_a);
            }
        }
        ItemStack emptyContainer = Utils.drainFluidContainer((IFluidHandler)this.tanks[0], (ItemStack)((ItemStack)this.inventory.get(0)), (ItemStack)((ItemStack)this.inventory.get(1)), null);
        this.pumpOutputOut();
        if (!emptyContainer.func_190926_b() && emptyContainer.func_190916_E() > 0) {
            if (!((ItemStack)this.inventory.get(1)).func_190926_b() && OreDictionary.itemMatches((ItemStack)((ItemStack)this.inventory.get(1)), (ItemStack)emptyContainer, (boolean)true)) {
                ((ItemStack)this.inventory.get(1)).func_190917_f(emptyContainer.func_190916_E());
            } else if (((ItemStack)this.inventory.get(1)).func_190926_b()) {
                this.inventory.set(1, (Object)emptyContainer.func_77946_l());
            }
            ((ItemStack)this.inventory.get(0)).func_190918_g(1);
            if (((ItemStack)this.inventory.get(0)).func_190916_E() <= 0) {
                this.inventory.set(0, (Object)ItemStack.field_190927_a);
            }
        }
        boolean bl = this.running = this.shouldRenderAsActive() && !this.processQueue.isEmpty() && ((TileEntityMultiblockMetal.MultiblockProcess)this.processQueue.get(0)).canProcess((TileEntityMultiblockMetal)this);
        if (this.previousRenderState != this.running) {
            this.notifyNearbyClients();
        }
        this.previousRenderState = this.running;
        if (update) {
            this.efficientMarkDirty();
            this.markContainingBlockForUpdate(null);
        }
    }

    @Override
    public void TankContentsChanged() {
        this.markContainingBlockForUpdate(null);
    }

    @Override
    public boolean isDummy() {
        return false;
    }

    @Override
    public TileEntityDistillerMaster master() {
        this.master = this;
        return this;
    }

    public void receiveMessageFromServer(NBTTagCompound message) {
        this.running = message.func_74767_n("running");
    }
}

