/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.util.compat.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.liquid.ILiquidStack;
import java.util.ArrayList;
import java.util.Iterator;
import mctmods.immersivetechnology.api.crafting.SteamTurbineRecipe;
import mctmods.immersivetechnology.common.util.compat.crafttweaker.CraftTweakerHelper;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.immersivetechnology.SteamTurbine")
public class SteamTurbine {
    @ZenMethod
    public static void addFuel(ILiquidStack outputFluid, ILiquidStack inputFluid, int time) {
        FluidStack fluidOut = CraftTweakerHelper.toFluidStack(outputFluid);
        FluidStack fluidIn = CraftTweakerHelper.toFluidStack(inputFluid);
        if (fluidIn == null) {
            return;
        }
        SteamTurbineRecipe recipe = new SteamTurbineRecipe(fluidOut, fluidIn, time);
        CraftTweakerAPI.apply((IAction)new Add(recipe));
    }

    @ZenMethod
    public static void removeFuel(ILiquidStack inputFluid) {
        if (CraftTweakerHelper.toFluidStack(inputFluid) != null) {
            CraftTweakerAPI.apply((IAction)new Remove(CraftTweakerHelper.toFluidStack(inputFluid)));
        }
    }

    private static class Remove
    implements IAction {
        private final FluidStack inputFluid;
        ArrayList<SteamTurbineRecipe> removedRecipes = new ArrayList();

        public Remove(FluidStack inputFluid) {
            this.inputFluid = inputFluid;
        }

        public void apply() {
            Iterator<SteamTurbineRecipe> iterator = SteamTurbineRecipe.recipeList.iterator();
            while (iterator.hasNext()) {
                SteamTurbineRecipe recipe = iterator.next();
                if (recipe == null || !recipe.fluidInput.isFluidEqual(this.inputFluid)) continue;
                this.removedRecipes.add(recipe);
                iterator.remove();
            }
        }

        public String describe() {
            return "Removing Steam Turbine Fuel for " + this.inputFluid.getLocalizedName();
        }
    }

    private static class Add
    implements IAction {
        public SteamTurbineRecipe recipe;

        public Add(SteamTurbineRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            SteamTurbineRecipe.recipeList.add(this.recipe);
        }

        public String describe() {
            if (this.recipe.fluidOutput == null) {
                return "Adding Steam Turbine Fuel for " + this.recipe.fluidInput.getLocalizedName();
            }
            return "Adding Steam Turbine Fuel for " + this.recipe.fluidInput.getLocalizedName() + " -> " + this.recipe.fluidOutput.getLocalizedName();
        }
    }
}

