/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.util.sound;

import java.util.HashMap;
import mctmods.immersivetechnology.client.ClientProxy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ITickableSound;
import net.minecraft.client.audio.PositionedSound;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;

public class ITSoundHandler
extends PositionedSound
implements ITickableSound {
    private static HashMap<BlockPos, ITSoundHandler> playingSounds = new HashMap();
    private BlockPos pos;
    private float unmodifiedVolume;

    public static void PlayOnceSound(BlockPos posIn, SoundEvent soundIn, SoundCategory categoryIn, float volumeIn, float pitchIn) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        player.field_70170_p.func_184133_a((EntityPlayer)player, posIn, soundIn, categoryIn, volumeIn, pitchIn);
    }

    public static void PlayRepeatingSound(BlockPos posIn, SoundEvent soundIn, SoundCategory categoryIn, float volumeIn, float pitchIn) {
        ITSoundHandler sound = playingSounds.get(posIn);
        if (sound == null) {
            sound = new ITSoundHandler(posIn, soundIn, categoryIn, true, volumeIn, pitchIn);
            playingSounds.put(posIn, sound);
        } else {
            sound.unmodifiedVolume = volumeIn;
            sound.field_147662_b = volumeIn * ClientProxy.volumeAdjustment;
            sound.field_147663_c = pitchIn;
            sound.field_147659_g = true;
        }
    }

    public static void StopSound(BlockPos posIn) {
        ITSoundHandler sound = playingSounds.get(posIn);
        if (sound == null) {
            return;
        }
        sound.stopSound();
    }

    public ITSoundHandler(BlockPos posIn, SoundEvent soundIn, SoundCategory categoryIn, boolean repeatIn, float volumeIn, float pitchIn) {
        super(soundIn, categoryIn);
        this.pos = posIn;
        this.unmodifiedVolume = volumeIn;
        this.field_147662_b = volumeIn * ClientProxy.volumeAdjustment;
        this.field_147663_c = pitchIn;
        this.field_147660_d = (float)this.pos.func_177958_n() + 0.5f;
        this.field_147661_e = (float)this.pos.func_177956_o() + 0.5f;
        this.field_147658_f = (float)this.pos.func_177952_p() + 0.5f;
        this.field_147659_g = repeatIn;
        this.field_147666_i = ISound.AttenuationType.NONE;
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)this);
    }

    public boolean func_147667_k() {
        return !playingSounds.containsValue((Object)this);
    }

    public static boolean isPlaying(BlockPos posIn) {
        return playingSounds.get(posIn) != null;
    }

    public void func_73660_a() {
    }

    private void stopSound(boolean keepOnList) {
        if (!keepOnList) {
            playingSounds.remove(this.pos);
        }
        Minecraft.func_71410_x().func_147118_V().func_147683_b((ISound)this);
    }

    private void stopSound() {
        this.stopSound(false);
    }

    public static void DeleteAllSounds() {
        playingSounds.forEach((blockPos, itSoundHandler) -> itSoundHandler.stopSound(true));
        playingSounds.clear();
    }

    private void updateVolume() {
        this.field_147662_b = this.unmodifiedVolume * ClientProxy.volumeAdjustment;
    }

    public static void UpdateAllVolumes() {
        playingSounds.forEach((blockPos, itSoundHandler) -> itSoundHandler.updateVolume());
    }
}

