/*
 * Decompiled with CFR 0.152.
 */
package de.curlybracket.eyeofdragons;

import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityEyeBase
extends Entity {
    private final double MAX_DISTANCE = 20.0;
    private double targetX;
    private double targetY;
    private double targetZ;
    private int ticksLived;
    private boolean shatter;
    private int id;

    public EntityEyeBase(World world) {
        super(world);
        this.func_70105_a(0.25f, 0.25f);
    }

    protected void func_70088_a() {
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double par1) {
        double d0 = this.func_174813_aQ().func_72320_b() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return par1 < (d0 *= 64.0) * d0;
    }

    public EntityEyeBase(World world, double x, double y, double z, int id) {
        super(world);
        this.func_70105_a(0.25f, 0.25f);
        this.func_70107_b(x, y, z);
        this.id = id;
        this.shatter = this.field_70146_Z.nextInt(100) > 59;
    }

    public void moveTowards(double x, double y, double z) {
        double deltaX = x - this.field_70165_t;
        double deltaZ = z - this.field_70161_v;
        double distance = MathHelper.func_76133_a((double)(deltaX * deltaX + deltaZ * deltaZ));
        if (distance > 20.0) {
            this.targetX = this.field_70165_t + deltaX / distance * 20.0;
            this.targetZ = this.field_70161_v + deltaZ / distance * 20.0;
            this.targetY = this.field_70163_u + 8.0;
        } else {
            this.targetX = x;
            this.targetY = y;
            this.targetZ = z;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.field_70159_w = x;
        this.field_70181_x = y;
        this.field_70179_y = z;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(x, z) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(y, Math.sqrt(x * x + z * z)) * 180.0 / Math.PI);
        }
    }

    public void func_70071_h_() {
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        super.func_70071_h_();
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        float distanceMoved = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
        World world = this.func_130014_f_();
        this.field_70125_A = (float)(Math.atan2(this.field_70181_x, distanceMoved) * 180.0 / Math.PI);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        if (!world.field_72995_K) {
            double dx = this.targetX - this.field_70165_t;
            double dz = this.targetZ - this.field_70161_v;
            float distAway = (float)Math.sqrt(dx * dx + dz * dz);
            float f2 = (float)Math.atan2(dz, dx);
            double d2 = (double)distanceMoved + (double)(distAway - distanceMoved) * 0.0025;
            if (distAway < 1.0f) {
                d2 *= 0.8;
                this.field_70181_x *= 0.8;
            }
            this.field_70159_w = Math.cos(f2) * d2;
            this.field_70179_y = Math.sin(f2) * d2;
            this.field_70181_x = this.field_70163_u < this.targetY ? (this.field_70181_x += (1.0 - this.field_70181_x) * (double)0.015f) : (this.field_70181_x += (-1.0 - this.field_70181_x) * (double)0.015f);
        }
        float f3 = 0.25f;
        if (this.func_70090_H()) {
            for (int i = 0; i < 4; ++i) {
                world.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * (double)f3, this.field_70163_u - this.field_70181_x * (double)f3, this.field_70161_v - this.field_70179_y * (double)f3, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
            }
        } else {
            world.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t - this.field_70159_w * (double)f3 + this.field_70146_Z.nextDouble() * 0.6 - 0.3, this.field_70163_u - this.field_70181_x * (double)f3 - 0.5, this.field_70161_v - this.field_70179_y * (double)f3 + this.field_70146_Z.nextDouble() * 0.6 - 0.3, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
        }
        if (!world.field_72995_K) {
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            ++this.ticksLived;
            if (this.ticksLived > 80 && !world.field_72995_K) {
                this.func_70106_y();
                if (this.shatter) {
                    world.func_72838_d((Entity)new EntityItem(world, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(this.getDropItem(), 1, this.id)));
                } else {
                    world.func_175718_b(2003, new BlockPos((Entity)this), 0);
                }
            }
        }
    }

    protected abstract Item getDropItem();

    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
    }

    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
    }
}

