/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimensions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import mcjty.rftoolsdim.ModSounds;
import mcjty.rftoolsdim.RFToolsDim;
import mcjty.rftoolsdim.config.GeneralConfiguration;
import mcjty.rftoolsdim.config.PowerConfiguration;
import mcjty.rftoolsdim.dimensions.DamageSourcePowerLow;
import mcjty.rftoolsdim.dimensions.DimensionInformation;
import mcjty.rftoolsdim.dimensions.DimensionStorage;
import mcjty.rftoolsdim.dimensions.RfToolsDimensionManager;
import mcjty.rftoolsdim.dimensions.description.DimensionDescriptor;
import mcjty.rftoolsdim.dimensions.types.EffectType;
import mcjty.rftoolsdim.dimensions.types.PatreonType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class DimensionTickEvent {
    public static final int MAXTICKS = 10;
    private int counter = 10;
    private static final int EFFECTS_MAX = 18;
    private int counterEffects = 18;
    private static Random random = new Random();
    private static int t = 0;
    private static int[] colors = new int[]{0xFF0000, 65280, 255, 0xFFFF00, 0xFF00FF, 65535, 0xFFFFFF, 0xFF5555, 0x55FF55, 0x5555FF, 0xFFFF55, 0xFF55FF, 0x55FFFF, 0x555555};
    public static Potion harm;
    public static Potion hunger;
    public static Potion digSlowdown;
    public static Potion digSpeed;
    public static Potion moveSlowdown;
    public static Potion moveSpeed;
    public static Potion weakness;
    public static Potion poison;
    public static Potion wither;
    public static Potion regeneration;
    public static Potion damageBoost;
    public static Potion heal;
    public static Potion jump;
    public static Potion confusion;
    public static Potion resistance;
    public static Potion fireResistance;
    public static Potion waterBreathing;
    public static Potion invisibility;
    public static Potion blindness;
    public static Potion nightVision;
    public static Potion healthBoost;
    public static Potion absorption;
    public static Potion saturation;
    static final Map<EffectType, Potion> effectsMap;
    static final Map<EffectType, Integer> effectAmplifierMap;

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent evt) {
        if (evt.phase == TickEvent.Phase.START) {
            return;
        }
        if (evt.world.field_73011_w.getDimension() != 0) {
            return;
        }
        --this.counter;
        if (this.counter <= 0) {
            this.counter = 10;
            --this.counterEffects;
            boolean doEffects = false;
            if (this.counterEffects <= 0) {
                this.counterEffects = 18;
                doEffects = true;
            }
            this.serverTick(evt.world, doEffects);
        }
    }

    private void serverTick(World entityWorld, boolean doEffects) {
        RfToolsDimensionManager dimensionManager = RfToolsDimensionManager.getDimensionManager(entityWorld);
        if (!dimensionManager.getDimensions().isEmpty()) {
            DimensionStorage dimensionStorage = DimensionStorage.getDimensionStorage(entityWorld);
            for (Map.Entry<Integer, DimensionDescriptor> entry : dimensionManager.getDimensions().entrySet()) {
                Integer id = entry.getKey();
                WorldServer world = DimensionManager.getWorld((int)id);
                DimensionInformation information = dimensionManager.getDimensionInformation(id);
                long power = !information.isCheater() && (world != null && world.func_72863_F().func_73152_e() > 0 || information.getProbeCounter() == 0) ? this.handlePower(doEffects, dimensionStorage, entry, id, information) : dimensionStorage.getEnergyLevel(id);
                if (doEffects && power > 0L) {
                    this.handleEffectsForDimension(power, id, information);
                }
                if (world == null || world.field_73010_i.isEmpty()) continue;
                this.handleRandomEffects(world, information);
            }
            dimensionStorage.save();
        }
    }

    private long handlePower(boolean doEffects, DimensionStorage dimensionStorage, Map.Entry<Integer, DimensionDescriptor> entry, Integer id, DimensionInformation information) {
        int cost = 0;
        if (PowerConfiguration.dimensionDifficulty != -1 && (cost = information.getActualRfCost()) == 0) {
            cost = entry.getValue().getRfMaintainCost();
        }
        long power = dimensionStorage.getEnergyLevel(id);
        if ((power -= (long)(cost * 10)) < 0L) {
            power = 0L;
        }
        this.handleLowPower(id, power, doEffects, cost);
        dimensionStorage.setEnergyLevel(id, power);
        return power;
    }

    private void handleRandomEffects(WorldServer world, DimensionInformation information) {
        if (information.isPatreonBitSet(PatreonType.PATREON_FIREWORKS)) {
            this.handleFireworks(world);
        }
        if (information.isPatreonBitSet(PatreonType.PATREON_TOMWOLF)) {
            this.handleHowlingWolf(world, information);
        }
    }

    private void handleHowlingWolf(WorldServer world, DimensionInformation information) {
        if (information.getCelestialAngle() == null) {
            float a = world.func_72826_c(1.0f);
            if (--t <= 0) {
                t = 0;
            }
            if (Math.abs(a - 0.5f) < 0.05f && t <= 0) {
                this.playHowl(world);
                t = 40;
            }
        } else if ((double)random.nextFloat() < 0.001) {
            this.playHowl(world);
        }
    }

    private void playHowl(WorldServer world) {
        for (EntityPlayer player : world.field_73010_i) {
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, ModSounds.wolfhowl, SoundCategory.AMBIENT, 1.0f, 1.0f);
        }
    }

    private void handleFireworks(WorldServer world) {
        if ((double)random.nextFloat() < 0.05) {
            double minPosX = 1.0E9;
            double minPosZ = 1.0E9;
            double maxPosX = -1.0E9;
            double maxPosZ = -1.0E9;
            for (EntityPlayer player : world.field_73010_i) {
                if (player.field_70165_t > maxPosX) {
                    maxPosX = player.field_70165_t;
                }
                if (player.field_70165_t < minPosX) {
                    minPosX = player.field_70165_t;
                }
                if (player.field_70161_v > maxPosZ) {
                    maxPosZ = player.field_70161_v;
                }
                if (!(player.field_70161_v < minPosZ)) continue;
                minPosZ = player.field_70161_v;
            }
            double posX = (double)random.nextFloat() * (maxPosX - minPosX + 60.0) + minPosX - 30.0;
            double posZ = (double)random.nextFloat() * (maxPosZ - minPosZ + 60.0) + minPosZ - 30.0;
            ItemStack fireworkStack = new ItemStack(Items.field_151152_bP);
            NBTTagCompound tag = new NBTTagCompound();
            NBTTagCompound fireworks = new NBTTagCompound();
            fireworks.func_74774_a("Flight", (byte)2);
            NBTTagList explosions = new NBTTagList();
            explosions.func_74742_a((NBTBase)this.makeExplosion(tag));
            fireworks.func_74782_a("Explosions", (NBTBase)explosions);
            tag.func_74782_a("Fireworks", (NBTBase)fireworks);
            fireworkStack.func_77982_d(tag);
            BlockPos newpos = world.func_175672_r(new BlockPos((int)posX, 0, (int)posZ));
            newpos = newpos.func_177956_o() == -1 ? new BlockPos(newpos.func_177958_n(), 64, newpos.func_177952_p()) : new BlockPos(newpos.func_177958_n(), newpos.func_177956_o() + 3, newpos.func_177952_p());
            EntityFireworkRocket entityfireworkrocket = new EntityFireworkRocket((World)world, (double)newpos.func_177958_n(), (double)newpos.func_177956_o(), (double)newpos.func_177952_p(), fireworkStack);
            world.func_72838_d((Entity)entityfireworkrocket);
        }
    }

    private NBTTagCompound makeExplosion(NBTTagCompound tag) {
        NBTTagCompound explosion = new NBTTagCompound();
        explosion.func_74757_a("Flicker", true);
        explosion.func_74757_a("Tail", true);
        explosion.func_74774_a("Type", (byte)(random.nextInt(4) + 1));
        explosion.func_74783_a("Colors", new int[]{colors[random.nextInt(colors.length)], colors[random.nextInt(colors.length)], colors[random.nextInt(colors.length)]});
        tag.func_74782_a("Explosion", (NBTBase)explosion);
        return explosion;
    }

    private static void getPotions() {
        if (harm == null) {
            harm = (Potion)Potion.field_188414_b.func_82594_a((Object)new ResourceLocation("instant_damage"));
            hunger = (Potion)Potion.field_188414_b.func_82594_a((Object)new ResourceLocation("hunger"));
            digSpeed = (Potion)Potion.field_188414_b.func_82594_a((Object)new ResourceLocation("haste"));
            digSlowdown = (Potion)Potion.field_188414_b.func_82594_a((Object)new ResourceLocation("mining_fatigue"));
            moveSlowdown = (Potion)Potion.field_188414_b.func_82594_a((Object)new ResourceLocation("slowness"));
            moveSpeed = (Potion)Potion.field_188414_b.func_82594_a((Object)new ResourceLocation("speed"));
            weakness = (Potion)Potion.field_188414_b.func_82594_a((Object)new ResourceLocation("weakness"));
            poison = (Potion)Potion.field_188414_b.func_82594_a((Object)new ResourceLocation("poison"));
            wither = (Potion)Potion.field_188414_b.func_82594_a((Object)new ResourceLocation("wither"));
            regeneration = (Potion)Potion.field_188414_b.func_82594_a((Object)new ResourceLocation("regeneration"));
            damageBoost = (Potion)Potion.field_188414_b.func_82594_a((Object)new ResourceLocation("strength"));
            heal = (Potion)Potion.field_188414_b.func_82594_a((Object)new ResourceLocation("instant_health"));
            jump = (Potion)Potion.field_188414_b.func_82594_a((Object)new ResourceLocation("jump_boost"));
            confusion = (Potion)Potion.field_188414_b.func_82594_a((Object)new ResourceLocation("nausea"));
            resistance = (Potion)Potion.field_188414_b.func_82594_a((Object)new ResourceLocation("resistance"));
            fireResistance = (Potion)Potion.field_188414_b.func_82594_a((Object)new ResourceLocation("fire_resistance"));
            waterBreathing = (Potion)Potion.field_188414_b.func_82594_a((Object)new ResourceLocation("water_breathing"));
            invisibility = (Potion)Potion.field_188414_b.func_82594_a((Object)new ResourceLocation("invisibility"));
            blindness = (Potion)Potion.field_188414_b.func_82594_a((Object)new ResourceLocation("blindness"));
            nightVision = (Potion)Potion.field_188414_b.func_82594_a((Object)new ResourceLocation("night_vision"));
            healthBoost = (Potion)Potion.field_188414_b.func_82594_a((Object)new ResourceLocation("health_boost"));
            absorption = (Potion)Potion.field_188414_b.func_82594_a((Object)new ResourceLocation("absorption"));
            saturation = (Potion)Potion.field_188414_b.func_82594_a((Object)new ResourceLocation("saturation"));
            effectsMap.put(EffectType.EFFECT_POISON, poison);
            effectsMap.put(EffectType.EFFECT_POISON2, poison);
            effectAmplifierMap.put(EffectType.EFFECT_POISON2, 1);
            effectsMap.put(EffectType.EFFECT_POISON3, poison);
            effectAmplifierMap.put(EffectType.EFFECT_POISON3, 2);
            effectsMap.put(EffectType.EFFECT_REGENERATION, regeneration);
            effectsMap.put(EffectType.EFFECT_REGENERATION2, regeneration);
            effectAmplifierMap.put(EffectType.EFFECT_REGENERATION2, 1);
            effectsMap.put(EffectType.EFFECT_REGENERATION3, regeneration);
            effectAmplifierMap.put(EffectType.EFFECT_REGENERATION3, 2);
            effectsMap.put(EffectType.EFFECT_MOVESLOWDOWN, moveSlowdown);
            effectsMap.put(EffectType.EFFECT_MOVESLOWDOWN2, moveSlowdown);
            effectAmplifierMap.put(EffectType.EFFECT_MOVESLOWDOWN2, 1);
            effectsMap.put(EffectType.EFFECT_MOVESLOWDOWN3, moveSlowdown);
            effectAmplifierMap.put(EffectType.EFFECT_MOVESLOWDOWN3, 2);
            effectsMap.put(EffectType.EFFECT_MOVESLOWDOWN4, moveSlowdown);
            effectAmplifierMap.put(EffectType.EFFECT_MOVESLOWDOWN4, 3);
            effectsMap.put(EffectType.EFFECT_MOVESPEED, moveSpeed);
            effectsMap.put(EffectType.EFFECT_MOVESPEED2, moveSpeed);
            effectAmplifierMap.put(EffectType.EFFECT_MOVESPEED2, 1);
            effectsMap.put(EffectType.EFFECT_MOVESPEED3, moveSpeed);
            effectAmplifierMap.put(EffectType.EFFECT_MOVESPEED3, 2);
            effectsMap.put(EffectType.EFFECT_DIGSLOWDOWN, digSlowdown);
            effectsMap.put(EffectType.EFFECT_DIGSLOWDOWN2, digSlowdown);
            effectAmplifierMap.put(EffectType.EFFECT_DIGSLOWDOWN2, 1);
            effectsMap.put(EffectType.EFFECT_DIGSLOWDOWN3, digSlowdown);
            effectAmplifierMap.put(EffectType.EFFECT_DIGSLOWDOWN3, 2);
            effectsMap.put(EffectType.EFFECT_DIGSLOWDOWN4, digSlowdown);
            effectAmplifierMap.put(EffectType.EFFECT_DIGSLOWDOWN4, 3);
            effectsMap.put(EffectType.EFFECT_DIGSPEED, digSpeed);
            effectsMap.put(EffectType.EFFECT_DIGSPEED2, digSpeed);
            effectAmplifierMap.put(EffectType.EFFECT_DIGSPEED2, 1);
            effectsMap.put(EffectType.EFFECT_DIGSPEED3, digSpeed);
            effectAmplifierMap.put(EffectType.EFFECT_DIGSPEED3, 2);
            effectsMap.put(EffectType.EFFECT_DAMAGEBOOST, damageBoost);
            effectsMap.put(EffectType.EFFECT_DAMAGEBOOST2, damageBoost);
            effectAmplifierMap.put(EffectType.EFFECT_DAMAGEBOOST2, 1);
            effectsMap.put(EffectType.EFFECT_DAMAGEBOOST3, damageBoost);
            effectAmplifierMap.put(EffectType.EFFECT_DAMAGEBOOST3, 2);
            effectsMap.put(EffectType.EFFECT_INSTANTHEALTH, heal);
            effectsMap.put(EffectType.EFFECT_HARM, harm);
            effectsMap.put(EffectType.EFFECT_JUMP, jump);
            effectsMap.put(EffectType.EFFECT_JUMP2, jump);
            effectAmplifierMap.put(EffectType.EFFECT_JUMP2, 1);
            effectsMap.put(EffectType.EFFECT_JUMP3, jump);
            effectAmplifierMap.put(EffectType.EFFECT_JUMP3, 2);
            effectsMap.put(EffectType.EFFECT_CONFUSION, confusion);
            effectsMap.put(EffectType.EFFECT_RESISTANCE, resistance);
            effectsMap.put(EffectType.EFFECT_RESISTANCE2, resistance);
            effectAmplifierMap.put(EffectType.EFFECT_RESISTANCE2, 1);
            effectsMap.put(EffectType.EFFECT_RESISTANCE3, resistance);
            effectAmplifierMap.put(EffectType.EFFECT_RESISTANCE3, 2);
            effectsMap.put(EffectType.EFFECT_FIRERESISTANCE, fireResistance);
            effectsMap.put(EffectType.EFFECT_WATERBREATHING, waterBreathing);
            effectsMap.put(EffectType.EFFECT_INVISIBILITY, invisibility);
            effectsMap.put(EffectType.EFFECT_BLINDNESS, blindness);
            effectsMap.put(EffectType.EFFECT_NIGHTVISION, nightVision);
            effectsMap.put(EffectType.EFFECT_HUNGER, hunger);
            effectsMap.put(EffectType.EFFECT_HUNGER2, hunger);
            effectAmplifierMap.put(EffectType.EFFECT_HUNGER2, 1);
            effectsMap.put(EffectType.EFFECT_HUNGER3, hunger);
            effectAmplifierMap.put(EffectType.EFFECT_HUNGER3, 2);
            effectsMap.put(EffectType.EFFECT_WEAKNESS, weakness);
            effectsMap.put(EffectType.EFFECT_WEAKNESS2, weakness);
            effectAmplifierMap.put(EffectType.EFFECT_WEAKNESS2, 1);
            effectsMap.put(EffectType.EFFECT_WEAKNESS3, weakness);
            effectAmplifierMap.put(EffectType.EFFECT_WEAKNESS3, 2);
            effectsMap.put(EffectType.EFFECT_WITHER, wither);
            effectsMap.put(EffectType.EFFECT_WITHER2, wither);
            effectAmplifierMap.put(EffectType.EFFECT_WITHER2, 1);
            effectsMap.put(EffectType.EFFECT_WITHER3, wither);
            effectAmplifierMap.put(EffectType.EFFECT_WITHER3, 2);
            effectsMap.put(EffectType.EFFECT_HEALTHBOOST, healthBoost);
            effectsMap.put(EffectType.EFFECT_HEALTHBOOST2, healthBoost);
            effectAmplifierMap.put(EffectType.EFFECT_HEALTHBOOST2, 1);
            effectsMap.put(EffectType.EFFECT_HEALTHBOOST3, healthBoost);
            effectAmplifierMap.put(EffectType.EFFECT_HEALTHBOOST3, 2);
            effectsMap.put(EffectType.EFFECT_ABSORPTION, absorption);
            effectsMap.put(EffectType.EFFECT_ABSORPTION2, absorption);
            effectAmplifierMap.put(EffectType.EFFECT_ABSORPTION2, 1);
            effectsMap.put(EffectType.EFFECT_ABSORPTION3, absorption);
            effectAmplifierMap.put(EffectType.EFFECT_ABSORPTION3, 2);
            effectsMap.put(EffectType.EFFECT_SATURATION, saturation);
            effectsMap.put(EffectType.EFFECT_SATURATION2, saturation);
            effectAmplifierMap.put(EffectType.EFFECT_SATURATION2, 1);
            effectsMap.put(EffectType.EFFECT_SATURATION3, saturation);
            effectAmplifierMap.put(EffectType.EFFECT_SATURATION3, 2);
        }
    }

    private void handleEffectsForDimension(long power, int id, DimensionInformation information) {
        DimensionTickEvent.getPotions();
        WorldServer world = DimensionManager.getWorld((int)id);
        if (world != null) {
            Set<EffectType> effects = information.getEffectTypes();
            ArrayList players = new ArrayList(world.field_73010_i);
            for (EntityPlayer player : players) {
                for (EffectType effect : effects) {
                    Potion potionEffect = effectsMap.get((Object)effect);
                    if (potionEffect != null) {
                        Integer amplifier = effectAmplifierMap.get((Object)effect);
                        if (amplifier == null) {
                            amplifier = 0;
                        }
                        player.func_70690_d(new PotionEffect(potionEffect, 540, amplifier.intValue(), true, true));
                        continue;
                    }
                    if (effect != EffectType.EFFECT_FLIGHT) continue;
                }
                if (power < (long)PowerConfiguration.DIMPOWER_WARN3) {
                    player.func_70690_d(new PotionEffect(moveSlowdown, 360, 4, true, true));
                    player.func_70690_d(new PotionEffect(digSlowdown, 360, 4, true, true));
                    player.func_70690_d(new PotionEffect(poison, 360, 2, true, true));
                    player.func_70690_d(new PotionEffect(hunger, 360, 2, true, true));
                    continue;
                }
                if (power < (long)PowerConfiguration.DIMPOWER_WARN2) {
                    player.func_70690_d(new PotionEffect(moveSlowdown, 360, 2, true, true));
                    player.func_70690_d(new PotionEffect(digSlowdown, 360, 2, true, true));
                    player.func_70690_d(new PotionEffect(hunger, 360, 1, true, true));
                    continue;
                }
                if (power >= (long)PowerConfiguration.DIMPOWER_WARN1) continue;
                player.func_70690_d(new PotionEffect(moveSlowdown, 360, 0, true, true));
                player.func_70690_d(new PotionEffect(digSlowdown, 360, 0, true, true));
            }
        }
    }

    private void handleLowPower(Integer id, long power, boolean doEffects, int phasedCost) {
        block7: {
            WorldServer world;
            DimensionTickEvent.getPotions();
            if (power > 0L || (world = DimensionManager.getWorld((int)id)) == null) break block7;
            ArrayList players = new ArrayList(world.field_73010_i);
            if (PowerConfiguration.dimensionDifficulty >= 1) {
                for (EntityPlayer player : players) {
                    if (!RfToolsDimensionManager.checkValidPhasedFieldGenerator(player, true, phasedCost)) {
                        player.func_70097_a((DamageSource)new DamageSourcePowerLow("powerLow"), 1000000.0f);
                        continue;
                    }
                    if (!doEffects || !PowerConfiguration.phasedFieldGeneratorDebuf) continue;
                    player.func_70690_d(new PotionEffect(moveSlowdown, 180, 4, true, true));
                    player.func_70690_d(new PotionEffect(digSlowdown, 180, 2, true, true));
                    player.func_70690_d(new PotionEffect(hunger, 180, 2, true, true));
                }
            } else {
                Random random = new Random();
                for (EntityPlayer player : players) {
                    if (!RfToolsDimensionManager.checkValidPhasedFieldGenerator(player, true, phasedCost)) {
                        int z;
                        int x;
                        WorldServer worldServerForDimension = player.func_130014_f_().func_73046_m().func_71218_a(GeneralConfiguration.spawnDimension);
                        int y = worldServerForDimension.func_175672_r(new BlockPos(x = random.nextInt(2000) - 1000, 0, z = random.nextInt(2000) - 1000)).func_177956_o();
                        if (y == -1) {
                            y = 63;
                        }
                        RFToolsDim.teleportationManager.teleportPlayer(player, GeneralConfiguration.spawnDimension, new BlockPos(x, y, z));
                        continue;
                    }
                    if (!doEffects) continue;
                    player.func_70690_d(new PotionEffect(moveSlowdown, 180, 4, true, true));
                    player.func_70690_d(new PotionEffect(digSlowdown, 180, 4, true, true));
                    player.func_70690_d(new PotionEffect(hunger, 180, 2, true, true));
                }
            }
        }
    }

    static {
        effectsMap = new HashMap<EffectType, Potion>();
        effectAmplifierMap = new HashMap<EffectType, Integer>();
    }
}

