/*
 * Decompiled with CFR 0.152.
 */
package gaia;

import gaia.GaiaConfig;
import gaia.command.CommandBiome;
import gaia.command.CommandSpawn;
import gaia.compat.thaumcraft.AspectsEntities;
import gaia.compat.thaumcraft.AspectsItems;
import gaia.datafixes.BlockIdFixer;
import gaia.datafixes.BustTileIdFixer;
import gaia.datafixes.EntityIdFixer;
import gaia.datafixes.ItemIdFixer;
import gaia.init.GaiaItems;
import gaia.init.GaiaSpawning;
import gaia.proxy.CommonProxy;
import net.minecraft.command.ICommand;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.datafix.IFixableData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ModFixs;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="grimoireofgaia", name="Grimoire of Gaia 3", version="1.7.2", acceptedMinecraftVersions="1.12.2", dependencies="required-after:forge@[14.23.4.2705,);after:baubles@[1.4.2,]")
public class Gaia {
    public static final Logger LOGGER = LogManager.getLogger((String)"grimoireofgaia");
    @SidedProxy(clientSide="gaia.proxy.ClientProxy", serverSide="gaia.proxy.CommonProxy")
    public static CommonProxy proxy;
    private static final int DATA_FIXER_VERSION = 3;
    public static boolean isBaublesLoaded;
    public static boolean isThaumcraftLoaded;
    public static boolean isTConstructLoaded;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        proxy.registerHandlers();
        proxy.registerRenders();
        if (Loader.isModLoaded((String)"baubles")) {
            isBaublesLoaded = true;
        }
        if (Loader.isModLoaded((String)"thaumcraft")) {
            MinecraftForge.EVENT_BUS.register(AspectsItems.class);
            MinecraftForge.EVENT_BUS.register(AspectsEntities.class);
            isThaumcraftLoaded = true;
        }
        if (Loader.isModLoaded((String)"tconstruct")) {
            isTConstructLoaded = true;
        }
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        GaiaItems.RegistrationHandler.registerOres();
        MinecraftForge.EVENT_BUS.register((Object)this);
        proxy.registerTileRenders();
        proxy.registerLayerRenders();
        ModFixs fixes = FMLCommonHandler.instance().getDataFixer().init("grimoireofgaia", 3);
        fixes.registerFix((IFixType)FixTypes.BLOCK_ENTITY, (IFixableData)new BustTileIdFixer());
        fixes.registerFix((IFixType)FixTypes.ITEM_INSTANCE, (IFixableData)new ItemIdFixer());
        fixes.registerFix((IFixType)FixTypes.ENTITY, (IFixableData)new EntityIdFixer());
        fixes.registerFix((IFixType)FixTypes.ITEM_INSTANCE, (IFixableData)new BlockIdFixer());
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        if (GaiaConfig.DEBUG.debugCommands) {
            event.registerServerCommand((ICommand)new CommandBiome());
            event.registerServerCommand((ICommand)new CommandSpawn());
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (GaiaConfig.OPTIONS.enableSpawn) {
            GaiaSpawning.register();
        }
    }
}

