/*
 * Decompiled with CFR 0.152.
 */
package gaia.command;

import gaia.Gaia;
import java.lang.reflect.Field;
import java.util.Optional;
import java.util.Set;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class CommandBiome
extends CommandBase {
    private static final Field BIOME_NAME = ReflectionHelper.findField(Biome.class, (String[])new String[]{"biomeName", "field_76791_y"});

    public String func_71517_b() {
        return "gog-biome";
    }

    public String func_71518_a(ICommandSender sender) {
        return "<list|biomeId>";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        World world = sender.func_130014_f_();
        if (world.field_72995_K) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Not processing on Client side"));
            return;
        }
        if (args.length == 0) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GRAY + "/gog-biome <list|biomeId>"));
            return;
        }
        String command = args[0].toLowerCase();
        Optional<Integer> biomeId = this.getBiomeIdFromArgument(command);
        if (biomeId.isPresent()) {
            this.biomeDebug(world, sender, biomeId.get());
        } else {
            this.biomeList(server);
        }
    }

    private String getBiomeName(Biome b) {
        try {
            return (String)BIOME_NAME.get(b);
        }
        catch (IllegalAccessException e) {
            Gaia.LOGGER.error((Object)e);
            return "";
        }
    }

    private void biomeDebug(World world, ICommandSender sender, int biomeId) {
        if (biomeId <= -1 || Biome.func_185357_a((int)biomeId) == null) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Invalid Biome ID"));
            return;
        }
        EntityPlayer player = (EntityPlayer)sender.func_174793_f();
        if (player == null) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Non player command sender not supported"));
            return;
        }
        Biome biome = Biome.func_185357_a((int)biomeId);
        String biomeName = this.getBiomeName(biome);
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Transforming Local Biomes to ID of :  " + biomeId + " : " + biomeName));
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GRAY + "You may have to reload your client"));
        this.biomeTypes(biome);
        BlockPos posp = player.func_180425_c();
        int max = 32;
        for (int start = -(max / 2); start < max; ++start) {
            for (int start2 = -(max / 2); start2 < max; ++start2) {
                BlockPos pos = new BlockPos(posp.func_177958_n() + start, posp.func_177956_o(), posp.func_177952_p() + start2);
                Chunk chunk = world.func_175726_f(pos);
                ChunkPos chunkPos = new ChunkPos(pos);
                int rx = chunkPos.field_77276_a;
                int rz = chunkPos.field_77275_b;
                byte[] biomeArray = chunk.func_76605_m();
                biomeArray[rz << 4 | rx] = (byte)(biomeId & 0xFF);
                chunk.func_177427_f(true);
                world.func_72863_F().func_186025_d(chunk.field_76635_g, chunk.field_76647_h);
                world.func_175704_b(pos, pos);
            }
        }
    }

    private void biomeList(MinecraftServer server) {
        this.showDictionaries();
        for (Biome biome : Biome.field_185377_q) {
            String name = this.getBiomeName(biome);
            int id = Biome.func_185362_a((Biome)biome);
            Gaia.LOGGER.info(id + ": " + name);
            this.biomeTypes(biome);
        }
        server.func_184103_al().func_148539_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Biome Listings Printed to Console"));
    }

    private void biomeTypes(Biome biome) {
        Set map = BiomeDictionary.getTypes((Biome)biome);
        StringBuilder builder = new StringBuilder("Types: ");
        for (BiomeDictionary.Type type : map) {
            builder.append(type.toString()).append(", ");
        }
        Gaia.LOGGER.info(builder.toString());
        Gaia.LOGGER.info(" ");
    }

    private void showDictionaries() {
        Set forest = BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST);
        Set sandy = BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SANDY);
        Set mesa = BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.MESA);
        Set plains = BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS);
        Set swamp = BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SWAMP);
        Set spooky = BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SPOOKY);
        Set jungle = BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE);
        Set snowy = BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SNOWY);
        Set mountain = BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN);
        Set hill = BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.HILLS);
        Set water = BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.WATER);
        Set ocean = BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.OCEAN);
        Set river = BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.RIVER);
        Set beach = BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.BEACH);
        Set hell = BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.NETHER);
        Set sky = BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.END);
        String s = " type biomes include:";
        Gaia.LOGGER.info("Forest" + s);
        this.getTypes(forest);
        Gaia.LOGGER.info("");
        Gaia.LOGGER.info("Sandy" + s);
        this.getTypes(sandy);
        Gaia.LOGGER.info("");
        Gaia.LOGGER.info("Mesa" + s);
        this.getTypes(mesa);
        Gaia.LOGGER.info("");
        Gaia.LOGGER.info("Plains" + s);
        this.getTypes(plains);
        Gaia.LOGGER.info("");
        Gaia.LOGGER.info("Swamp" + s);
        this.getTypes(swamp);
        Gaia.LOGGER.info("");
        Gaia.LOGGER.info("Spooky" + s);
        this.getTypes(spooky);
        Gaia.LOGGER.info("");
        Gaia.LOGGER.info("Jungle" + s);
        this.getTypes(jungle);
        Gaia.LOGGER.info("");
        Gaia.LOGGER.info("Snowy" + s);
        this.getTypes(snowy);
        Gaia.LOGGER.info("");
        Gaia.LOGGER.info("Mountain" + s);
        this.getTypes(mountain);
        Gaia.LOGGER.info("");
        Gaia.LOGGER.info("Hills" + s);
        this.getTypes(hill);
        Gaia.LOGGER.info("");
        Gaia.LOGGER.info("Waters" + s);
        this.getTypes(water);
        Gaia.LOGGER.info("");
        Gaia.LOGGER.info("Ocean" + s);
        this.getTypes(ocean);
        Gaia.LOGGER.info("");
        Gaia.LOGGER.info("River" + s);
        this.getTypes(river);
        Gaia.LOGGER.info("");
        Gaia.LOGGER.info("Beach" + s);
        this.getTypes(beach);
        Gaia.LOGGER.info("");
        Gaia.LOGGER.info("Hell" + s);
        this.getTypes(hell);
        Gaia.LOGGER.info("");
        Gaia.LOGGER.info("Sky" + s);
        this.getTypes(sky);
        Gaia.LOGGER.info("");
    }

    private void getTypes(Set<Biome> biomes) {
        for (Biome biome : biomes) {
            Gaia.LOGGER.info(this.getBiomeName(biome));
        }
    }

    private Optional<Integer> getBiomeIdFromArgument(String s) {
        try {
            return Optional.of(Integer.parseInt(s));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }
}

