/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity;

import com.google.common.collect.Sets;
import gaia.GaiaConfig;
import gaia.entity.EntityMobAssistBase;
import gaia.init.GaiaBlocks;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public abstract class EntityMobAssistDay
extends EntityMobAssistBase {
    private static Set<Block> spawnBlocks = Sets.newHashSet((Object[])new Block[]{Blocks.field_150349_c, Blocks.field_150346_d, Blocks.field_150351_n, Blocks.field_150354_m, Blocks.field_150431_aC, Blocks.field_150433_aE});
    private static Set<Block> blackList = Sets.newHashSet((Object[])new Block[]{GaiaBlocks.SPAWN_GUARD});

    public EntityMobAssistDay(World worldIn) {
        super(worldIn);
    }

    @Override
    public boolean func_70601_bi() {
        super.func_70601_bi();
        if (GaiaConfig.SPAWN.spawnDaysPassed) {
            return this.daysPassed() && this.spawnConditions();
        }
        return this.spawnConditions();
    }

    public boolean spawnConditions() {
        float f;
        if (this.field_70170_p.func_72935_r() && (f = this.func_70013_c()) > 0.5f && this.field_70170_p.func_175678_i(this.func_180425_c())) {
            if (EntityMobAssistDay.torchCheck(this.field_70170_p, this.func_180425_c())) {
                return false;
            }
            int i = MathHelper.func_76128_c((double)this.field_70165_t);
            int j = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b);
            int k = MathHelper.func_76128_c((double)this.field_70161_v);
            BlockPos blockpos = new BlockPos(i, j, k);
            Block var1 = this.field_70170_p.func_180495_p(blockpos.func_177977_b()).func_177230_c();
            HashSet<String> additionalBlocks = new HashSet<String>(Arrays.asList(GaiaConfig.SPAWN.additionalSpawnBlocks));
            boolean defaultFlag = spawnBlocks.contains(var1);
            boolean additionalFlag = !additionalBlocks.isEmpty() && additionalBlocks.contains(var1.getRegistryName().toString());
            return (defaultFlag || additionalFlag) && !this.field_70170_p.func_72953_d(this.func_174813_aQ());
        }
        return false;
    }

    private static boolean torchCheck(World world, BlockPos pos) {
        for (BlockPos location : BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-8, -8, -8), (BlockPos)pos.func_177982_a(8, 8, 8))) {
            if (!blackList.contains(world.func_180495_p(location).func_177230_c())) continue;
            return true;
        }
        return false;
    }
}

