/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity.debug;

import gaia.entity.EntityAttributes;
import gaia.entity.EntityMobHostileDay;
import gaia.entity.ai.EntityAIGaiaLeapAtTarget;
import gaia.init.GaiaItems;
import gaia.init.GaiaSounds;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;

public class EntityDebugMob
extends EntityMobHostileDay {
    private EntityAIGaiaLeapAtTarget aiGaiaLeapAtTarget = new EntityAIGaiaLeapAtTarget((EntityLiving)this, 0.4f);
    private EntityAIAttackMelee aiMeleeAttack = new AILeapAttack(this);
    private static int manual_clock;
    private boolean debugMode;
    private boolean enableAnimation;
    short timer;
    boolean sitting;
    private static final DataParameter<Boolean> SITTING;

    public EntityDebugMob(World worldIn) {
        super(worldIn);
        this.field_70728_aV = 10;
        this.field_70138_W = 1.0f;
        this.timer = (short)20;
        manual_clock = 0;
        this.sitting = false;
        this.debugMode = false;
        this.enableAnimation = false;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.25, true));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)EntityAttributes.MAX_HEALTH_1);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)EntityAttributes.ATTACK_DAMAGE_1);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(4.0);
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        return super.func_70097_a(source, Math.min(damage, EntityAttributes.BASE_DEFENSE_1));
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.clock()) {
            if (this.sitting) {
                if (this.enableAnimation) {
                    this.sitting = false;
                    this.setSitting(false);
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151051_r));
                    this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack((Item)Items.field_151031_f));
                    this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.225);
                    this.field_70714_bg.func_85156_a((EntityAIBase)this.aiGaiaLeapAtTarget);
                }
            } else if (!this.sitting && this.enableAnimation) {
                this.sitting = true;
                this.setSitting(true);
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
                this.func_184201_a(EntityEquipmentSlot.OFFHAND, ItemStack.field_190927_a);
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.375);
                this.field_70714_bg.func_75776_a(0, (EntityAIBase)this.aiGaiaLeapAtTarget);
            }
        }
    }

    @Override
    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, DamageSource source) {
        this.dropRandomLootFromLootTable(LootTableList.field_186421_c, wasRecentlyHit, lootingModifier, source);
        this.func_70628_a(wasRecentlyHit, lootingModifier);
    }

    public void dropRandomLootFromLootTable(ResourceLocation dungeonLoot, boolean wasRecentlyHit, int lootingModifier, DamageSource source) {
        long LootTableSeed = 0L;
        int maxCount = 0;
        int currentCount = 0;
        Random Randomize = new Random();
        int roll = 0;
        LootTable loottable = this.field_70170_p.func_184146_ak().func_186521_a(dungeonLoot);
        LootContext.Builder lootcontext$builder = new LootContext.Builder((WorldServer)this.field_70170_p).func_186472_a((Entity)this).func_186473_a(source);
        if (wasRecentlyHit && this.field_70717_bb != null) {
            lootcontext$builder = lootcontext$builder.func_186470_a(this.field_70717_bb).func_186469_a(this.field_70717_bb.func_184817_da());
        }
        for (ItemStack itemstack : loottable.func_186462_a(LootTableSeed == 0L ? this.field_70146_Z : new Random(LootTableSeed), lootcontext$builder.func_186471_a())) {
            ++maxCount;
        }
        roll = Randomize.nextInt(maxCount);
        for (ItemStack itemstack : loottable.func_186462_a(LootTableSeed == 0L ? this.field_70146_Z : new Random(LootTableSeed), lootcontext$builder.func_186471_a())) {
            if (currentCount == roll) {
                this.func_70099_a(itemstack, 0.0f);
            }
            ++currentCount;
        }
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        System.out.println("I died!");
        ItemStack enchantmentBook = new ItemStack(Items.field_151134_bR);
        ItemEnchantedBook.func_92115_a((ItemStack)enchantmentBook, (EnchantmentData)new EnchantmentData(Enchantments.field_180313_o, 1));
        ItemEnchantedBook.func_92115_a((ItemStack)enchantmentBook, (EnchantmentData)new EnchantmentData(Enchantment.func_185262_c((int)70), 1));
        enchantmentBook.func_151001_c("Mysterious Tome");
        this.func_70099_a(enchantmentBook, 1.0f);
        ItemStack shirt = new ItemStack((Item)Items.field_151027_R);
        shirt.func_77966_a(Enchantments.field_180310_c, 1);
        ItemArmor itemArmor = (ItemArmor)shirt.func_77973_b();
        itemArmor.func_82813_b(shirt, 5681460);
        shirt.func_151001_c("Dusty Shirt");
        this.func_70099_a(shirt, 1.0f);
        ItemStack rod = new ItemStack((Item)Items.field_151112_aM);
        rod.func_77966_a(Enchantments.field_151369_A, 1);
        rod.func_151001_c("Arctic Fishing Rod");
        this.func_70099_a(rod, 1.0f);
        if ((this.field_70146_Z.nextInt(40) == 0 || this.field_70146_Z.nextInt(1 + lootingModifier) > 0) && this.field_70146_Z.nextInt(1) == 0) {
            this.func_145779_a(GaiaItems.BOX_IRON, 1);
        }
    }

    public boolean clock() {
        this.timer = (short)(this.timer + 1);
        if (this.timer > 100) {
            this.timer = 0;
            return true;
        }
        return false;
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("Timer")) {
            this.timer = tag.func_74765_d("Timer");
        }
        if (tag.func_74764_b("Sitting")) {
            this.sitting = tag.func_74767_n("Sitting");
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74777_a("Timer", this.timer);
        tag.func_74757_a("Sitting", this.sitting);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SITTING, (Object)false);
    }

    public boolean getSitting() {
        return (Boolean)this.field_70180_af.func_187225_a(SITTING);
    }

    public void setSitting(boolean flag) {
        this.field_70180_af.func_187227_b(SITTING, (Object)flag);
    }

    protected SoundEvent func_184639_G() {
        return GaiaSounds.DEBUG_SAY;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return GaiaSounds.DEBUG_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return GaiaSounds.DEBUG_DEATH;
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        IEntityLivingData ret = super.func_180482_a(difficulty, livingdata);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiGaiaLeapAtTarget);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.aiMeleeAttack);
        this.func_96094_a("Debug Mob");
        this.func_174805_g(true);
        if (!this.debugMode) {
            System.out.println("Disabled.");
            this.func_70106_y();
        }
        return ret;
    }

    @Override
    public boolean func_70601_bi() {
        return this.field_70163_u < 0.0 && super.func_70601_bi();
    }

    static {
        SITTING = EntityDataManager.func_187226_a(EntityDebugMob.class, (DataSerializer)DataSerializers.field_187198_h);
    }

    static class AILeapAttack
    extends EntityAIAttackMelee {
        AILeapAttack(EntityDebugMob entity) {
            super((EntityCreature)entity, 1.25, true);
        }

        protected double func_179512_a(EntityLivingBase attackTarget) {
            return 4.0 + (double)attackTarget.field_70130_N;
        }
    }
}

