/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity.monster;

import gaia.GaiaConfig;
import gaia.entity.EntityAttributes;
import gaia.entity.EntityMobHostileBase;
import gaia.init.GaiaItems;
import gaia.init.GaiaLootTables;
import gaia.init.GaiaSounds;
import gaia.items.ItemShard;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntitySpectralArrow;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityGaiaBanshee
extends EntityMobHostileBase {
    private static final int DETECTION_RANGE = 8;
    protected static final DataParameter<Byte> VEX_FLAGS = EntityDataManager.func_187226_a(EntityGaiaBanshee.class, (DataSerializer)DataSerializers.field_187191_a);
    @Nullable
    private BlockPos boundOrigin;

    public EntityGaiaBanshee(World worldIn) {
        super(worldIn);
        this.field_70728_aV = 20;
        this.field_70178_ae = true;
        this.field_70765_h = new AIMoveControl(this);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIChargeAttack());
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new AIMoveRandom());
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[]{EntityGaiaBanshee.class}));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)EntityAttributes.MAX_HEALTH_2);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.275);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)EntityAttributes.ATTACK_DAMAGE_2);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(8.0);
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        Entity entity = source.func_76364_f();
        if (entity instanceof EntityArrow) {
            damage += 2.0f;
        }
        if (entity instanceof EntitySpectralArrow) {
            damage += 4.0f;
        }
        return super.func_70097_a(source, Math.min(damage, EntityAttributes.BASE_DEFENSE_2));
    }

    public void func_70653_a(Entity entityIn, float strength, double xRatio, double zRatio) {
        super.knockBack(xRatio, zRatio, 0.25);
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        if (super.func_70652_k(entityIn)) {
            entityIn.func_70015_d(6);
        }
        return true;
    }

    public void func_70636_d() {
        float f;
        if (!this.field_70170_p.field_72995_K && this.func_184218_aH()) {
            this.func_184210_p();
        }
        if (this.field_70170_p.func_72935_r() && !this.field_70170_p.field_72995_K && (f = this.func_70013_c()) > 0.5f && this.field_70146_Z.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && this.field_70170_p.func_175678_i(this.func_180425_c())) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)11);
            this.func_70097_a(DamageSource.field_76380_i, EntityAttributes.MAX_HEALTH_2 * 0.25f);
        }
        for (int var2 = 0; var2 < 2; ++var2) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
        }
        super.func_70636_d();
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
        super.func_70091_d(type, x, y, z);
        this.func_145775_I();
    }

    public void func_70071_h_() {
        this.field_70145_X = true;
        super.func_70071_h_();
        this.field_70145_X = false;
        this.func_189654_d(true);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VEX_FLAGS, (Object)0);
    }

    public static void registerFixesVex(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, EntityGaiaBanshee.class);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("BoundX")) {
            this.boundOrigin = new BlockPos(compound.func_74762_e("BoundX"), compound.func_74762_e("BoundY"), compound.func_74762_e("BoundZ"));
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.boundOrigin != null) {
            compound.func_74768_a("BoundX", this.boundOrigin.func_177958_n());
            compound.func_74768_a("BoundY", this.boundOrigin.func_177956_o());
            compound.func_74768_a("BoundZ", this.boundOrigin.func_177952_p());
        }
    }

    @Nullable
    public BlockPos getBoundOrigin() {
        return this.boundOrigin;
    }

    public void setBoundOrigin(@Nullable BlockPos boundOriginIn) {
        this.boundOrigin = boundOriginIn;
    }

    private boolean getVexFlag(int mask) {
        byte i = (Byte)this.field_70180_af.func_187225_a(VEX_FLAGS);
        return (i & mask) != 0;
    }

    private void setVexFlag(int mask, boolean value) {
        int i = ((Byte)this.field_70180_af.func_187225_a(VEX_FLAGS)).byteValue();
        i = value ? (i |= mask) : (i &= ~mask);
        this.field_70180_af.func_187227_b(VEX_FLAGS, (Object)((byte)(i & 0xFF)));
    }

    public boolean isCharging() {
        return this.getVexFlag(1);
    }

    public void setCharging(boolean charging) {
        this.setVexFlag(1, charging);
    }

    protected SoundEvent func_184639_G() {
        return GaiaSounds.BANSHEE_SAY;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return GaiaSounds.BANSHEE_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return GaiaSounds.BANSHEE_DEATH;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(GaiaSounds.NONE, 1.0f, 1.0f);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return GaiaLootTables.ENTITIES_GAIA_BANSHEE;
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        if (wasRecentlyHit) {
            int drop = this.field_70146_Z.nextInt(3 + lootingModifier);
            for (int i = 0; i < drop; ++i) {
                this.func_145779_a(GaiaItems.MISC_SOUL_FIRE, 1);
            }
            int dropNugget = this.field_70146_Z.nextInt(3) + 1;
            for (int i = 0; i < dropNugget; ++i) {
                this.func_145779_a(Items.field_151074_bl, 1);
            }
            if (GaiaConfig.OPTIONS.additionalOre) {
                int dropNuggetAlt = this.field_70146_Z.nextInt(3) + 1;
                for (int i = 0; i < dropNuggetAlt; ++i) {
                    ItemShard.dropNugget((Entity)this, 5);
                }
            }
            if (this.field_70146_Z.nextInt(40) == 0) {
                switch (this.field_70146_Z.nextInt(2)) {
                    case 0: {
                        this.func_145779_a(GaiaItems.BOX_GOLD, 1);
                    }
                    case 1: {
                        this.func_145779_a(GaiaItems.BAG_BOOK, 1);
                    }
                }
            }
            if (this.field_70146_Z.nextInt(100) == 0) {
                this.func_145779_a(GaiaItems.WEAPON_BOOK_NIGHTMARE, 1);
            }
        }
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    public int func_70641_bl() {
        return 1;
    }

    @Override
    public boolean func_70601_bi() {
        return this.field_70163_u > (!GaiaConfig.SPAWN.disableYRestriction ? 60.0 : 0.0) && super.func_70601_bi();
    }

    class AIMoveRandom
    extends EntityAIBase {
        public AIMoveRandom() {
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            return !EntityGaiaBanshee.this.func_70605_aq().func_75640_a() && EntityGaiaBanshee.this.field_70146_Z.nextInt(7) == 0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75246_d() {
            BlockPos blockpos = EntityGaiaBanshee.this.getBoundOrigin();
            if (blockpos == null) {
                blockpos = new BlockPos((Entity)EntityGaiaBanshee.this);
            }
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos1 = blockpos.func_177982_a(EntityGaiaBanshee.this.field_70146_Z.nextInt(15) - 7, EntityGaiaBanshee.this.field_70146_Z.nextInt(11) - 5, EntityGaiaBanshee.this.field_70146_Z.nextInt(15) - 7);
                if (!EntityGaiaBanshee.this.field_70170_p.func_175623_d(blockpos1)) continue;
                EntityGaiaBanshee.this.field_70765_h.func_75642_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 0.25);
                if (EntityGaiaBanshee.this.func_70638_az() != null) break;
                EntityGaiaBanshee.this.func_70671_ap().func_75650_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }

    class AIMoveControl
    extends EntityMoveHelper {
        public AIMoveControl(EntityGaiaBanshee vex) {
            super((EntityLiving)vex);
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                double d0 = this.field_75646_b - EntityGaiaBanshee.this.field_70165_t;
                double d1 = this.field_75647_c - EntityGaiaBanshee.this.field_70163_u;
                double d2 = this.field_75644_d - EntityGaiaBanshee.this.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if ((d3 = (double)MathHelper.func_76133_a((double)d3)) < EntityGaiaBanshee.this.func_174813_aQ().func_72320_b()) {
                    this.field_188491_h = EntityMoveHelper.Action.WAIT;
                    EntityGaiaBanshee.this.field_70159_w *= 0.5;
                    EntityGaiaBanshee.this.field_70181_x *= 0.5;
                    EntityGaiaBanshee.this.field_70179_y *= 0.5;
                } else {
                    EntityGaiaBanshee.this.field_70159_w += d0 / d3 * 0.05 * this.field_75645_e;
                    EntityGaiaBanshee.this.field_70181_x += d1 / d3 * 0.05 * this.field_75645_e;
                    EntityGaiaBanshee.this.field_70179_y += d2 / d3 * 0.05 * this.field_75645_e;
                    if (EntityGaiaBanshee.this.func_70638_az() == null) {
                        EntityGaiaBanshee.this.field_70761_aq = EntityGaiaBanshee.this.field_70177_z = -((float)MathHelper.func_181159_b((double)EntityGaiaBanshee.this.field_70159_w, (double)EntityGaiaBanshee.this.field_70179_y)) * 57.295776f;
                    } else {
                        double d4 = EntityGaiaBanshee.this.func_70638_az().field_70165_t - EntityGaiaBanshee.this.field_70165_t;
                        double d5 = EntityGaiaBanshee.this.func_70638_az().field_70161_v - EntityGaiaBanshee.this.field_70161_v;
                        EntityGaiaBanshee.this.field_70761_aq = EntityGaiaBanshee.this.field_70177_z = -((float)MathHelper.func_181159_b((double)d4, (double)d5)) * 57.295776f;
                    }
                }
            }
        }
    }

    class AIChargeAttack
    extends EntityAIBase {
        public AIChargeAttack() {
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            if (EntityGaiaBanshee.this.func_70638_az() != null && !EntityGaiaBanshee.this.func_70605_aq().func_75640_a() && EntityGaiaBanshee.this.field_70146_Z.nextInt(7) == 0) {
                return EntityGaiaBanshee.this.func_70068_e((Entity)EntityGaiaBanshee.this.func_70638_az()) > 4.0;
            }
            return false;
        }

        public boolean func_75253_b() {
            return EntityGaiaBanshee.this.func_70605_aq().func_75640_a() && EntityGaiaBanshee.this.isCharging() && EntityGaiaBanshee.this.func_70638_az() != null && EntityGaiaBanshee.this.func_70638_az().func_70089_S();
        }

        public void func_75249_e() {
            EntityLivingBase entitylivingbase = EntityGaiaBanshee.this.func_70638_az();
            Vec3d vec3d = entitylivingbase.func_174824_e(1.0f);
            EntityGaiaBanshee.this.field_70765_h.func_75642_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 1.0);
            EntityGaiaBanshee.this.setCharging(true);
            EntityGaiaBanshee.this.func_184185_a(SoundEvents.field_191265_hd, 1.0f, 1.0f);
        }

        public void func_75251_c() {
            EntityGaiaBanshee.this.setCharging(false);
        }

        public void func_75246_d() {
            EntityLivingBase entitylivingbase = EntityGaiaBanshee.this.func_70638_az();
            if (EntityGaiaBanshee.this.func_174813_aQ().func_72326_a(entitylivingbase.func_174813_aQ())) {
                EntityGaiaBanshee.this.func_70652_k((Entity)entitylivingbase);
                EntityGaiaBanshee.this.setCharging(false);
            } else {
                double d0 = EntityGaiaBanshee.this.func_70068_e((Entity)entitylivingbase);
                if (d0 < 9.0) {
                    Vec3d vec3d = entitylivingbase.func_174824_e(1.0f);
                    EntityGaiaBanshee.this.field_70765_h.func_75642_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 1.0);
                }
            }
        }
    }
}

