/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity.monster;

import gaia.GaiaConfig;
import gaia.entity.EntityAttributes;
import gaia.entity.EntityMobAssistDay;
import gaia.entity.ai.EntityAIGaiaAttackRangedBow;
import gaia.entity.ai.EntityAIGaiaBreakDoor;
import gaia.entity.ai.EntityAIGaiaValidateTargetPlayer;
import gaia.entity.ai.GaiaIRangedAttackMob;
import gaia.entity.ai.Ranged;
import gaia.entity.monster.EntityGaiaOrc;
import gaia.init.GaiaItems;
import gaia.init.GaiaLootTables;
import gaia.init.GaiaSounds;
import gaia.items.ItemShard;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.PotionTypes;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityGaiaDwarf
extends EntityMobAssistDay
implements GaiaIRangedAttackMob {
    private static final String MOB_TYPE_TAG = "MobType";
    private EntityAIGaiaAttackRangedBow aiArrowAttack = new EntityAIGaiaAttackRangedBow(this, 1.275, 20, 15.0);
    private EntityAIAttackMelee aiAttackOnCollide = new EntityAIAttackMelee(this, 1.275, true){

        public void func_75251_c() {
            super.func_75251_c();
            EntityGaiaDwarf.this.func_184724_a(false);
        }

        public void func_75249_e() {
            super.func_75249_e();
            EntityGaiaDwarf.this.func_184724_a(true);
        }
    };
    private final EntityAIGaiaBreakDoor breakDoor = new EntityAIGaiaBreakDoor((EntityLiving)this);
    private static final DataParameter<Integer> SKIN = EntityDataManager.func_187226_a(EntityGaiaDwarf.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> SWINGING_ARMS = EntityDataManager.func_187226_a(EntityGaiaDwarf.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final ItemStack TIPPED_ARROW_CUSTOM = PotionUtils.func_185188_a((ItemStack)new ItemStack(Items.field_185167_i), (PotionType)PotionTypes.field_185246_r);
    private static final ItemStack TIPPED_ARROW_CUSTOM_2 = PotionUtils.func_185188_a((ItemStack)new ItemStack(Items.field_185167_i), (PotionType)PotionTypes.field_185226_I);
    public int classID;
    public boolean randomClass;
    private boolean canSpawnLevel3;
    private boolean spawned;
    private int spawnLevel3;
    private int spawnLevel3Chance;

    public EntityGaiaDwarf(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.5f, 1.5f);
        this.field_70728_aV = 20;
        this.field_70138_W = 1.0f;
        this.classID = 0;
        this.randomClass = true;
        if (!worldIn.field_72995_K) {
            this.setCombatTask();
        }
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIGaiaValidateTargetPlayer(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityGaiaOrc.class, true));
    }

    public void setBreakDoorsAItask(boolean enabled) {
        ((PathNavigateGround)this.func_70661_as()).func_179688_b(enabled);
        if (enabled) {
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.breakDoor);
        } else {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.breakDoor);
        }
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)EntityAttributes.MAX_HEALTH_2);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.275);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)EntityAttributes.ATTACK_DAMAGE_2);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(8.0);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float damage) {
        if (this.hasShield()) {
            Entity entity = source.func_76364_f();
            return !(entity instanceof EntityArrow) && super.func_70097_a(source, Math.min(damage, EntityAttributes.BASE_DEFENSE_2));
        }
        return super.func_70097_a(source, Math.min(damage, EntityAttributes.BASE_DEFENSE_2));
    }

    private boolean hasShield() {
        ItemStack itemstack = this.func_184582_a(EntityEquipmentSlot.OFFHAND);
        return itemstack.func_77973_b() == Items.field_185159_cQ || itemstack.func_77973_b() == GaiaItems.SHIELD_PROP;
    }

    public void func_70653_a(Entity entityIn, float strength, double xRatio, double zRatio) {
        super.knockBack(xRatio, zRatio, 0.25);
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        if (super.func_70652_k(entityIn)) {
            if (this.getMobType() == 1 && entityIn instanceof EntityLivingBase) {
                int byte0 = 0;
                if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL) {
                    byte0 = 10;
                } else if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                    byte0 = 20;
                }
                if (byte0 > 0) {
                    ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76421_d, byte0 * 20));
                    ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76419_f, byte0 * 20));
                }
            }
            return true;
        }
        return false;
    }

    public boolean func_175446_cd() {
        return false;
    }

    public void func_184201_a(EntityEquipmentSlot slotIn, ItemStack stack) {
        super.func_184201_a(slotIn, stack);
        if (!this.field_70170_p.field_72995_K && slotIn.func_188454_b() == 0) {
            this.setCombatTask();
        }
    }

    private void setCombatTask() {
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiAttackOnCollide);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiArrowAttack);
        ItemStack itemstack = this.func_184614_ca();
        if (itemstack.func_77973_b() == Items.field_151031_f) {
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.aiArrowAttack);
        } else {
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.aiAttackOnCollide);
        }
    }

    public int getTextureType() {
        return (Integer)this.field_70180_af.func_187225_a(SKIN);
    }

    private void setTextureType(int par1) {
        this.field_70180_af.func_187227_b(SKIN, (Object)par1);
    }

    public int getMobType() {
        return (Integer)this.field_70180_af.func_187225_a(SKIN);
    }

    private void setMobType(int par1) {
        this.field_70180_af.func_187227_b(SKIN, (Object)par1);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74774_a(MOB_TYPE_TAG, (byte)this.getMobType());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b(MOB_TYPE_TAG)) {
            byte b0 = compound.func_74771_c(MOB_TYPE_TAG);
            this.setMobType(b0);
        }
        this.setCombatTask();
    }

    @Override
    public boolean func_70686_a(Class<? extends EntityLivingBase> cls) {
        return super.func_70686_a(cls) && cls != EntityGaiaDwarf.class;
    }

    @Override
    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        if (!target.field_70128_L) {
            Ranged.rangedAttack(target, (EntityLivingBase)this, distanceFactor);
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SKIN, (Object)0);
        this.field_70180_af.func_187214_a(SWINGING_ARMS, (Object)false);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isSwingingArms() {
        return (Boolean)this.field_70180_af.func_187225_a(SWINGING_ARMS);
    }

    @Override
    public void func_184724_a(boolean swingingArms) {
        this.field_70180_af.func_187227_b(SWINGING_ARMS, (Object)swingingArms);
    }

    protected SoundEvent func_184639_G() {
        return GaiaSounds.DWARF_SAY;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return GaiaSounds.DWARF_HURT;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return GaiaSounds.DWARF_DEATH;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        switch (this.getMobType()) {
            case 0: {
                return GaiaLootTables.ENTITIES_GAIA_DWARF_MELEE;
            }
            case 1: {
                return GaiaLootTables.ENTITIES_GAIA_DWARF_RANGED;
            }
            case 2: {
                return GaiaLootTables.ENTITIES_GAIA_DWARF_MINER;
            }
        }
        return LootTableList.field_186419_a;
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        if (wasRecentlyHit) {
            int drop = this.field_70146_Z.nextInt(3 + lootingModifier);
            switch (this.getMobType()) {
                case 0: {
                    int i;
                    for (i = 0; i < drop; ++i) {
                        this.func_145779_a(GaiaItems.FOOD_MEAT, 1);
                    }
                    break;
                }
                case 1: {
                    int i;
                    for (i = 0; i < drop; ++i) {
                        this.func_145779_a(Items.field_151032_g, 1);
                    }
                    break;
                }
                case 2: {
                    int i;
                    for (i = 0; i < drop; ++i) {
                        this.func_145779_a(Items.field_191525_da, 1);
                    }
                    break;
                }
            }
            int dropNugget = this.field_70146_Z.nextInt(3) + 1;
            for (int i = 0; i < dropNugget; ++i) {
                this.func_145779_a(Items.field_151074_bl, 1);
            }
            if (GaiaConfig.OPTIONS.additionalOre) {
                int dropNuggetAlt = this.field_70146_Z.nextInt(3) + 1;
                for (int i = 0; i < dropNuggetAlt; ++i) {
                    ItemShard.dropNugget((Entity)this, 5);
                }
            }
            if (this.field_70146_Z.nextInt(10) == 0 && this.getMobType() == 2) {
                this.func_70099_a(new ItemStack(GaiaItems.BOX, 1, 0), 0.0f);
            }
            if (this.field_70146_Z.nextInt(40) == 0) {
                switch (this.field_70146_Z.nextInt(2)) {
                    case 0: {
                        this.func_145779_a(GaiaItems.BOX_GOLD, 1);
                    }
                    case 1: {
                        this.func_145779_a(GaiaItems.BAG_BOOK, 1);
                    }
                }
            }
            if (this.field_70146_Z.nextInt(100) == 0 && this.getMobType() == 1) {
                this.func_145779_a(GaiaItems.BAG_ARROW, 1);
            }
        }
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        IEntityLivingData ret = super.func_180482_a(difficulty, livingdata);
        if (this.randomClass) {
            if (this.field_70170_p.field_73012_v.nextInt(4) == 0) {
                this.mobClass(difficulty, 1);
            } else if (this.field_70170_p.field_73012_v.nextInt(4) == 0) {
                this.mobClass(difficulty, 2);
            } else {
                this.mobClass(difficulty, 0);
            }
        } else {
            this.mobClass(difficulty, this.classID);
        }
        this.setCombatTask();
        this.setBreakDoorsAItask(true);
        return ret;
    }

    public void mobClass(DifficultyInstance difficulty, int id) {
        switch (id) {
            case 0: {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(GaiaItems.WEAPON_PROP_AXE_STONE));
                this.func_180483_b(difficulty);
                if (this.field_70170_p.field_73012_v.nextInt(2) != 0) break;
                ItemStack shield = new ItemStack(GaiaItems.SHIELD_PROP, 1, 1);
                this.func_184201_a(EntityEquipmentSlot.OFFHAND, shield);
                this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.25);
                break;
            }
            case 1: {
                ItemStack bowCustom = new ItemStack((Item)Items.field_151031_f);
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, bowCustom);
                bowCustom.func_77966_a(Enchantments.field_185310_v, 1);
                if (this.field_70170_p.field_73012_v.nextInt(2) != 0) break;
                if (this.field_70170_p.field_73012_v.nextInt(2) == 0) {
                    this.func_184201_a(EntityEquipmentSlot.OFFHAND, TIPPED_ARROW_CUSTOM);
                    break;
                }
                this.func_184201_a(EntityEquipmentSlot.OFFHAND, TIPPED_ARROW_CUSTOM_2);
                break;
            }
            case 2: {
                this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(Items.field_151050_s));
                this.func_180483_b(difficulty);
            }
        }
        this.setMobType(id);
        this.setTextureType(id);
    }

    public int func_70641_bl() {
        return 1;
    }

    @Override
    public boolean func_70601_bi() {
        return this.field_70163_u > (!GaiaConfig.SPAWN.disableYRestriction ? 60.0 : 0.0) && super.func_70601_bi();
    }
}

