/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity.monster;

import gaia.GaiaConfig;
import gaia.entity.EntityAttributes;
import gaia.entity.EntityMobHostileBase;
import gaia.entity.ai.EntityAIGaiaLeapAtTarget;
import gaia.init.GaiaBlocks;
import gaia.init.GaiaItems;
import gaia.init.GaiaLootTables;
import gaia.init.GaiaSounds;
import gaia.items.ItemShard;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityGaiaHarpy
extends EntityMobHostileBase {
    private static final String MOB_TYPE_TAG = "MobType";
    private static final String IS_CHILD_TAG = "IsBaby";
    private static final DataParameter<Integer> SKIN = EntityDataManager.func_187226_a(EntityGaiaHarpy.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> IS_CHILD = EntityDataManager.func_187226_a(EntityGaiaHarpy.class, (DataSerializer)DataSerializers.field_187198_h);
    private EntityAIGaiaLeapAtTarget aiGaiaLeapAtTarget = new EntityAIGaiaLeapAtTarget((EntityLiving)this, 0.4f);
    private EntityAIAttackMelee aiMeleeAttack = new AILeapAttack(this);
    private EntityAIAvoidEntity<EntityPlayer> aiAvoid = new EntityAIAvoidEntity((EntityCreature)this, EntityPlayer.class, 20.0f, 1.25, 1.3);
    private int switchHealth;

    public EntityGaiaHarpy(World worldIn) {
        super(worldIn);
        this.field_70728_aV = 10;
        this.field_70138_W = 1.0f;
        this.switchHealth = 0;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)EntityAttributes.MAX_HEALTH_1);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)EntityAttributes.ATTACK_DAMAGE_1);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(4.0);
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        return super.func_70097_a(source, Math.min(damage, EntityAttributes.BASE_DEFENSE_1));
    }

    public void func_70653_a(Entity entityIn, float strength, double xRatio, double zRatio) {
        super.knockBack(xRatio, zRatio, 0.3);
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        if (super.func_70652_k(entityIn)) {
            if (entityIn instanceof EntityLivingBase) {
                int byte0 = 0;
                if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL) {
                    byte0 = 5;
                } else if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                    byte0 = 10;
                }
                if (byte0 > 0) {
                    ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76421_d, byte0 * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    public boolean func_175446_cd() {
        return false;
    }

    public void func_70636_d() {
        if (!this.field_70122_E && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.8;
        }
        if (this.func_110143_aJ() < EntityAttributes.MAX_HEALTH_1 * 0.25f && this.switchHealth == 0) {
            switch (this.field_70146_Z.nextInt(2)) {
                case 0: {
                    this.setAI((byte)1);
                    this.setEquipment((byte)1);
                    this.switchHealth = 1;
                    break;
                }
                case 1: {
                    this.switchHealth = 2;
                }
            }
        }
        if (this.func_110143_aJ() > EntityAttributes.MAX_HEALTH_1 * 0.25f && this.switchHealth == 1) {
            this.setAI((byte)0);
            this.setEquipment((byte)0);
            this.switchHealth = 0;
        }
        super.func_70636_d();
    }

    private void setAI(byte id) {
        if (id == 0) {
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiGaiaLeapAtTarget);
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.aiMeleeAttack);
            this.field_70714_bg.func_85156_a(this.aiAvoid);
        }
        if (id == 1) {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiGaiaLeapAtTarget);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiMeleeAttack);
            this.field_70714_bg.func_75776_a(2, this.aiAvoid);
        }
    }

    private void setEquipment(byte id) {
        if (id == 0) {
            this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(Items.field_151110_aK));
        }
        if (id == 1) {
            this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(Items.field_151008_G));
        }
        if (id == 2) {
            this.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(Items.field_151110_aK));
        }
    }

    private void setCombatTask() {
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiMeleeAttack);
        this.field_70714_bg.func_85156_a(this.aiAvoid);
        this.setAI((byte)0);
    }

    protected SoundEvent func_184639_G() {
        return GaiaSounds.HARPY_SAY;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return GaiaSounds.HARPY_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return GaiaSounds.HARPY_DEATH;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187538_aa, 0.15f, 1.0f);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return GaiaLootTables.ENTITIES_GAIA_HARPY;
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        if (wasRecentlyHit) {
            ItemStack itemstack;
            if (this.field_70146_Z.nextInt(2) == 0 || this.field_70146_Z.nextInt(1 + lootingModifier) > 0) {
                this.func_145779_a(Items.field_151008_G, 1);
            }
            int dropNugget = this.field_70146_Z.nextInt(3) + 1;
            for (int i = 0; i < dropNugget; ++i) {
                this.func_145779_a(Items.field_191525_da, 1);
            }
            if (GaiaConfig.OPTIONS.additionalOre) {
                int dropNuggetAlt = this.field_70146_Z.nextInt(3) + 1;
                for (int i = 0; i < dropNuggetAlt; ++i) {
                    ItemShard.dropNugget((Entity)this, 4);
                }
            }
            if (this.field_70146_Z.nextInt(40) == 0) {
                this.func_145779_a(GaiaItems.BOX_IRON, 1);
            }
            if (((itemstack = this.func_184582_a(EntityEquipmentSlot.CHEST)).func_190926_b() || itemstack.func_77973_b() != Items.field_151110_aK) && this.field_70146_Z.nextInt(100) == 0) {
                this.func_145779_a(Item.func_150898_a((Block)GaiaBlocks.DECO_NEST_HARPY), 1);
            }
        }
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        IEntityLivingData ret = super.func_180482_a(difficulty, livingdata);
        if (!this.field_70170_p.field_72995_K) {
            int i = MathHelper.func_76128_c((double)this.field_70165_t);
            int j = MathHelper.func_76128_c((double)this.field_70163_u);
            int k = MathHelper.func_76128_c((double)this.field_70161_v);
            BlockPos blockPos = new BlockPos(i, 0, k);
            BlockPos blockPos2 = new BlockPos(i, j, k);
            if (this.field_70170_p.func_180494_b(blockPos).func_180626_a(blockPos2) > 1.0f) {
                this.setTextureType(2);
            } else if (this.field_70170_p.field_73012_v.nextInt(4) == 0) {
                this.setTextureType(1);
            }
        }
        this.setChild(true, 10);
        if (!this.func_70631_g_()) {
            ItemStack weaponCustom = new ItemStack(GaiaItems.WEAPON_PROP_ENCHANTED, 1);
            weaponCustom.func_77966_a(Enchantments.field_180313_o, 2);
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, weaponCustom);
        }
        this.setCombatTask();
        return ret;
    }

    private void setChild(boolean isRandom, int chance) {
        if (isRandom) {
            if (this.field_70170_p.field_73012_v.nextInt(chance) == 0) {
                this.setChild(true);
            }
        } else {
            this.setChild(true);
        }
    }

    public float func_70047_e() {
        ItemStack itemstack = this.func_184582_a(EntityEquipmentSlot.CHEST);
        float f = itemstack.func_190926_b() || itemstack.func_77973_b() != Items.field_151110_aK ? 1.74f : 0.93f;
        return f;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SKIN, (Object)0);
        this.field_70180_af.func_187214_a(IS_CHILD, (Object)false);
    }

    public int getTextureType() {
        return (Integer)this.field_70180_af.func_187225_a(SKIN);
    }

    private void setTextureType(int par1) {
        this.field_70180_af.func_187227_b(SKIN, (Object)par1);
    }

    public boolean func_70631_g_() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_CHILD);
    }

    public void setChild(boolean isChild) {
        this.func_184212_Q().func_187227_b(IS_CHILD, (Object)isChild);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74774_a(MOB_TYPE_TAG, (byte)this.getTextureType());
        compound.func_74757_a(IS_CHILD_TAG, this.func_70631_g_());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b(MOB_TYPE_TAG)) {
            byte by = compound.func_74771_c(MOB_TYPE_TAG);
            this.setTextureType(by);
        }
        if (compound.func_74764_b(IS_CHILD_TAG)) {
            boolean bl = compound.func_74767_n(IS_CHILD_TAG);
            this.setChild(bl);
        }
        this.setCombatTask();
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public int func_70641_bl() {
        return 2;
    }

    @Override
    public boolean func_70601_bi() {
        return this.field_70163_u > (!GaiaConfig.SPAWN.disableYRestriction ? 60.0 : 0.0) && super.func_70601_bi();
    }

    static class AILeapAttack
    extends EntityAIAttackMelee {
        AILeapAttack(EntityGaiaHarpy entity) {
            super((EntityCreature)entity, 1.25, true);
        }

        protected double func_179512_a(EntityLivingBase attackTarget) {
            return 4.0 + (double)attackTarget.field_70130_N;
        }
    }
}

