/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity.monster;

import gaia.GaiaConfig;
import gaia.entity.EntityAttributes;
import gaia.entity.EntityMobHostileDay;
import gaia.init.GaiaBlocks;
import gaia.init.GaiaItems;
import gaia.init.GaiaLootTables;
import gaia.init.GaiaSounds;
import gaia.items.ItemShard;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityGaiaMandragora
extends EntityMobHostileDay {
    private static final String IS_CHILD_TAG = "IsBaby";
    private static final String IS_SCREAMING_TAG = "IsScreaming";
    private static final DataParameter<Boolean> IS_CHILD = EntityDataManager.func_187226_a(EntityGaiaMandragora.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_SCREAMING = EntityDataManager.func_187226_a(EntityGaiaMandragora.class, (DataSerializer)DataSerializers.field_187198_h);
    private int shovelAttack;
    private byte inWaterTimer;

    public EntityGaiaMandragora(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.75f, 1.0f);
        this.field_70728_aV = 10;
        this.field_70138_W = 1.0f;
        this.shovelAttack = 0;
        this.inWaterTimer = 0;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.15, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)EntityAttributes.MAX_HEALTH_1);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)EntityAttributes.ATTACK_DAMAGE_1);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        EntityPlayer player;
        ItemStack itemstack;
        float input = Math.min(damage, EntityAttributes.BASE_DEFENSE_1);
        Entity entity = source.func_76346_g();
        if (entity instanceof EntityPlayer && (itemstack = (player = (EntityPlayer)entity).func_184586_b(this.func_184600_cs())).func_77973_b() instanceof ItemSpade) {
            input *= 1.5f;
            ++this.shovelAttack;
        }
        return super.func_70097_a(source, input);
    }

    public void func_70653_a(Entity entityIn, float strength, double xRatio, double zRatio) {
        super.knockBack(xRatio, zRatio, 0.3);
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        if (super.func_70652_k(entityIn)) {
            if (entityIn instanceof EntityLivingBase) {
                int byte0 = 0;
                int byte1 = 0;
                if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL) {
                    byte0 = 20;
                    byte1 = 10;
                } else if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                    byte0 = 30;
                    byte1 = 20;
                }
                if (byte0 > 0) {
                    ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76421_d, byte0 * 20, 3));
                    ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76439_r, byte0 * 20, 0));
                    ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76431_k, byte1 * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    public boolean func_175446_cd() {
        return false;
    }

    public void func_70636_d() {
        int k;
        int j;
        int i;
        IBlockState iblockstate;
        if (this.isScreaming()) {
            this.beaconDebuff(2.0, MobEffects.field_76431_k, 100, 0);
        }
        if (!this.field_70170_p.field_72995_K && this.func_70026_G()) {
            if (this.inWaterTimer <= 100) {
                this.inWaterTimer = (byte)(this.inWaterTimer + 1);
            } else {
                this.field_70170_p.func_72960_a((Entity)this, (byte)8);
                this.func_70691_i(EntityAttributes.MAX_HEALTH_1 * 0.1f);
                this.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 100, 0));
                this.inWaterTimer = 0;
            }
        }
        if (this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y > 2.500000277905201E-7 && this.field_70146_Z.nextInt(5) == 0 && (iblockstate = this.field_70170_p.func_180495_p(new BlockPos(i = MathHelper.func_76128_c((double)this.field_70165_t), j = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f)), k = MathHelper.func_76128_c((double)this.field_70161_v)))).func_185904_a() != Material.field_151579_a) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.func_174813_aQ().field_72338_b + 0.1, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 4.0 * (this.field_70146_Z.nextDouble() - 0.5), 0.5, (this.field_70146_Z.nextDouble() - 0.5) * 4.0, new int[]{Block.func_176210_f((IBlockState)iblockstate)});
        }
        if (this.func_70027_ad()) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 100, 0));
            this.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 100, 0));
        }
        super.func_70636_d();
    }

    protected SoundEvent func_184639_G() {
        return GaiaSounds.MANDRAGORA_SAY;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return GaiaSounds.MANDRAGORA_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return GaiaSounds.MANDRAGORA_DEATH;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return GaiaLootTables.ENTITIES_GAIA_MANDRAGORA;
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        if (wasRecentlyHit) {
            if (this.field_70146_Z.nextInt(2) == 0 || this.field_70146_Z.nextInt(1 + lootingModifier) > 0) {
                this.func_145779_a(GaiaItems.FOOD_ROOT, 1);
            }
            if (this.shovelAttack >= 4) {
                if (this.field_70146_Z.nextInt(8) == 0) {
                    this.func_145779_a(GaiaItems.FOOD_MANDRAKE, 1);
                }
            } else if (this.field_70146_Z.nextInt(16) == 0) {
                this.func_145779_a(GaiaItems.FOOD_MANDRAKE, 1);
            }
            int dropNugget = this.field_70146_Z.nextInt(3) + 1;
            for (int i = 0; i < dropNugget; ++i) {
                this.func_145779_a(Items.field_191525_da, 1);
            }
            if (GaiaConfig.OPTIONS.additionalOre) {
                int dropNuggetAlt = this.field_70146_Z.nextInt(3) + 1;
                for (int i = 0; i < dropNuggetAlt; ++i) {
                    ItemShard.dropNugget((Entity)this, 4);
                }
            }
            if (this.field_70146_Z.nextInt(40) == 0) {
                this.func_145779_a(GaiaItems.BOX_IRON, 1);
            }
            if (this.field_70146_Z.nextInt(100) == 0) {
                this.func_145779_a(Item.func_150898_a((Block)GaiaBlocks.DECO_GARDEN_GNOME), 1);
            }
        }
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        IEntityLivingData ret = super.func_180482_a(difficulty, livingdata);
        this.setChild(true);
        this.setScreaming(true);
        return ret;
    }

    public float func_70047_e() {
        ItemStack itemstack = this.func_184582_a(EntityEquipmentSlot.CHEST);
        float f = itemstack.func_190926_b() || itemstack.func_77973_b() != Items.field_151110_aK ? 1.74f : 0.93f;
        return f;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_CHILD, (Object)true);
        this.field_70180_af.func_187214_a(IS_SCREAMING, (Object)true);
    }

    public boolean func_70631_g_() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_CHILD);
    }

    public void setChild(boolean isChild) {
        this.func_184212_Q().func_187227_b(IS_CHILD, (Object)isChild);
    }

    public boolean isScreaming() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_SCREAMING);
    }

    public void setScreaming(boolean isScreaming) {
        this.func_184212_Q().func_187227_b(IS_SCREAMING, (Object)isScreaming);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a(IS_CHILD_TAG, this.func_70631_g_());
        compound.func_74757_a(IS_SCREAMING_TAG, this.isScreaming());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b(IS_CHILD_TAG)) {
            boolean b0 = compound.func_74767_n(IS_CHILD_TAG);
            this.setChild(b0);
        }
        if (compound.func_74764_b(IS_SCREAMING_TAG)) {
            boolean b1 = compound.func_74767_n(IS_SCREAMING_TAG);
            this.setScreaming(b1);
        }
    }

    public boolean func_70687_e(PotionEffect potioneffectIn) {
        return potioneffectIn.func_188419_a() == MobEffects.field_76431_k ? false : super.func_70687_e(potioneffectIn);
    }

    @Override
    public boolean func_70601_bi() {
        return this.field_70163_u > (!GaiaConfig.SPAWN.disableYRestriction ? 60.0 : 0.0) && super.func_70601_bi();
    }
}

