/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity.monster;

import gaia.GaiaConfig;
import gaia.entity.EntityAttributes;
import gaia.entity.EntityMobHostileDay;
import gaia.entity.monster.EntityGaiaSporeling;
import gaia.init.GaiaItems;
import gaia.init.GaiaLootTables;
import gaia.init.GaiaSounds;
import gaia.items.ItemShard;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityGaiaMatango
extends EntityMobHostileDay {
    private static final Item[] matangoDrops = new Item[]{Item.func_150898_a((Block)Blocks.field_150337_Q), Item.func_150898_a((Block)Blocks.field_150338_P)};
    private int spawnLimit;
    private int spawnTime;
    private boolean canSpawn;

    public EntityGaiaMatango(World worldIn) {
        super(worldIn);
        this.field_70728_aV = 10;
        this.field_70138_W = 1.0f;
        this.spawnLimit = 0;
        this.spawnTime = 0;
        this.canSpawn = true;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.15, true));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)EntityAttributes.MAX_HEALTH_1);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)EntityAttributes.ATTACK_DAMAGE_1);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        EntityPlayer player;
        ItemStack itemstack;
        float input = Math.min(damage, EntityAttributes.BASE_DEFENSE_1);
        Entity entity = source.func_76346_g();
        if (entity instanceof EntityPlayer && (itemstack = (player = (EntityPlayer)entity).func_184586_b(this.func_184600_cs())).func_77973_b() instanceof ItemAxe) {
            input *= 1.5f;
        }
        return super.func_70097_a(source, input);
    }

    public void func_70653_a(Entity entityIn, float strength, double xRatio, double zRatio) {
        super.knockBack(xRatio, zRatio, 0.3);
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        if (super.func_70652_k(entityIn)) {
            if (entityIn instanceof EntityLivingBase) {
                int byte0 = 0;
                if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL) {
                    byte0 = 10;
                } else if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                    byte0 = 20;
                }
                if (byte0 > 0) {
                    ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76431_k, byte0 * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    public boolean func_175446_cd() {
        return false;
    }

    public void func_70636_d() {
        int k;
        int j;
        int i;
        IBlockState iblockstate;
        this.beaconMonster();
        if (this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y > 2.500000277905201E-7 && this.field_70146_Z.nextInt(5) == 0 && (iblockstate = this.field_70170_p.func_180495_p(new BlockPos(i = MathHelper.func_76128_c((double)this.field_70165_t), j = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f)), k = MathHelper.func_76128_c((double)this.field_70161_v)))).func_185904_a() != Material.field_151579_a) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.func_174813_aQ().field_72338_b + 0.1, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 4.0 * (this.field_70146_Z.nextDouble() - 0.5), 0.5, (this.field_70146_Z.nextDouble() - 0.5) * 4.0, new int[]{Block.func_176210_f((IBlockState)iblockstate)});
        }
        if (this.func_110143_aJ() < EntityAttributes.MAX_HEALTH_1 * 0.9f && this.func_110143_aJ() > EntityAttributes.MAX_HEALTH_1 * 0.1f && this.canSpawn) {
            if (this.spawnLimit < 5) {
                if (this.spawnTime >= 0 && this.spawnTime <= 140) {
                    ++this.spawnTime;
                } else {
                    if (!this.field_70170_p.field_72995_K) {
                        this.setSpawn((byte)0);
                    }
                    this.func_70691_i(EntityAttributes.MAX_HEALTH_1 * 0.2f);
                    ++this.spawnLimit;
                    this.spawnTime = 0;
                }
            } else {
                this.canSpawn = false;
            }
        }
        if (this.func_70027_ad()) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 100, 0));
            this.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 100, 0));
        }
        super.func_70636_d();
    }

    private void setSpawn(byte id) {
        BlockPos blockpos = new BlockPos((Entity)this).func_177982_a(-1 + this.field_70146_Z.nextInt(3), 1, -1 + this.field_70146_Z.nextInt(3));
        if (id == 0) {
            EntityGaiaSporeling entitySpawn = new EntityGaiaSporeling(this.field_70170_p);
            entitySpawn.func_174828_a(blockpos, 0.0f, 0.0f);
            entitySpawn.func_180482_a(this.field_70170_p.func_175649_E(blockpos), null);
            this.field_70170_p.func_72838_d((Entity)entitySpawn);
        }
        this.field_70170_p.func_72960_a((Entity)this, (byte)8);
        this.field_70170_p.func_72960_a((Entity)this, (byte)12);
    }

    private void beaconMonster() {
        if (!this.field_70170_p.field_72995_K) {
            AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t + 1.0, this.field_70163_u + 1.0, this.field_70161_v + 1.0).func_186662_g(2.0);
            List moblist = this.field_70170_p.func_72872_a(EntityLivingBase.class, axisalignedbb);
            for (EntityLivingBase mob : moblist) {
                if (!(mob instanceof EntityGaiaSporeling)) continue;
                mob.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 300, 1, true, true));
            }
        }
    }

    public void func_70645_a(DamageSource cause) {
        if (!this.field_70170_p.field_72995_K) {
            this.spawnLingeringCloud((EntityLivingBase)this, MobEffects.field_76431_k, 200, 0);
        }
        super.func_70645_a(cause);
    }

    protected SoundEvent func_184639_G() {
        return GaiaSounds.MATANGO_SAY;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return GaiaSounds.MATANGO_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return GaiaSounds.MATANGO_DEATH;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return GaiaLootTables.ENTITIES_GAIA_MATANGO;
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        if (wasRecentlyHit) {
            for (int i = 0; i < 1; ++i) {
                Item dropList = matangoDrops[this.field_70146_Z.nextInt(matangoDrops.length)];
                for (int j = 0; j < 1; ++j) {
                    this.func_145779_a(dropList, 1);
                }
            }
            int dropNugget = this.field_70146_Z.nextInt(3) + 1;
            for (int i = 0; i < dropNugget; ++i) {
                this.func_145779_a(Items.field_191525_da, 1);
            }
            if (GaiaConfig.OPTIONS.additionalOre) {
                int dropNuggetAlt = this.field_70146_Z.nextInt(3) + 1;
                for (int i = 0; i < dropNuggetAlt; ++i) {
                    ItemShard.dropNugget((Entity)this, 4);
                }
            }
            if (this.field_70146_Z.nextInt(40) == 0) {
                this.func_145779_a(GaiaItems.BOX_IRON, 1);
            }
        }
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        IEntityLivingData ret = super.func_180482_a(difficulty, livingdata);
        ItemStack weaponCustom = new ItemStack(GaiaItems.WEAPON_PROP_ENCHANTED, 1);
        weaponCustom.func_77966_a(Enchantments.field_180313_o, 1);
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, weaponCustom);
        return ret;
    }

    public boolean func_70687_e(PotionEffect potioneffectIn) {
        return potioneffectIn.func_188419_a() == MobEffects.field_76436_u ? false : super.func_70687_e(potioneffectIn);
    }

    public int func_70641_bl() {
        return 2;
    }

    @Override
    public boolean func_70601_bi() {
        return this.field_70163_u > (!GaiaConfig.SPAWN.disableYRestriction ? 60.0 : 0.0) && super.func_70601_bi();
    }
}

