/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity.monster;

import gaia.GaiaConfig;
import gaia.entity.EntityAttributes;
import gaia.entity.EntityMobHostileBase;
import gaia.entity.projectile.EntityGaiaProjectileSmallFireball;
import gaia.init.GaiaBlocks;
import gaia.init.GaiaItems;
import gaia.init.GaiaLootTables;
import gaia.init.GaiaSounds;
import gaia.items.ItemShard;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public class EntityGaiaNineTails
extends EntityMobHostileBase
implements IRangedAttackMob {
    private static final DataParameter<Integer> WEAPON_TYPE = EntityDataManager.func_187226_a(EntityGaiaNineTails.class, (DataSerializer)DataSerializers.field_187192_b);
    private EntityAIAttackRanged aiArrowAttack = new EntityAIAttackRanged((IRangedAttackMob)this, 1.275, 20, 60, 15.0f);
    private EntityAIAttackMelee aiAttackOnCollide = new EntityAIAttackMelee((EntityCreature)this, 1.275, true);
    private int switchHealth;
    private boolean animationPlay;
    private int animationTimer;

    public EntityGaiaNineTails(World worldIn) {
        super(worldIn);
        this.field_70728_aV = 20;
        this.field_70138_W = 1.0f;
        this.switchHealth = 0;
        this.field_70178_ae = true;
        this.animationPlay = false;
        this.animationTimer = 0;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)EntityAttributes.MAX_HEALTH_2);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.275);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)EntityAttributes.ATTACK_DAMAGE_2);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(8.0);
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        return super.func_70097_a(source, Math.min(damage, EntityAttributes.BASE_DEFENSE_2));
    }

    public void func_70653_a(Entity entityIn, float strength, double xRatio, double zRatio) {
        super.knockBack(xRatio, zRatio, 0.25);
    }

    @Override
    public void func_82196_d(EntityLivingBase living, float par2) {
        this.func_184185_a(SoundEvents.field_187606_E, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        double d0 = living.field_70165_t - this.field_70165_t;
        double d1 = living.func_174813_aQ().field_72338_b + (double)living.field_70131_O / 2.0 - (this.field_70163_u + (double)this.field_70131_O / 2.0);
        double d2 = living.field_70161_v - this.field_70161_v;
        double f1 = (double)MathHelper.func_76129_c((float)par2) * 0.5;
        for (int var10 = 0; var10 < 3; ++var10) {
            EntityGaiaProjectileSmallFireball var11 = new EntityGaiaProjectileSmallFireball(this.field_70170_p, (EntityLivingBase)this, d0 + this.field_70146_Z.nextGaussian() * f1, d1, d2 + this.field_70146_Z.nextGaussian() * f1);
            var11.field_70163_u = this.field_70163_u + (double)this.field_70131_O / 2.0 + 0.5;
            this.field_70170_p.func_72838_d((Entity)var11);
        }
        this.setEquipment((byte)1);
        this.animationPlay = true;
        this.animationTimer = 0;
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        if (super.func_70652_k(entityIn)) {
            entityIn.func_70015_d(6);
        }
        return true;
    }

    public boolean func_175446_cd() {
        return false;
    }

    public void func_70636_d() {
        if (this.func_110143_aJ() < EntityAttributes.MAX_HEALTH_2 * 0.75f && this.switchHealth == 0) {
            if (this.getWeaponType() == 0) {
                if (this.field_70146_Z.nextInt(4) == 0) {
                    this.setWeaponType(2);
                } else {
                    this.setWeaponType(1);
                }
            }
            this.setEquipmentEnchanted(this.getWeaponType());
            this.setAI((byte)1);
            this.switchHealth = 1;
        }
        if (this.func_110143_aJ() > EntityAttributes.MAX_HEALTH_2 * 0.75f && this.switchHealth == 1) {
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
            this.setAI((byte)0);
            this.switchHealth = 0;
        }
        if (this.animationPlay) {
            if (this.animationTimer != 20) {
                ++this.animationTimer;
            } else {
                this.setEquipment((byte)0);
                this.animationPlay = false;
            }
        }
        super.func_70636_d();
    }

    private void setAI(byte id) {
        if (id == 0) {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiAttackOnCollide);
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiArrowAttack);
            this.setEquipment((byte)0);
            this.animationPlay = false;
            this.animationTimer = 0;
        }
        if (id == 1) {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiArrowAttack);
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiAttackOnCollide);
        }
    }

    private void setEquipment(byte id) {
        if (id == 0) {
            this.func_184201_a(EntityEquipmentSlot.HEAD, ItemStack.field_190927_a);
        }
        if (id == 1) {
            this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(Items.field_151032_g));
        }
    }

    private void setCombatTask() {
        ItemStack itemstack = this.func_184614_ca();
        if (itemstack.func_190926_b()) {
            this.setAI((byte)0);
        } else {
            this.setAI((byte)1);
        }
    }

    protected SoundEvent func_184639_G() {
        return GaiaSounds.NINETAILS_SAY;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return GaiaSounds.NINETAILS_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return GaiaSounds.NINETAILS_DEATH;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return GaiaLootTables.ENTITIES_GAIA_NINETAILS;
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        if (wasRecentlyHit) {
            int drop = this.field_70146_Z.nextInt(3 + lootingModifier);
            for (int i = 0; i < drop; ++i) {
                this.func_145779_a(GaiaItems.MISC_SOUL_FIRE, 1);
            }
            int dropNugget = this.field_70146_Z.nextInt(3) + 1;
            for (int i = 0; i < dropNugget; ++i) {
                this.func_145779_a(Items.field_151074_bl, 1);
            }
            if (GaiaConfig.OPTIONS.additionalOre) {
                int dropNuggetAlt = this.field_70146_Z.nextInt(3) + 1;
                for (int i = 0; i < dropNuggetAlt; ++i) {
                    ItemShard.dropNugget((Entity)this, 5);
                }
            }
            if (this.field_70146_Z.nextInt(40) == 0) {
                switch (this.field_70146_Z.nextInt(2)) {
                    case 0: {
                        this.func_145779_a(GaiaItems.BOX_GOLD, 1);
                    }
                    case 1: {
                        this.func_145779_a(GaiaItems.BAG_BOOK, 1);
                    }
                }
            }
            if (this.field_70146_Z.nextInt(100) == 0) {
                ItemStack fanFire = new ItemStack(GaiaItems.WEAPON_FAN_FIRE);
                fanFire.func_77966_a(Enchantments.field_77334_n, 2);
                fanFire.func_77966_a(Enchantments.field_180313_o, 1);
                this.func_70099_a(fanFire, 1.0f);
            }
            if (this.field_70146_Z.nextInt(100) == 0) {
                this.func_145779_a(Item.func_150898_a((Block)GaiaBlocks.DOLL_NINE_TAILS), 1);
            }
        }
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        IEntityLivingData ret = super.func_180482_a(difficulty, livingdata);
        this.setCombatTask();
        return ret;
    }

    private void setEquipmentEnchanted(int id) {
        switch (id) {
            case 1: {
                ItemStack weapon = new ItemStack(GaiaItems.WEAPON_PROP_ENCHANTED, 1);
                weapon.func_77966_a(Enchantments.field_180313_o, 1);
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, weapon);
                break;
            }
            case 2: {
                ItemStack weapon = new ItemStack(GaiaItems.WEAPON_FAN, 1);
                weapon.func_77966_a(Enchantments.field_180313_o, 2);
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, weapon);
            }
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(WEAPON_TYPE, (Object)0);
    }

    public int getWeaponType() {
        return (Integer)this.field_70180_af.func_187225_a(WEAPON_TYPE);
    }

    private void setWeaponType(int par1) {
        this.field_70180_af.func_187227_b(WEAPON_TYPE, (Object)par1);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("WeaponType", this.getWeaponType());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setWeaponType(compound.func_74762_e("WeaponType"));
        this.setCombatTask();
    }

    public int func_70641_bl() {
        return 1;
    }

    @Override
    public boolean func_70601_bi() {
        return this.field_70163_u > (!GaiaConfig.SPAWN.disableYRestriction ? 60.0 : 0.0) && super.func_70601_bi();
    }
}

