/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity.monster;

import gaia.GaiaConfig;
import gaia.entity.EntityAttributes;
import gaia.entity.EntityMobHostileBase;
import gaia.entity.ai.EntityAIGaiaBreakDoor;
import gaia.entity.ai.Ranged;
import gaia.entity.monster.EntityGaiaDwarf;
import gaia.entity.monster.EntityGaiaMinotaurus;
import gaia.init.GaiaItems;
import gaia.init.GaiaLootTables;
import gaia.init.GaiaSounds;
import gaia.items.ItemShard;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntityGaiaOrc
extends EntityMobHostileBase
implements IRangedAttackMob {
    private static final String MOB_TYPE_TAG = "MobType";
    private final EntityAIGaiaBreakDoor aiBreakDoor = new EntityAIGaiaBreakDoor((EntityLiving)this);
    private EntityAIAttackRanged aiArrowAttack = new EntityAIAttackRanged((IRangedAttackMob)this, 1.25, 20, 60, 15.0f);
    private EntityAIAttackMelee aiAttackOnCollide = new EntityAIAttackMelee((EntityCreature)this, 1.25, true);
    private static final DataParameter<Integer> SKIN = EntityDataManager.func_187226_a(EntityGaiaMinotaurus.class, (DataSerializer)DataSerializers.field_187192_b);
    private int switchHealth;
    private int buffEffect;
    private boolean animationPlay;
    private int animationTimer;

    public EntityGaiaOrc(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.8f, 2.2f);
        this.field_70728_aV = 10;
        this.field_70138_W = 1.0f;
        this.func_98053_h(true);
        this.switchHealth = 0;
        this.buffEffect = 0;
        this.animationPlay = false;
        this.animationTimer = 0;
        if (!worldIn.field_72995_K) {
            this.setCombatTask();
        }
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityGaiaDwarf.class, true));
    }

    public void setBreakDoorsAItask(boolean enabled) {
        ((PathNavigateGround)this.func_70661_as()).func_179688_b(enabled);
        if (enabled) {
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiBreakDoor);
        } else {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiBreakDoor);
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)EntityAttributes.MAX_HEALTH_1);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)EntityAttributes.ATTACK_DAMAGE_1);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(4.0);
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (this.hasShield()) {
            Entity entity = source.func_76364_f();
            return !(entity instanceof EntityArrow) && super.func_70097_a(source, Math.min(damage, EntityAttributes.BASE_DEFENSE_1));
        }
        return super.func_70097_a(source, Math.min(damage, EntityAttributes.BASE_DEFENSE_1));
    }

    private boolean hasShield() {
        ItemStack itemstack = this.func_184582_a(EntityEquipmentSlot.OFFHAND);
        return itemstack.func_77973_b() == Items.field_185159_cQ || itemstack.func_77973_b() == GaiaItems.SHIELD_PROP;
    }

    public void func_70653_a(Entity entityIn, float strength, double xRatio, double zRatio) {
        super.knockBack(xRatio, zRatio, 0.3);
    }

    @Override
    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        Ranged.magic(target, (EntityLivingBase)this, distanceFactor);
        this.setEquipment((byte)1);
        this.animationPlay = true;
        this.animationTimer = 0;
    }

    public boolean func_70686_a(Class<? extends EntityLivingBase> cls) {
        return super.func_70686_a(cls) && cls != EntityGaiaOrc.class;
    }

    public boolean func_175446_cd() {
        return false;
    }

    public void func_70636_d() {
        if (this.getMobType() == 0) {
            if (this.func_110143_aJ() <= EntityAttributes.MAX_HEALTH_1 * 0.25f && this.func_110143_aJ() > 0.0f && this.buffEffect == 0) {
                this.setAI((byte)2);
                this.setEquipment((byte)2);
                this.buffEffect = 1;
                this.animationPlay = true;
            }
            if (this.func_110143_aJ() > EntityAttributes.MAX_HEALTH_1 * 0.25f && this.buffEffect == 1) {
                this.buffEffect = 0;
                this.animationPlay = false;
                this.animationTimer = 0;
            }
            if (this.animationPlay) {
                if (this.animationTimer != 15) {
                    ++this.animationTimer;
                } else {
                    this.setBuff();
                    this.setAI((byte)1);
                    this.setEquipment((byte)0);
                    this.animationPlay = false;
                }
            }
        } else if (this.getMobType() == 1) {
            this.beaconMonster(6.0);
            if (this.func_110143_aJ() < EntityAttributes.MAX_HEALTH_1 * 0.5f && this.switchHealth == 0) {
                this.setAI((byte)1);
                this.switchHealth = 1;
            }
            if (this.func_110143_aJ() > EntityAttributes.MAX_HEALTH_1 * 0.5f && this.switchHealth == 1) {
                this.setAI((byte)0);
                this.switchHealth = 0;
            }
            if (this.animationPlay) {
                if (this.animationTimer != 30) {
                    ++this.animationTimer;
                } else {
                    this.setEquipment((byte)0);
                    this.animationPlay = false;
                }
            }
        }
        super.func_70636_d();
    }

    private void setAI(byte id) {
        if (id == 0) {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiBreakDoor);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiAttackOnCollide);
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.aiArrowAttack);
            this.setEquipment((byte)0);
            this.animationPlay = false;
            this.animationTimer = 0;
        }
        if (id == 1) {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiArrowAttack);
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiBreakDoor);
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.aiAttackOnCollide);
        }
        if (id == 2) {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiBreakDoor);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiAttackOnCollide);
        }
    }

    private void setEquipment(byte id) {
        if (id == 0) {
            this.func_184201_a(EntityEquipmentSlot.HEAD, ItemStack.field_190927_a);
        }
        if (id == 1) {
            this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(Items.field_151032_g));
        }
        if (id == 2) {
            this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(Items.field_151055_y));
        }
    }

    private void setBuff() {
        this.field_70170_p.func_72960_a((Entity)this, (byte)7);
        this.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 1200, 0));
    }

    private void beaconMonster(double range) {
        if (!this.field_70170_p.field_72995_K) {
            AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t + 1.0, this.field_70163_u + 1.0, this.field_70161_v + 1.0).func_186662_g(range);
            List moblist = this.field_70170_p.func_72872_a(EntityLivingBase.class, axisalignedbb);
            for (EntityLivingBase mob : moblist) {
                if (!(mob instanceof EntityGaiaOrc)) continue;
                mob.func_70690_d(new PotionEffect(MobEffects.field_76422_e, 300, 1, true, true));
            }
        }
    }

    public void func_184201_a(EntityEquipmentSlot slotIn, ItemStack stack) {
        super.func_184201_a(slotIn, stack);
        if (!this.field_70170_p.field_72995_K && slotIn.func_188454_b() == 0) {
            this.setCombatTask();
        }
    }

    private void setCombatTask() {
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiAttackOnCollide);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiArrowAttack);
        ItemStack itemstack = this.func_184614_ca();
        if (itemstack.func_77973_b() == GaiaItems.WEAPON_PROP) {
            this.setAI((byte)0);
        } else {
            this.setAI((byte)1);
        }
    }

    public int getTextureType() {
        return (Integer)this.field_70180_af.func_187225_a(SKIN);
    }

    private void setTextureType(int par1) {
        this.field_70180_af.func_187227_b(SKIN, (Object)par1);
    }

    private int getMobType() {
        return (Integer)this.field_70180_af.func_187225_a(SKIN);
    }

    private void setMobType(int par1) {
        this.field_70180_af.func_187227_b(SKIN, (Object)par1);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74774_a(MOB_TYPE_TAG, (byte)this.getMobType());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b(MOB_TYPE_TAG)) {
            byte b0 = compound.func_74771_c(MOB_TYPE_TAG);
            this.setMobType(b0);
        }
        this.setCombatTask();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SKIN, (Object)0);
    }

    protected SoundEvent func_184639_G() {
        return GaiaSounds.ORC_SAY;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return GaiaSounds.ORC_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return GaiaSounds.ORC_DEATH;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        switch (this.getMobType()) {
            case 0: {
                return GaiaLootTables.ENTITIES_GAIA_ORC_MELEE;
            }
            case 1: {
                return GaiaLootTables.ENTITIES_GAIA_ORC_RANGED;
            }
        }
        return LootTableList.field_186419_a;
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        if (wasRecentlyHit) {
            if (this.field_70146_Z.nextInt(2) == 0 || this.field_70146_Z.nextInt(1 + lootingModifier) > 0) {
                this.func_145779_a(GaiaItems.FOOD_MEAT, 1);
            }
            int dropNugget = this.field_70146_Z.nextInt(3) + 1;
            for (int i = 0; i < dropNugget; ++i) {
                this.func_145779_a(Items.field_191525_da, 1);
            }
            if (GaiaConfig.OPTIONS.additionalOre) {
                int dropNuggetAlt = this.field_70146_Z.nextInt(3) + 1;
                for (int i = 0; i < dropNuggetAlt; ++i) {
                    ItemShard.dropNugget((Entity)this, 4);
                }
            }
            if (this.field_70146_Z.nextInt(40) == 0) {
                this.func_145779_a(GaiaItems.BOX_IRON, 1);
            }
            if (this.field_70146_Z.nextInt(100) == 0 && this.getMobType() == 1) {
                this.func_145779_a(GaiaItems.BAG_BOOK, 1);
            }
        }
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        IEntityLivingData ret = super.func_180482_a(difficulty, livingdata);
        if (this.field_70170_p.field_73012_v.nextInt(4) == 0) {
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(GaiaItems.WEAPON_PROP, 1, 0));
            this.setTextureType(2);
        } else {
            switch (this.field_70146_Z.nextInt(2)) {
                case 0: {
                    this.setTextureType(0);
                    break;
                }
                case 1: {
                    this.setTextureType(1);
                }
            }
            block4 : switch (this.getTextureType()) {
                case 0: {
                    switch (this.field_70146_Z.nextInt(2)) {
                        case 0: {
                            this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151049_t));
                            this.func_180483_b(difficulty);
                            break;
                        }
                        case 1: {
                            this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151036_c));
                            this.func_180483_b(difficulty);
                        }
                    }
                    break;
                }
                case 1: {
                    switch (this.field_70146_Z.nextInt(2)) {
                        case 0: {
                            this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151053_p));
                            this.func_180483_b(difficulty);
                            break block4;
                        }
                        case 1: {
                            this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151049_t));
                            this.func_180483_b(difficulty);
                        }
                    }
                }
            }
            ItemStack itemstack = this.func_184582_a(EntityEquipmentSlot.MAINHAND);
            ItemStack shield = ItemStack.field_190927_a;
            ItemStack armor_leggings = ItemStack.field_190927_a;
            ItemStack armor_chestplate = ItemStack.field_190927_a;
            switch (this.getTextureType()) {
                case 0: {
                    if (itemstack.func_77973_b() == Items.field_151049_t) {
                        armor_leggings = new ItemStack((Item)Items.field_151026_S);
                    }
                    if (itemstack.func_77973_b() != Items.field_151036_c) break;
                    armor_leggings = new ItemStack((Item)Items.field_151026_S);
                    armor_chestplate = new ItemStack((Item)Items.field_151027_R);
                    break;
                }
                case 1: {
                    if (itemstack.func_77973_b() == Items.field_151053_p) {
                        shield = new ItemStack(GaiaItems.SHIELD_PROP, 1, 0);
                        armor_leggings = new ItemStack((Item)Items.field_151026_S);
                        armor_chestplate = new ItemStack((Item)Items.field_151027_R);
                    }
                    if (itemstack.func_77973_b() != Items.field_151049_t) break;
                    shield = new ItemStack(GaiaItems.SHIELD_PROP, 1, 1);
                    armor_leggings = new ItemStack((Item)Items.field_151026_S);
                    armor_chestplate = new ItemStack((Item)Items.field_151030_Z);
                }
            }
            this.func_184201_a(EntityEquipmentSlot.OFFHAND, shield);
            this.func_184201_a(EntityEquipmentSlot.LEGS, armor_leggings);
            this.func_184201_a(EntityEquipmentSlot.CHEST, armor_chestplate);
            this.setBreakDoorsAItask(true);
        }
        this.setCombatTask();
        return ret;
    }

    public int func_70641_bl() {
        return 2;
    }

    @Override
    public boolean func_70601_bi() {
        return this.field_70163_u > (!GaiaConfig.SPAWN.disableYRestriction ? 60.0 : 0.0) && super.func_70601_bi();
    }
}

