/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity.monster;

import gaia.GaiaConfig;
import gaia.entity.EntityAttributes;
import gaia.entity.EntityMobHostileBase;
import gaia.init.GaiaItems;
import gaia.init.GaiaLootTables;
import gaia.init.GaiaSounds;
import gaia.items.ItemShard;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityGaiaSharko
extends EntityMobHostileBase {
    private EntityAIAttackMelee aiAttackOnCollide = new EntityAIAttackMelee((EntityCreature)this, 1.275, true);
    private int buffEffect;
    private boolean animationPlay;
    private int animationTimer;
    private byte inWaterTimer;

    public EntityGaiaSharko(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.4f, 2.0f);
        this.field_70728_aV = 20;
        this.field_70138_W = 1.0f;
        this.func_184644_a(PathNodeType.WATER, 8.0f);
        this.buffEffect = 0;
        this.animationPlay = false;
        this.animationTimer = 0;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)EntityAttributes.MAX_HEALTH_2);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.275);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)EntityAttributes.ATTACK_DAMAGE_2);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(8.0);
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        return super.func_70097_a(source, Math.min(damage, EntityAttributes.BASE_DEFENSE_2));
    }

    public void func_70653_a(Entity entityIn, float strength, double xRatio, double zRatio) {
        super.knockBack(xRatio, zRatio, 0.25);
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        if (super.func_70652_k(entityIn)) {
            if (entityIn instanceof EntityLivingBase) {
                int byte0 = 0;
                if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL) {
                    byte0 = 10;
                } else if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                    byte0 = 20;
                }
                if (byte0 > 0) {
                    ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76421_d, byte0 * 20, 0));
                    ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76419_f, byte0 * 20, 2));
                }
            }
            return true;
        }
        return false;
    }

    public boolean func_175446_cd() {
        return false;
    }

    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K && this.func_184218_aH()) {
            this.func_184210_p();
        }
        if (!this.field_70170_p.field_72995_K && this.func_70026_G()) {
            if (this.inWaterTimer <= 100) {
                this.inWaterTimer = (byte)(this.inWaterTimer + 1);
            } else {
                this.field_70170_p.func_72960_a((Entity)this, (byte)8);
                this.func_70691_i(EntityAttributes.MAX_HEALTH_2 * 0.1f);
                this.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 100, 0));
                this.inWaterTimer = 0;
            }
        }
        if (this.func_110143_aJ() <= EntityAttributes.MAX_HEALTH_2 * 0.25f && this.func_110143_aJ() > 0.0f && this.buffEffect == 0) {
            this.setAI((byte)1);
            this.setEquipment((byte)1);
            this.buffEffect = 1;
            this.animationPlay = true;
        }
        if (this.func_110143_aJ() > EntityAttributes.MAX_HEALTH_2 * 0.25f && this.buffEffect == 1) {
            this.buffEffect = 0;
            this.animationPlay = false;
            this.animationTimer = 0;
        }
        if (this.animationPlay) {
            if (this.animationTimer != 15) {
                ++this.animationTimer;
            } else {
                this.setBuff();
                this.setAI((byte)0);
                this.setEquipment((byte)0);
                this.animationPlay = false;
            }
        }
        super.func_70636_d();
    }

    private void setAI(byte id) {
        if (id == 0) {
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiAttackOnCollide);
        }
        if (id == 1) {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiAttackOnCollide);
        }
    }

    private void setEquipment(byte id) {
        if (id == 0) {
            this.func_184201_a(EntityEquipmentSlot.HEAD, ItemStack.field_190927_a);
        }
        if (id == 1) {
            this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(Items.field_151055_y));
        }
    }

    private void setBuff() {
        this.field_70170_p.func_72960_a((Entity)this, (byte)7);
        this.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 1200, 0));
    }

    protected SoundEvent func_184639_G() {
        return GaiaSounds.SHARKO_SAY;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return GaiaSounds.SHARKO_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return GaiaSounds.SHARKO_DEATH;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(GaiaSounds.STEP_WEBBED, 1.0f, 1.0f);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return GaiaLootTables.ENTITIES_GAIA_SHARKO;
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        if (wasRecentlyHit) {
            int drop = this.field_70146_Z.nextInt(3 + lootingModifier);
            for (int i = 0; i < drop; ++i) {
                this.func_145779_a(GaiaItems.MISC_PEARL, 1);
            }
            if (this.field_70146_Z.nextInt(4) == 0 || this.field_70146_Z.nextInt(1 + lootingModifier) > 0) {
                this.func_145779_a(Items.field_179562_cC, 1);
            }
            int dropNugget = this.field_70146_Z.nextInt(3) + 1;
            for (int i = 0; i < dropNugget; ++i) {
                this.func_145779_a(Items.field_151074_bl, 1);
            }
            if (GaiaConfig.OPTIONS.additionalOre) {
                int dropNuggetAlt = this.field_70146_Z.nextInt(3) + 1;
                for (int i = 0; i < dropNuggetAlt; ++i) {
                    ItemShard.dropNugget((Entity)this, 5);
                }
            }
            if (this.field_70146_Z.nextInt(40) == 0) {
                switch (this.field_70146_Z.nextInt(2)) {
                    case 0: {
                        this.func_70099_a(new ItemStack(GaiaItems.BOX, 1, 0), 0.0f);
                    }
                    case 1: {
                        this.func_145779_a(GaiaItems.BAG_BOOK, 1);
                    }
                }
            }
            if (this.field_70146_Z.nextInt(100) == 0) {
                this.func_145779_a(GaiaItems.BOOK_BUFF, 1);
            }
        }
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        IEntityLivingData ret = super.func_180482_a(difficulty, livingdata);
        this.setAI((byte)0);
        ItemStack bootsSwimming = new ItemStack((Item)Items.field_151021_T);
        this.func_184201_a(EntityEquipmentSlot.FEET, bootsSwimming);
        bootsSwimming.func_77966_a(Enchantments.field_185300_i, 3);
        return ret;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_96092_aw() {
        return false;
    }

    protected int func_190531_bD() {
        return 10;
    }

    public int func_70641_bl() {
        return 2;
    }

    @Override
    public boolean func_70601_bi() {
        return this.field_70163_u < (!GaiaConfig.SPAWN.disableYRestriction ? 32.0 : 512.0) && super.func_70601_bi();
    }
}

