/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity.monster;

import gaia.GaiaConfig;
import gaia.entity.EntityAttributes;
import gaia.entity.EntityMobHostileBase;
import gaia.entity.monster.EntityGaiaIllagerButler;
import gaia.init.GaiaBlocks;
import gaia.init.GaiaItems;
import gaia.init.GaiaLootTables;
import gaia.init.GaiaSounds;
import gaia.items.ItemShard;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFleeSun;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIRestrictSun;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityGaiaVampire
extends EntityMobHostileBase {
    private static final String CAN_SPAWN_TAG = "CanSpawn";
    private static final DataParameter<Boolean> CAN_SPAWN = EntityDataManager.func_187226_a(EntityGaiaVampire.class, (DataSerializer)DataSerializers.field_187198_h);
    private int spawnLimit;
    private int spawnTime;
    private boolean canSpawn;
    private boolean spawnOnDeath;

    public EntityGaiaVampire(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.0f, 2.2f);
        this.field_70728_aV = 40;
        this.field_70138_W = 6.0f;
        this.field_70178_ae = true;
        this.spawnLimit = 0;
        this.spawnTime = 0;
        this.canSpawn = true;
        this.spawnOnDeath = false;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIRestrictSun((EntityCreature)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFleeSun((EntityCreature)this, 1.3));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.3, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)EntityAttributes.MAX_HEALTH_3);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)EntityAttributes.ATTACK_DAMAGE_3);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(12.0);
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (this.isArmored()) {
            return !(source instanceof EntityDamageSourceIndirect) && super.func_70097_a(source, Math.min(damage, EntityAttributes.BASE_DEFENSE_3));
        }
        return super.func_70097_a(source, Math.min(damage, EntityAttributes.BASE_DEFENSE_3));
    }

    public void func_70653_a(Entity entityIn, float strength, double xRatio, double zRatio) {
        super.knockBack(xRatio, zRatio, 0.2);
    }

    public boolean isArmored() {
        return this.func_110143_aJ() <= this.func_110138_aP() / 2.0f;
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        if (super.func_70652_k(entityIn)) {
            if (entityIn instanceof EntityLivingBase) {
                int byte0 = 0;
                if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL) {
                    byte0 = 10;
                } else if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                    byte0 = 20;
                }
                if (byte0 > 0 && this.func_110143_aJ() < EntityAttributes.MAX_HEALTH_3 * 0.75f) {
                    ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76419_f, byte0 * 20, 0));
                    this.field_70170_p.func_72960_a((Entity)this, (byte)8);
                    this.func_70691_i(EntityAttributes.MAX_HEALTH_3 * 0.1f);
                }
            }
            return true;
        }
        return false;
    }

    public boolean func_175446_cd() {
        return false;
    }

    public void func_70636_d() {
        float f;
        if (!this.field_70122_E && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.8;
        }
        if (!this.field_70170_p.field_72995_K && this.func_184218_aH()) {
            this.func_184210_p();
        }
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_72935_r() && (f = this.func_70013_c()) > 0.5f && this.field_70146_Z.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && this.field_70170_p.func_175678_i(this.func_180425_c())) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)11);
            this.func_70097_a(DamageSource.field_76377_j, EntityAttributes.MAX_HEALTH_3 * 0.25f);
        }
        if (this.func_110143_aJ() < EntityAttributes.MAX_HEALTH_3 * 0.75f && this.func_110143_aJ() > EntityAttributes.MAX_HEALTH_3 * 0.25f && this.canSpawn) {
            if (this.spawnLimit < 5) {
                if (this.spawnTime >= 0 && this.spawnTime <= 200) {
                    ++this.spawnTime;
                } else {
                    if (this.canSpawn()) {
                        this.field_70170_p.func_72960_a((Entity)this, (byte)9);
                        if (!this.field_70170_p.field_72995_K) {
                            this.setSpawn((byte)0);
                        }
                    }
                    ++this.spawnLimit;
                    this.spawnTime = 0;
                }
            } else {
                this.canSpawn = false;
            }
        }
        if (this.func_110143_aJ() <= 0.0f) {
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
            }
            if (!this.spawnOnDeath) {
                if (!this.field_70170_p.field_72995_K) {
                    this.setSpawn((byte)1);
                }
                this.spawnOnDeath = true;
            }
        } else {
            super.func_70636_d();
        }
    }

    private void setSpawn(byte id) {
        Object entitySpawn;
        BlockPos blockpos;
        if (id == 0) {
            blockpos = new BlockPos((Entity)this).func_177982_a(-1 + this.field_70146_Z.nextInt(3), 1, -1 + this.field_70146_Z.nextInt(3));
            entitySpawn = new EntityGaiaIllagerButler(this.field_70170_p);
            entitySpawn.func_174828_a(blockpos, 0.0f, 0.0f);
            ((EntityGaiaIllagerButler)((Object)entitySpawn)).func_180482_a(this.field_70170_p.func_175649_E(blockpos), null);
            this.field_70170_p.func_72838_d((Entity)entitySpawn);
        }
        if (id == 1) {
            blockpos = new BlockPos((Entity)this).func_177982_a(1, 2, 1);
            entitySpawn = new EntityBat(this.field_70170_p);
            entitySpawn.func_174828_a(blockpos, 0.0f, 0.0f);
            entitySpawn.func_180482_a(this.field_70170_p.func_175649_E(blockpos), (IEntityLivingData)null);
            this.field_70170_p.func_72838_d((Entity)entitySpawn);
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CAN_SPAWN, (Object)true);
    }

    public boolean canSpawn() {
        return (Boolean)this.func_184212_Q().func_187225_a(CAN_SPAWN);
    }

    public void setSpawn(boolean canSpawn) {
        this.func_184212_Q().func_187227_b(CAN_SPAWN, (Object)canSpawn);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a(CAN_SPAWN_TAG, this.canSpawn());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b(CAN_SPAWN_TAG)) {
            boolean b0 = compound.func_74767_n(CAN_SPAWN_TAG);
            this.setSpawn(b0);
        }
    }

    protected SoundEvent func_184639_G() {
        return GaiaSounds.VAMPIRE_SAY;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return GaiaSounds.VAMPIRE_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return GaiaSounds.VAMPIRE_DEATH;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(GaiaSounds.NONE, 1.0f, 1.0f);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return GaiaLootTables.ENTITIES_GAIA_VAMPIRE;
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        if (wasRecentlyHit) {
            if (this.field_70146_Z.nextInt(4) == 0 || this.field_70146_Z.nextInt(1 + lootingModifier) > 0) {
                this.func_145779_a(GaiaItems.FOOD_SMALL_APPLE_GOLD, 1);
            }
            int dropNugget = this.field_70146_Z.nextInt(3) + 1;
            for (int i = 0; i < dropNugget; ++i) {
                ItemShard.dropNugget((Entity)this, 2);
            }
            int dropNuggetAlt = this.field_70146_Z.nextInt(3) + 1;
            for (int i = 0; i < dropNuggetAlt; ++i) {
                ItemShard.dropNugget((Entity)this, 3);
            }
            if (this.field_70146_Z.nextInt(40) == 0) {
                this.func_145779_a(GaiaItems.BOX_DIAMOND, 1);
            }
            if (this.field_70146_Z.nextInt(100) == 0) {
                this.func_145779_a(Item.func_150898_a((Block)GaiaBlocks.BUST_VAMPIRE), 1);
            }
            if (this.field_70146_Z.nextInt(100) == 0) {
                this.func_70099_a(new ItemStack(GaiaItems.MISC_RING, 1, 3), 0.0f);
            }
        }
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        IEntityLivingData ret = super.func_180482_a(difficulty, livingdata);
        ItemStack bootsSwimming = new ItemStack((Item)Items.field_151021_T);
        this.func_184201_a(EntityEquipmentSlot.FEET, bootsSwimming);
        bootsSwimming.func_77966_a(Enchantments.field_185300_i, 2);
        return ret;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_96092_aw() {
        return false;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public void func_70110_aj() {
    }

    public int func_70641_bl() {
        return 1;
    }

    @Override
    public boolean func_70601_bi() {
        if (GaiaConfig.SPAWN.spawnLevel3Rain) {
            return this.field_70163_u > (!GaiaConfig.SPAWN.disableYRestriction ? 60.0 : 0.0) && this.field_70170_p.func_72896_J() && super.func_70601_bi();
        }
        return this.field_70163_u > (!GaiaConfig.SPAWN.disableYRestriction ? 60.0 : 0.0) && super.func_70601_bi();
    }
}

