/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity.monster;

import gaia.GaiaConfig;
import gaia.entity.EntityAttributes;
import gaia.entity.EntityMobHostileBase;
import gaia.init.GaiaBlocks;
import gaia.init.GaiaItems;
import gaia.init.GaiaLootTables;
import gaia.init.GaiaSounds;
import gaia.items.ItemShard;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityGaiaWitch
extends EntityMobHostileBase
implements IRangedAttackMob {
    private int spawn;
    private static final String MOB_TYPE_TAG = "MobType";
    private static final UUID MODIFIER_UUID = UUID.fromString("5CD17E52-A79A-43D3-A529-90FDE04B181E");
    private static final AttributeModifier MODIFIER = new AttributeModifier(MODIFIER_UUID, "Drinking speed penalty", -0.25, 0).func_111168_a(false);
    private static final DataParameter<Boolean> IS_DRINKING = EntityDataManager.func_187226_a(EntityGaiaWitch.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_RIDING = EntityDataManager.func_187226_a(EntityGaiaWitch.class, (DataSerializer)DataSerializers.field_187198_h);
    private int potionUseTimer;
    private static final DataParameter<Integer> SKIN = EntityDataManager.func_187226_a(EntityGaiaWitch.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityGaiaWitch(World par1World) {
        super(par1World);
        this.field_70728_aV = 20;
        this.field_70138_W = 1.0f;
        this.spawn = 0;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackRanged((IRangedAttackMob)this, 1.275, 60, 10.0f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)EntityAttributes.MAX_HEALTH_2);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.275);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)EntityAttributes.ATTACK_DAMAGE_2);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(8.0);
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        return super.func_70097_a(source, Math.min(damage, EntityAttributes.BASE_DEFENSE_2));
    }

    public void func_70653_a(Entity entityIn, float strength, double xRatio, double zRatio) {
        super.knockBack(xRatio, zRatio, 0.25);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SKIN, (Object)0);
        this.func_184212_Q().func_187214_a(IS_DRINKING, (Object)false);
        this.func_184212_Q().func_187214_a(IS_RIDING, (Object)false);
    }

    public void setDrinkingPotion(boolean drinkingPotion) {
        this.func_184212_Q().func_187227_b(IS_DRINKING, (Object)drinkingPotion);
    }

    public boolean isDrinkingPotion() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_DRINKING);
    }

    public void func_70636_d() {
        ItemStack itemstack;
        this.beaconMonster();
        if (!this.field_70122_E && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.8;
        }
        if (!this.field_70170_p.field_72995_K && this.func_184218_aH() && this.isRidingBroom()) {
            this.func_184210_p();
        }
        if (this.field_70159_w > 0.0 || this.field_70181_x > 0.0 || this.field_70179_y > 0.0) {
            for (int var5 = 0; var5 < 2; ++var5) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_WITCH, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
            }
        }
        if (this.func_110143_aJ() < EntityAttributes.MAX_HEALTH_2 * 0.75f && this.func_110143_aJ() > 0.0f && this.spawn == 0) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)9);
            if (!this.field_70170_p.field_72995_K) {
                this.setSpawn((byte)0);
            }
            this.spawn = 1;
        }
        if (this.func_110143_aJ() < EntityAttributes.MAX_HEALTH_2 * 0.25f && this.func_110143_aJ() > 0.0f && this.spawn == 1) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)9);
            if (!this.field_70170_p.field_72995_K) {
                this.setSpawn((byte)1);
            }
            this.spawn = 2;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.isDrinkingPotion()) {
                if (this.potionUseTimer-- <= 0) {
                    List list;
                    this.setDrinkingPotion(false);
                    ItemStack itemstack2 = this.func_184614_ca();
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(GaiaItems.WEAPON_PROP, 1, 0));
                    if (itemstack2.func_77973_b() == Items.field_151068_bn && (list = PotionUtils.func_185189_a((ItemStack)itemstack2)) != null) {
                        for (PotionEffect potioneffect : list) {
                            this.func_70690_d(new PotionEffect(potioneffect));
                        }
                    }
                    this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(MODIFIER);
                }
            } else {
                PotionType potiontype = null;
                if (this.field_70146_Z.nextFloat() < 0.15f && this.func_70055_a(Material.field_151586_h) && !this.func_70644_a(MobEffects.field_76427_o)) {
                    potiontype = PotionTypes.field_185248_t;
                } else if (this.field_70146_Z.nextFloat() < 0.15f && (this.func_70027_ad() || this.func_189748_bU() != null && this.func_189748_bU().func_76347_k()) && !this.func_70644_a(MobEffects.field_76426_n)) {
                    potiontype = PotionTypes.field_185241_m;
                } else if (this.field_70146_Z.nextFloat() < 0.05f && this.func_110143_aJ() < this.func_110138_aP()) {
                    potiontype = PotionTypes.field_185250_v;
                } else if (this.field_70146_Z.nextFloat() < 0.5f && this.func_70638_az() != null && !this.func_70644_a(MobEffects.field_76424_c) && this.func_70638_az().func_70068_e((Entity)this) > 121.0) {
                    potiontype = PotionTypes.field_185243_o;
                }
                if (potiontype != null) {
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)potiontype));
                    this.potionUseTimer = this.func_184614_ca().func_77988_m();
                    this.setDrinkingPotion(true);
                    this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187922_gv, this.func_184176_by(), 1.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.4f);
                    IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
                    iattributeinstance.func_111124_b(MODIFIER);
                    iattributeinstance.func_111121_a(MODIFIER);
                }
            }
            if (this.field_70146_Z.nextFloat() < 7.5E-4f) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)15);
            }
        }
        if ((itemstack = this.func_184582_a(EntityEquipmentSlot.OFFHAND)).func_77973_b() == GaiaItems.WEAPON_PROP_BROOM) {
            this.setRidingBroom(true);
        } else {
            this.setRidingBroom(false);
        }
        super.func_70636_d();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 13) {
            for (int i = 0; i < this.field_70146_Z.nextInt(35) + 10; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_WITCH, this.field_70165_t + this.field_70146_Z.nextGaussian() * (double)0.13f, this.func_174813_aQ().field_72337_e + 0.5 + this.field_70146_Z.nextGaussian() * (double)0.13f, this.field_70161_v + this.field_70146_Z.nextGaussian() * 0.13, 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            super.func_70103_a(id);
        }
    }

    protected float func_70672_c(DamageSource source, float damage) {
        damage = super.func_70672_c(source, damage);
        if (source.func_76346_g() == this) {
            damage = 0.0f;
        }
        if (source.func_82725_o()) {
            damage = (float)((double)damage * 0.15);
        }
        return damage;
    }

    @Override
    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        if (!this.isDrinkingPotion()) {
            double d0 = target.field_70163_u + (double)target.func_70047_e() - (double)1.1f;
            double d1 = target.field_70165_t + target.field_70159_w - this.field_70165_t;
            double d2 = d0 - this.field_70163_u;
            double d3 = target.field_70161_v + target.field_70179_y - this.field_70161_v;
            float f = MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3));
            PotionType potiontype = PotionTypes.field_185252_x;
            if (f >= 8.0f && !target.func_70644_a(MobEffects.field_76421_d)) {
                potiontype = PotionTypes.field_185246_r;
            } else if (target.func_110143_aJ() >= 8.0f && !target.func_70644_a(MobEffects.field_76436_u)) {
                potiontype = PotionTypes.field_185254_z;
            } else if (f <= 3.0f && !target.func_70644_a(MobEffects.field_76437_t) && this.field_70146_Z.nextFloat() < 0.25f) {
                potiontype = PotionTypes.field_185226_I;
            }
            EntityPotion entitypotion = new EntityPotion(this.field_70170_p, (EntityLivingBase)this, PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185155_bH), (PotionType)potiontype));
            entitypotion.field_70125_A -= -20.0f;
            entitypotion.func_70186_c(d1, d2 + (double)(f * 0.2f), d3, 0.75f, 8.0f);
            this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187924_gx, this.func_184176_by(), 1.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.4f);
            this.field_70170_p.func_72838_d((Entity)entitypotion);
        }
    }

    private void setSpawn(byte id) {
        EntityZombie entitySpawn;
        BlockPos blockpos = new BlockPos((Entity)this).func_177982_a(-1 + this.field_70146_Z.nextInt(3), 1, -1 + this.field_70146_Z.nextInt(3));
        if (id == 0) {
            entitySpawn = new EntityZombie(this.field_70170_p);
            entitySpawn.func_174828_a(blockpos, 0.0f, 0.0f);
            entitySpawn.func_180482_a(this.field_70170_p.func_175649_E(blockpos), (IEntityLivingData)null);
            entitySpawn.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(GaiaItems.ACCESSORY_HEADGEAR_BOLT));
            entitySpawn.func_184642_a(EntityEquipmentSlot.MAINHAND, 0.0f);
            entitySpawn.func_184642_a(EntityEquipmentSlot.OFFHAND, 0.0f);
            entitySpawn.func_184642_a(EntityEquipmentSlot.FEET, 0.0f);
            entitySpawn.func_184642_a(EntityEquipmentSlot.LEGS, 0.0f);
            entitySpawn.func_184642_a(EntityEquipmentSlot.CHEST, 0.0f);
            entitySpawn.func_184642_a(EntityEquipmentSlot.HEAD, 0.0f);
            this.field_70170_p.func_72838_d((Entity)entitySpawn);
        }
        if (id == 1) {
            entitySpawn = new EntitySkeleton(this.field_70170_p);
            entitySpawn.func_174828_a(blockpos, 0.0f, 0.0f);
            entitySpawn.func_180482_a(this.field_70170_p.func_175649_E(blockpos), (IEntityLivingData)null);
            entitySpawn.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(GaiaItems.ACCESSORY_HEADGEAR_BOLT));
            entitySpawn.func_184642_a(EntityEquipmentSlot.MAINHAND, 0.0f);
            entitySpawn.func_184642_a(EntityEquipmentSlot.OFFHAND, 0.0f);
            entitySpawn.func_184642_a(EntityEquipmentSlot.FEET, 0.0f);
            entitySpawn.func_184642_a(EntityEquipmentSlot.LEGS, 0.0f);
            entitySpawn.func_184642_a(EntityEquipmentSlot.CHEST, 0.0f);
            entitySpawn.func_184642_a(EntityEquipmentSlot.HEAD, 0.0f);
            this.field_70170_p.func_72838_d((Entity)entitySpawn);
        }
    }

    private void beaconMonster() {
        if (!this.field_70170_p.field_72995_K) {
            AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t + 1.0, this.field_70163_u + 1.0, this.field_70161_v + 1.0).func_186662_g(6.0);
            List moblist = this.field_70170_p.func_72872_a(EntityLivingBase.class, axisalignedbb);
            for (EntityLivingBase mob : moblist) {
                if (!(mob instanceof EntityZombie) && !(mob instanceof EntitySkeleton)) continue;
                mob.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 300, 1, true, true));
            }
        }
    }

    protected SoundEvent func_184639_G() {
        return GaiaSounds.WITCH_SAY;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return GaiaSounds.WITCH_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return GaiaSounds.WITCH_DEATH;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(GaiaSounds.NONE, 1.0f, 1.0f);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        switch (this.field_70146_Z.nextInt(2)) {
            case 0: {
                return GaiaLootTables.ENTITIES_GAIA_WITCH;
            }
            case 1: {
                return LootTableList.field_186432_n;
            }
        }
        return GaiaLootTables.ENTITIES_GAIA_WITCH;
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        if (wasRecentlyHit) {
            int drop = this.field_70146_Z.nextInt(3 + lootingModifier);
            for (int i = 0; i < drop; ++i) {
                this.func_145779_a(GaiaItems.FOOD_NETHER_WART, 1);
            }
            int dropNugget = this.field_70146_Z.nextInt(3) + 1;
            for (int i = 0; i < dropNugget; ++i) {
                this.func_145779_a(Items.field_151074_bl, 1);
            }
            if (GaiaConfig.OPTIONS.additionalOre) {
                int dropNuggetAlt = this.field_70146_Z.nextInt(3) + 1;
                for (int i = 0; i < dropNuggetAlt; ++i) {
                    ItemShard.dropNugget((Entity)this, 5);
                }
            }
            if (this.field_70146_Z.nextInt(40) == 0) {
                switch (this.field_70146_Z.nextInt(2)) {
                    case 0: {
                        this.func_145779_a(GaiaItems.BOX_GOLD, 1);
                    }
                    case 1: {
                        this.func_145779_a(GaiaItems.BAG_BOOK, 1);
                    }
                }
            }
            if (this.field_70146_Z.nextInt(100) == 0) {
                this.func_145779_a(GaiaItems.MISC_BOOK, 1);
            }
            if (this.field_70146_Z.nextInt(100) == 0) {
                this.func_145779_a(Item.func_150898_a((Block)GaiaBlocks.DECO_MANDRAGORA_POT), 1);
            }
        }
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        IEntityLivingData ret = super.func_180482_a(difficulty, livingdata);
        if (this.field_70170_p.field_73012_v.nextInt(4) == 0) {
            this.setTextureType(1);
        }
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(GaiaItems.WEAPON_PROP, 1, 0));
        if (this.field_70170_p.field_73012_v.nextInt(2) == 0) {
            this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(GaiaItems.WEAPON_PROP_BROOM));
        }
        return ret;
    }

    public boolean func_70687_e(PotionEffect potioneffectIn) {
        return potioneffectIn.func_188419_a() != MobEffects.field_76436_u && potioneffectIn.func_188419_a() != MobEffects.field_76433_i && super.func_70687_e(potioneffectIn);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public void setRidingBroom(boolean riding) {
        this.func_184212_Q().func_187227_b(IS_RIDING, (Object)riding);
    }

    public boolean isRidingBroom() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_RIDING);
    }

    public int getTextureType() {
        return (Integer)this.field_70180_af.func_187225_a(SKIN);
    }

    private void setTextureType(int par1) {
        this.field_70180_af.func_187227_b(SKIN, (Object)par1);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74774_a(MOB_TYPE_TAG, (byte)this.getTextureType());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b(MOB_TYPE_TAG)) {
            byte b0 = compound.func_74771_c(MOB_TYPE_TAG);
            this.setTextureType(b0);
        }
    }

    public int func_70641_bl() {
        return 1;
    }

    @Override
    public boolean func_70601_bi() {
        return this.field_70163_u > (!GaiaConfig.SPAWN.disableYRestriction ? 60.0 : 0.0) && super.func_70601_bi();
    }
}

