/*
 * Decompiled with CFR 0.152.
 */
package gaia.init;

import gaia.Gaia;
import gaia.block.BlockDecoration;
import gaia.block.BlockFireCamp;
import gaia.block.BlockSpawnGuard;
import gaia.block.BlockVanilla;
import gaia.block.BlockWebTemp;
import gaia.tileentity.TileEntityBust;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@GameRegistry.ObjectHolder(value="grimoireofgaia")
public class GaiaBlocks {
    public static final Block BLOCK_PEARL = Blocks.field_150350_a;
    public static final Block BUST_GORGON = Blocks.field_150350_a;
    public static final Block BUST_SPHINX = Blocks.field_150350_a;
    public static final Block BUST_VALKYRIE = Blocks.field_150350_a;
    public static final Block BUST_VAMPIRE = Blocks.field_150350_a;
    public static final Block DOLL_CREEPER_GIRL = Blocks.field_150350_a;
    public static final Block DOLL_ENDER_GIRL = Blocks.field_150350_a;
    public static final Block DOLL_SLIME_GIRL = Blocks.field_150350_a;
    public static final Block DOLL_MAID = Blocks.field_150350_a;
    public static final Block DOLL_DULLAHAN = Blocks.field_150350_a;
    public static final Block DOLL_MERMAID = Blocks.field_150350_a;
    public static final Block DOLL_NINE_TAILS = Blocks.field_150350_a;
    public static final Block DOLL_DRYAD = Blocks.field_150350_a;
    public static final Block DECO_GARDEN_GNOME = Blocks.field_150350_a;
    public static final Block DECO_MANDRAGORA_POT = Blocks.field_150350_a;
    public static final Block DECO_BUST_MINOTAUR = Blocks.field_150350_a;
    public static final Block DECO_NEST_HARPY = Blocks.field_150350_a;
    public static final Block SPAWN_GUARD = Blocks.field_150350_a;
    public static final Block WEB_TEMP = Blocks.field_150350_a;
    public static final Block FIRE_CAMP = Blocks.field_150350_a;

    private GaiaBlocks() {
    }

    @Mod.EventBusSubscriber(modid="grimoireofgaia")
    public static class RegistrationHandler {
        private RegistrationHandler() {
        }

        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            Gaia.LOGGER.info("Registering blocks...");
            IForgeRegistry registry = event.getRegistry();
            registry.register((IForgeRegistryEntry)new BlockVanilla(Material.field_151576_e, "block_pearl", 1.5f, 10.0f, SoundType.field_185851_d));
            registry.register((IForgeRegistryEntry)new BlockDecoration(Material.field_151576_e, "bust_gorgon", 1.5f, 6.0f, SoundType.field_185851_d));
            registry.register((IForgeRegistryEntry)new BlockDecoration(Material.field_151576_e, "bust_sphinx", 1.5f, 6.0f, SoundType.field_185851_d));
            registry.register((IForgeRegistryEntry)new BlockDecoration(Material.field_151576_e, "bust_valkyrie", 1.5f, 6.0f, SoundType.field_185851_d));
            registry.register((IForgeRegistryEntry)new BlockDecoration(Material.field_151576_e, "bust_vampire", 1.5f, 6.0f, SoundType.field_185851_d));
            registry.register((IForgeRegistryEntry)new BlockDecoration(Material.field_151580_n, "doll_creeper_girl", 0.8f, 6.0f, SoundType.field_185854_g));
            registry.register((IForgeRegistryEntry)new BlockDecoration(Material.field_151580_n, "doll_ender_girl", 0.8f, 6.0f, SoundType.field_185854_g));
            registry.register((IForgeRegistryEntry)new BlockDecoration(Material.field_151580_n, "doll_slime_girl", 0.8f, 6.0f, SoundType.field_185854_g));
            registry.register((IForgeRegistryEntry)new BlockDecoration(Material.field_151580_n, "doll_maid", 0.8f, 6.0f, SoundType.field_185854_g));
            registry.register((IForgeRegistryEntry)new BlockDecoration(Material.field_151580_n, "doll_dullahan", 0.8f, 6.0f, SoundType.field_185854_g));
            registry.register((IForgeRegistryEntry)new BlockDecoration(Material.field_151580_n, "doll_mermaid", 0.8f, 6.0f, SoundType.field_185854_g));
            registry.register((IForgeRegistryEntry)new BlockDecoration(Material.field_151580_n, "doll_nine_tails", 0.8f, 6.0f, SoundType.field_185854_g));
            registry.register((IForgeRegistryEntry)new BlockDecoration(Material.field_151580_n, "doll_dryad", 0.8f, 6.0f, SoundType.field_185854_g));
            registry.register((IForgeRegistryEntry)new BlockDecoration(Material.field_151580_n, "deco_garden_gnome", 0.8f, 6.0f, SoundType.field_185851_d));
            registry.register((IForgeRegistryEntry)new BlockDecoration(Material.field_151580_n, "deco_mandragora_pot", 0.8f, 6.0f, SoundType.field_185851_d));
            registry.register((IForgeRegistryEntry)new BlockDecoration(Material.field_151576_e, "deco_bust_minotaur", 1.5f, 6.0f, SoundType.field_185851_d));
            registry.register((IForgeRegistryEntry)new BlockDecoration(Material.field_151584_j, "deco_nest_harpy", 0.8f, 6.0f, SoundType.field_185850_c));
            registry.register((IForgeRegistryEntry)new BlockSpawnGuard());
            registry.register((IForgeRegistryEntry)new BlockWebTemp());
            registry.register((IForgeRegistryEntry)new BlockFireCamp());
            GameRegistry.registerTileEntity(TileEntityBust.class, (ResourceLocation)new ResourceLocation("grimoireofgaia", "tile_bust"));
            Gaia.LOGGER.info("Block registration complete.");
        }

        @SubscribeEvent
        public static void registerItemBlocks(RegistryEvent.Register<Item> event) {
            Gaia.LOGGER.info("Registering item blocks...");
            IForgeRegistry registry = event.getRegistry();
            RegistrationHandler.registerItemBlock((IForgeRegistry<Item>)registry, BLOCK_PEARL);
            RegistrationHandler.registerItemBlock((IForgeRegistry<Item>)registry, BUST_GORGON);
            RegistrationHandler.registerItemBlock((IForgeRegistry<Item>)registry, BUST_SPHINX);
            RegistrationHandler.registerItemBlock((IForgeRegistry<Item>)registry, BUST_VALKYRIE);
            RegistrationHandler.registerItemBlock((IForgeRegistry<Item>)registry, BUST_VAMPIRE);
            RegistrationHandler.registerItemBlock((IForgeRegistry<Item>)registry, DOLL_CREEPER_GIRL);
            RegistrationHandler.registerItemBlock((IForgeRegistry<Item>)registry, DOLL_ENDER_GIRL);
            RegistrationHandler.registerItemBlock((IForgeRegistry<Item>)registry, DOLL_SLIME_GIRL);
            RegistrationHandler.registerItemBlock((IForgeRegistry<Item>)registry, DOLL_MAID);
            RegistrationHandler.registerItemBlock((IForgeRegistry<Item>)registry, DOLL_DULLAHAN);
            RegistrationHandler.registerItemBlock((IForgeRegistry<Item>)registry, DOLL_MERMAID);
            RegistrationHandler.registerItemBlock((IForgeRegistry<Item>)registry, DOLL_NINE_TAILS);
            RegistrationHandler.registerItemBlock((IForgeRegistry<Item>)registry, DOLL_DRYAD);
            RegistrationHandler.registerItemBlock((IForgeRegistry<Item>)registry, DECO_GARDEN_GNOME);
            RegistrationHandler.registerItemBlock((IForgeRegistry<Item>)registry, DECO_MANDRAGORA_POT);
            RegistrationHandler.registerItemBlock((IForgeRegistry<Item>)registry, DECO_BUST_MINOTAUR);
            RegistrationHandler.registerItemBlock((IForgeRegistry<Item>)registry, DECO_NEST_HARPY);
            RegistrationHandler.registerItemBlock((IForgeRegistry<Item>)registry, SPAWN_GUARD);
            RegistrationHandler.registerItemBlock((IForgeRegistry<Item>)registry, WEB_TEMP);
            RegistrationHandler.registerItemBlock((IForgeRegistry<Item>)registry, FIRE_CAMP);
            Gaia.LOGGER.info("Item block registration complete.");
        }

        private static void registerItemBlock(IForgeRegistry<Item> registry, Block block) {
            ItemBlock item = new ItemBlock(block);
            ResourceLocation registryName = block.getRegistryName();
            registry.register(item.setRegistryName(registryName));
        }
    }
}

