/*
 * Decompiled with CFR 0.152.
 */
package gaia.init;

import com.google.common.collect.ImmutableSet;
import gaia.Gaia;
import gaia.delete.EntityGaiaPropCampfire;
import gaia.entity.debug.EntityDebugMob;
import gaia.entity.monster.EntityGaiaAnt;
import gaia.entity.monster.EntityGaiaAntRanger;
import gaia.entity.monster.EntityGaiaAnubis;
import gaia.entity.monster.EntityGaiaArachne;
import gaia.entity.monster.EntityGaiaBanshee;
import gaia.entity.monster.EntityGaiaBaphomet;
import gaia.entity.monster.EntityGaiaBee;
import gaia.entity.monster.EntityGaiaBeholder;
import gaia.entity.monster.EntityGaiaBoneKnight;
import gaia.entity.monster.EntityGaiaCecaelia;
import gaia.entity.monster.EntityGaiaCentaur;
import gaia.entity.monster.EntityGaiaCobbleGolem;
import gaia.entity.monster.EntityGaiaCobblestoneGolem;
import gaia.entity.monster.EntityGaiaCreep;
import gaia.entity.monster.EntityGaiaDeathword;
import gaia.entity.monster.EntityGaiaDhampir;
import gaia.entity.monster.EntityGaiaDryad;
import gaia.entity.monster.EntityGaiaDullahan;
import gaia.entity.monster.EntityGaiaDwarf;
import gaia.entity.monster.EntityGaiaEnderDragonGirl;
import gaia.entity.monster.EntityGaiaEnderEye;
import gaia.entity.monster.EntityGaiaFleshLich;
import gaia.entity.monster.EntityGaiaGelatinousSlime;
import gaia.entity.monster.EntityGaiaGoblin;
import gaia.entity.monster.EntityGaiaGoblinFeral;
import gaia.entity.monster.EntityGaiaGorgon;
import gaia.entity.monster.EntityGaiaGryphon;
import gaia.entity.monster.EntityGaiaHarpy;
import gaia.entity.monster.EntityGaiaHarpyWizard;
import gaia.entity.monster.EntityGaiaHorse;
import gaia.entity.monster.EntityGaiaHunter;
import gaia.entity.monster.EntityGaiaIllagerButler;
import gaia.entity.monster.EntityGaiaIllagerFire;
import gaia.entity.monster.EntityGaiaIllagerInquisitor;
import gaia.entity.monster.EntityGaiaKikimora;
import gaia.entity.monster.EntityGaiaKobold;
import gaia.entity.monster.EntityGaiaMandragora;
import gaia.entity.monster.EntityGaiaMatango;
import gaia.entity.monster.EntityGaiaMermaid;
import gaia.entity.monster.EntityGaiaMimic;
import gaia.entity.monster.EntityGaiaMinotaur;
import gaia.entity.monster.EntityGaiaMinotaurus;
import gaia.entity.monster.EntityGaiaMite;
import gaia.entity.monster.EntityGaiaMonoeye;
import gaia.entity.monster.EntityGaiaMummy;
import gaia.entity.monster.EntityGaiaNaga;
import gaia.entity.monster.EntityGaiaNineTails;
import gaia.entity.monster.EntityGaiaOni;
import gaia.entity.monster.EntityGaiaOrc;
import gaia.entity.monster.EntityGaiaSatyress;
import gaia.entity.monster.EntityGaiaSelkie;
import gaia.entity.monster.EntityGaiaShaman;
import gaia.entity.monster.EntityGaiaSharko;
import gaia.entity.monster.EntityGaiaSiren;
import gaia.entity.monster.EntityGaiaSludgeGirl;
import gaia.entity.monster.EntityGaiaSphinx;
import gaia.entity.monster.EntityGaiaSporeling;
import gaia.entity.monster.EntityGaiaSpriggan;
import gaia.entity.monster.EntityGaiaSuccubus;
import gaia.entity.monster.EntityGaiaToad;
import gaia.entity.monster.EntityGaiaValkyrie;
import gaia.entity.monster.EntityGaiaVampire;
import gaia.entity.monster.EntityGaiaWerecat;
import gaia.entity.monster.EntityGaiaWitch;
import gaia.entity.monster.EntityGaiaWitherCow;
import gaia.entity.monster.EntityGaiaYeti;
import gaia.entity.monster.EntityGaiaYukiOnna;
import gaia.entity.passive.EntityGaiaNPCCreeperGirl;
import gaia.entity.passive.EntityGaiaNPCEnderGirl;
import gaia.entity.passive.EntityGaiaNPCHolstaurus;
import gaia.entity.passive.EntityGaiaNPCSlimeGirl;
import gaia.entity.passive.EntityGaiaNPCTrader;
import gaia.entity.passive.EntityGaiaNPCWeresheep;
import gaia.entity.projectile.EntityGaiaProjectileBomb;
import gaia.entity.projectile.EntityGaiaProjectileBubble;
import gaia.entity.projectile.EntityGaiaProjectileMagic;
import gaia.entity.projectile.EntityGaiaProjectileMagicRandom;
import gaia.entity.projectile.EntityGaiaProjectilePoison;
import gaia.entity.projectile.EntityGaiaProjectileSmallFireball;
import gaia.entity.projectile.EntityGaiaProjectileWeb;
import gaia.entity.prop.EntityGaiaPropAntHill;
import gaia.entity.prop.EntityGaiaPropChestMimic;
import gaia.entity.prop.EntityGaiaPropFlowerCyan;
import gaia.entity.prop.EntityGaiaPropVase;
import gaia.entity.prop.EntityGaiaPropVaseNether;
import gaia.entity.prop.spawner.EntityGaiaSpawnerBeholder;
import gaia.entity.prop.spawner.EntityGaiaSpawnerEnderDragonGirl;
import gaia.entity.prop.spawner.EntityGaiaSpawnerGorgon;
import gaia.entity.prop.spawner.EntityGaiaSpawnerMinotaur;
import gaia.entity.prop.spawner.EntityGaiaSpawnerSphinx;
import gaia.entity.prop.spawner.EntityGaiaSpawnerValkyrie;
import gaia.entity.prop.spawner.EntityGaiaSpawnerVampire;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class GaiaEntities {
    private static int modEntityId = 0;
    public static final Set<EntityEntry> SPAWN_EGG_ENTITIES = ImmutableSet.of((Object)GaiaEntities.createEntityEntry("debug_mob", EntityDebugMob.class, 7316105, 9525057), (Object)GaiaEntities.createEntityEntry("ant", EntityGaiaAnt.class, 0x303030, 9073252), (Object)GaiaEntities.createEntityEntry("ant_hill", EntityGaiaPropAntHill.class, 14999207, 0x545454, false), (Object)GaiaEntities.createEntityEntry("ant_ranger", EntityGaiaAntRanger.class, 9073252, 0x303030), (Object)GaiaEntities.createEntityEntry("anubis", EntityGaiaAnubis.class, 0x353535, 11638068), (Object)GaiaEntities.createEntityEntry("arachne", EntityGaiaArachne.class, 0x3A3A3A, 11013646), (Object[])new EntityEntry[]{GaiaEntities.createEntityEntry("banshee", EntityGaiaBanshee.class, 15651560, 13021421), GaiaEntities.createEntityEntry("baphomet", EntityGaiaBaphomet.class, 3559756, 14197864), GaiaEntities.createEntityEntry("bee", EntityGaiaBee.class, 13218145, 0x353535), GaiaEntities.createEntityEntry("beholder", EntityGaiaBeholder.class, 3102548, 8567412), GaiaEntities.createEntityEntry("bone_knight", EntityGaiaBoneKnight.class, 4602533, 0xCFCFCF), GaiaEntities.createEntityEntry("butler", EntityGaiaIllagerButler.class, 9080976, 14405343), GaiaEntities.createEntityEntry("campfire", EntityGaiaPropCampfire.class, 8019770, 16766976, false), GaiaEntities.createEntityEntry("cecaelia", EntityGaiaCecaelia.class, 14374752, 14193577), GaiaEntities.createEntityEntry("centaur", EntityGaiaCentaur.class, 9260865, 0x353535), GaiaEntities.createEntityEntry("chest", EntityGaiaPropChestMimic.class, 11237677, 4274991, false), GaiaEntities.createEntityEntry("cobble_golem", EntityGaiaCobbleGolem.class, 0xAFAFAF, 0xAFAFAF), GaiaEntities.createEntityEntry("cobblestone_golem", EntityGaiaCobblestoneGolem.class, 0xAFAFAF, 0xAFAFAF), GaiaEntities.createEntityEntry("creep", EntityGaiaCreep.class, 7917159, 2053400), GaiaEntities.createEntityEntry("cyan_flower", EntityGaiaPropFlowerCyan.class, 1073920, 4045287, false), GaiaEntities.createEntityEntry("deathword", EntityGaiaDeathword.class, 12024373, 16766976), GaiaEntities.createEntityEntry("dhampir", EntityGaiaDhampir.class, 10230827, 13218145), GaiaEntities.createEntityEntry("dryad", EntityGaiaDryad.class, 10255437, 5681460), GaiaEntities.createEntityEntry("dullahan", EntityGaiaDullahan.class, 8540075, 10765613), GaiaEntities.createEntityEntry("dwarf", EntityGaiaDwarf.class, 0x969696, 15767874), GaiaEntities.createEntityEntry("ender_dragon_girl", EntityGaiaEnderDragonGirl.class, 0x303030, 14711290), GaiaEntities.createEntityEntry("ender_eye", EntityGaiaEnderEye.class, 0x1F1F1F, 51740772), GaiaEntities.createEntityEntry("flesh_lich", EntityGaiaFleshLich.class, 52428, 7969893), GaiaEntities.createEntityEntry("gelatinous_slime", EntityGaiaGelatinousSlime.class, 6595667, 0xCFCFCF), GaiaEntities.createEntityEntry("goblin", EntityGaiaGoblin.class, 7440992, 9260865), GaiaEntities.createEntityEntry("goblin_feral", EntityGaiaGoblinFeral.class, 7440992, 9051454), GaiaEntities.createEntityEntry("mite", EntityGaiaMite.class, 0x252525, 0x3A3A3A), GaiaEntities.createEntityEntry("gryphon", EntityGaiaGryphon.class, 15767874, 0xE2E2E2), GaiaEntities.createEntityEntry("harpy", EntityGaiaHarpy.class, 13218145, 10848334), GaiaEntities.createEntityEntry("harpy_wizard", EntityGaiaHarpyWizard.class, 0xDDDADB, 12229459), GaiaEntities.createEntityEntry("horse", EntityGaiaHorse.class, 0x252525, 0x3A3A3A), GaiaEntities.createEntityEntry("hunter", EntityGaiaHunter.class, 11430716, 0x353535), GaiaEntities.createEntityEntry("illager_fire", EntityGaiaIllagerFire.class, 9080976, 16761898), GaiaEntities.createEntityEntry("illager_inquisitor", EntityGaiaIllagerInquisitor.class, 9080976, 11413535), GaiaEntities.createEntityEntry("kikimora", EntityGaiaKikimora.class, 0x191919, 13876652), GaiaEntities.createEntityEntry("kobold", EntityGaiaKobold.class, 9670059, 11511745), GaiaEntities.createEntityEntry("matango", EntityGaiaMatango.class, 11211537, 0xD8D8D8), GaiaEntities.createEntityEntry("mermaid", EntityGaiaMermaid.class, 6058161, 10765613), GaiaEntities.createEntityEntry("minotaur", EntityGaiaMinotaur.class, 9260865, 13976130), GaiaEntities.createEntityEntry("minotaurus", EntityGaiaMinotaurus.class, 9260865, 0xA9A9A9), GaiaEntities.createEntityEntry("cyclops", EntityGaiaMonoeye.class, 4936602, 0x353535), GaiaEntities.createEntityEntry("mummy", EntityGaiaMummy.class, 14473153, 13218145), GaiaEntities.createEntityEntry("naga", EntityGaiaNaga.class, 2735189, 13415999), GaiaEntities.createEntityEntry("nine_tails", EntityGaiaNineTails.class, 0xB43434, 13218145), GaiaEntities.createEntityEntry("oni", EntityGaiaOni.class, 9121837, 13218145), GaiaEntities.createEntityEntry("orc", EntityGaiaOrc.class, 7440992, 12637846), GaiaEntities.createEntityEntry("satyress", EntityGaiaSatyress.class, 7371599, 10765613), GaiaEntities.createEntityEntry("selkie", EntityGaiaSelkie.class, 9082818, 13488612), GaiaEntities.createEntityEntry("shaman", EntityGaiaShaman.class, 11430716, 5681460), GaiaEntities.createEntityEntry("sharko", EntityGaiaSharko.class, 8692888, 6058161), GaiaEntities.createEntityEntry("siren", EntityGaiaSiren.class, 2735189, 4759774), GaiaEntities.createEntityEntry("sludge_girl", EntityGaiaSludgeGirl.class, 6595667, 7715172), GaiaEntities.createEntityEntry("sphinx", EntityGaiaSphinx.class, 15767874, 0x353535), GaiaEntities.createEntityEntry("spriggan", EntityGaiaSpriggan.class, 8151614, 12770725), GaiaEntities.createEntityEntry("sporeling", EntityGaiaSporeling.class, 12789798, 9925201), GaiaEntities.createEntityEntry("succubus", EntityGaiaSuccubus.class, 0x3E3E3E, 13218145), GaiaEntities.createEntityEntry("toad", EntityGaiaToad.class, 3497259, 7839578), GaiaEntities.createEntityEntry("valkyrie", EntityGaiaValkyrie.class, 13218145, 13976130), GaiaEntities.createEntityEntry("vase", EntityGaiaPropVase.class, 0x949494, 0x545454, false), GaiaEntities.createEntityEntry("vase_nether", EntityGaiaPropVaseNether.class, 2690320, 4596009, false), GaiaEntities.createEntityEntry("vampire", EntityGaiaVampire.class, 12726305, 13218145), GaiaEntities.createEntityEntry("werecat", EntityGaiaWerecat.class, 8027786, 0xDDDADB), GaiaEntities.createEntityEntry("witch", EntityGaiaWitch.class, 0x303030, 9715131), GaiaEntities.createEntityEntry("wither_cow", EntityGaiaWitherCow.class, 0x585D5D, 0xFFFFFF), GaiaEntities.createEntityEntry("yeti", EntityGaiaYeti.class, 0xFAFAFA, 0x787878), GaiaEntities.createEntityEntry("yuki-onna", EntityGaiaYukiOnna.class, 6781114, 13817330)});

    private GaiaEntities() {
    }

    private static <T extends Entity> EntityEntry createEntityEntry(String name, Class<T> cls, int primaryColorIn, int secondaryColorIn) {
        return GaiaEntities.createEntityEntry(name, cls, primaryColorIn, secondaryColorIn, true);
    }

    private static <T extends Entity> EntityEntry createEntityEntry(String name, Class<T> cls, int primaryColorIn, int secondaryColorIn, boolean sendVelocityUpdates) {
        EntityEntryBuilder builder = EntityEntryBuilder.create();
        builder.entity(cls);
        builder.name("grimoireofgaia." + name);
        builder.id(new ResourceLocation("grimoireofgaia", name), modEntityId++);
        builder.tracker(64, 3, sendVelocityUpdates);
        builder.egg(primaryColorIn, secondaryColorIn);
        return builder.build();
    }

    @Mod.EventBusSubscriber(modid="grimoireofgaia")
    public static class RegistrationHandler {
        @SubscribeEvent
        public static void registerEntities(RegistryEvent.Register<EntityEntry> event) {
            Gaia.LOGGER.info("Registering entities...");
            IForgeRegistry registry = event.getRegistry();
            RegistrationHandler.initNoSpawnEggEntities((IForgeRegistry<EntityEntry>)registry);
            for (EntityEntry entry : SPAWN_EGG_ENTITIES) {
                registry.register((IForgeRegistryEntry)entry);
            }
            Gaia.LOGGER.info("Entity registration complete.");
        }

        private static void initNoSpawnEggEntities(IForgeRegistry<EntityEntry> registry) {
            RegistrationHandler.createEntityEntry("gorgon", EntityGaiaGorgon.class, registry);
            RegistrationHandler.createEntityEntry("creeper_girl", EntityGaiaNPCCreeperGirl.class, registry);
            RegistrationHandler.createEntityEntry("slime_girl", EntityGaiaNPCSlimeGirl.class, registry);
            RegistrationHandler.createEntityEntry("ender_girl", EntityGaiaNPCEnderGirl.class, registry);
            RegistrationHandler.createEntityEntry("trader", EntityGaiaNPCTrader.class, registry);
            RegistrationHandler.createEntityEntry("holstaurus", EntityGaiaNPCHolstaurus.class, registry);
            RegistrationHandler.createEntityEntry("weresheep", EntityGaiaNPCWeresheep.class, registry);
            RegistrationHandler.createEntityEntry("mandragora", EntityGaiaMandragora.class, registry);
            RegistrationHandler.createEntityEntry("mimic", EntityGaiaMimic.class, registry);
            RegistrationHandler.createEntityEntry("spawner_beholder", EntityGaiaSpawnerBeholder.class, registry);
            RegistrationHandler.createEntityEntry("spawner_ender_dragon_girl", EntityGaiaSpawnerEnderDragonGirl.class, registry);
            RegistrationHandler.createEntityEntry("spawner_gorgon", EntityGaiaSpawnerGorgon.class, registry);
            RegistrationHandler.createEntityEntry("spawner_minotaur", EntityGaiaSpawnerMinotaur.class, registry);
            RegistrationHandler.createEntityEntry("spawner_sphinx", EntityGaiaSpawnerSphinx.class, registry);
            RegistrationHandler.createEntityEntry("spawner_valkyrie", EntityGaiaSpawnerValkyrie.class, registry);
            RegistrationHandler.createEntityEntry("spawner_vampire", EntityGaiaSpawnerVampire.class, registry);
            RegistrationHandler.createEntityEntry("bomb", EntityGaiaProjectileBomb.class, registry, 3);
            RegistrationHandler.createEntityEntry("bubble", EntityGaiaProjectileBubble.class, registry, 3);
            RegistrationHandler.createEntityEntry("magic", EntityGaiaProjectileMagic.class, registry, 3);
            RegistrationHandler.createEntityEntry("magic_random", EntityGaiaProjectileMagicRandom.class, registry, 3);
            RegistrationHandler.createEntityEntry("poison", EntityGaiaProjectilePoison.class, registry, 3);
            RegistrationHandler.createEntityEntry("small_fireball", EntityGaiaProjectileSmallFireball.class, registry, 3);
            RegistrationHandler.createEntityEntry("web", EntityGaiaProjectileWeb.class, registry, 3);
        }

        private static <T extends Entity> void createEntityEntry(String name, Class<T> cls, IForgeRegistry<EntityEntry> registry) {
            RegistrationHandler.createEntityEntry(name, cls, registry, 3);
        }

        private static <T extends Entity> void createEntityEntry(String name, Class<T> cls, IForgeRegistry<EntityEntry> registry, int updateFrequency) {
            EntityEntryBuilder builder = EntityEntryBuilder.create();
            builder.entity(cls);
            builder.name("grimoireofgaia." + name);
            builder.id(new ResourceLocation("grimoireofgaia", name), modEntityId++);
            builder.tracker(64, updateFrequency, true);
            registry.register((IForgeRegistryEntry)builder.build());
        }
    }
}

