/*
 * Decompiled with CFR 0.152.
 */
package gaia.renderer.entity;

import gaia.entity.monster.EntityGaiaGoblinFeral;
import gaia.model.ModelGaiaGoblinFeral;
import gaia.renderer.entity.layers.LayerGaiaHeldItem;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderGaiaGoblinFeral
extends RenderLiving<EntityLiving> {
    private static final ResourceLocation texture01 = new ResourceLocation("grimoireofgaia", "textures/entity/goblin_feral01.png");
    private static final ResourceLocation texture02 = new ResourceLocation("grimoireofgaia", "textures/entity/alternate/goblin_feral02.png");
    private static final ResourceLocation texture03 = new ResourceLocation("grimoireofgaia", "textures/entity/alternate/goblin_feral03.png");

    public RenderGaiaGoblinFeral(RenderManager renderManager, float shadowSize) {
        super(renderManager, (ModelBase)new ModelGaiaGoblinFeral(), shadowSize);
        this.func_177094_a(LayerGaiaHeldItem.right(this, this.getModel().getRightArm()));
        this.func_177094_a(LayerGaiaHeldItem.left(this, this.getModel().getLeftArm()));
    }

    protected void preRenderCallback(EntityLiving entitylivingbaseIn, float partialTickTime) {
        this.preRenderCallback((EntityGaiaGoblinFeral)entitylivingbaseIn, partialTickTime);
    }

    protected int getColorMultiplier(EntityLiving entitylivingbaseIn, float lightBrightness, float partialTickTime) {
        return this.getColorMultiplier((EntityGaiaGoblinFeral)entitylivingbaseIn, lightBrightness, partialTickTime);
    }

    protected void preRenderCallback(EntityGaiaGoblinFeral entitylivingbaseIn, float partialTickTime) {
        float f = entitylivingbaseIn.getCreeperFlashIntensity(partialTickTime);
        float f1 = 1.0f + MathHelper.func_76126_a((float)(f * 100.0f)) * f * 0.01f;
        f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
        f *= f;
        f *= f;
        float f2 = (1.0f + f * 0.4f) * f1;
        float f3 = (1.0f + f * 0.1f) / f1;
        GlStateManager.func_179152_a((float)f2, (float)f3, (float)f2);
    }

    protected int getColorMultiplier(EntityGaiaGoblinFeral entitylivingbaseIn, float lightBrightness, float partialTickTime) {
        float f = entitylivingbaseIn.getCreeperFlashIntensity(partialTickTime);
        if ((int)(f * 10.0f) % 2 == 0) {
            return 0;
        }
        int i = (int)(f * 0.2f * 255.0f);
        i = MathHelper.func_76125_a((int)i, (int)0, (int)255);
        return i << 24 | 0x30FFFFFF;
    }

    private ModelGaiaGoblinFeral getModel() {
        return (ModelGaiaGoblinFeral)this.func_177087_b();
    }

    public void func_82422_c() {
        GlStateManager.func_179109_b((float)0.0f, (float)0.1875f, (float)0.0f);
    }

    protected ResourceLocation getEntityTexture(EntityLiving entity) {
        return this.getTexture((EntityGaiaGoblinFeral)entity);
    }

    private ResourceLocation getTexture(EntityGaiaGoblinFeral entity) {
        switch (entity.getTextureType()) {
            case 0: {
                return texture01;
            }
            case 1: {
                return texture02;
            }
            case 2: {
                return texture03;
            }
        }
        return texture01;
    }
}

