/*
 * Decompiled with CFR 0.152.
 */
package trinity.blocks;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import trinity.config.TrinityConfig;
import trinity.entities.EntityNuclearCloud;
import trinity.entities.EntityNuclearExplosion;
import trinity.explosion.ExplosionNukeGeneric;

public class AntimatterBomb
extends Block {
    public int blastRadius;

    public AntimatterBomb(String nameIn, Material material, int blastRadius) {
        super(material);
        this.blastRadius = blastRadius;
        this.func_149663_c("trinity." + nameIn);
        this.setRegistryName(new ResourceLocation("trinity", nameIn));
        this.setHarvestLevel("Pickaxe", 1);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(2.0f);
    }

    public void func_190948_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add("Crater Radius: " + this.blastRadius);
        tooltip.add("Thermal Radius: " + (double)this.blastRadius * TrinityConfig.fallout_multiplier * 2.0);
        tooltip.add(TextFormatting.DARK_BLUE + "Leaves no radioactivity behind.");
        tooltip.add(TextFormatting.DARK_RED + "Danger: Will explode if exposed to explosions!");
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        AntimatterBomb.AtomicBomb(world, pos, this.blastRadius);
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        AntimatterBomb.AtomicBomb(world, pos, this.blastRadius);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (world.func_175640_z(pos)) {
            world.func_175684_a(pos, (Block)this, 600);
        }
    }

    public static void AtomicBomb(World world, BlockPos pos, int blastRadius) {
        Chunk chunk = world.func_175726_f(pos);
        EntityNuclearCloud entity2 = new EntityNuclearCloud(world, 1000, (float)(Math.min(blastRadius, TrinityConfig.max_radius) * 2) * 0.005f);
        entity2.field_70165_t = pos.func_177958_n();
        entity2.field_70163_u = pos.func_177956_o();
        entity2.field_70161_v = pos.func_177952_p();
        world.func_72838_d((Entity)entity2);
        world.func_175698_g(pos);
        ExplosionNukeGeneric.irradiate(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), Math.min(blastRadius, TrinityConfig.max_radius) * 6);
        world.func_72838_d((Entity)EntityNuclearExplosion.statFacAntimatter(world, Math.min(blastRadius, TrinityConfig.max_radius), (double)pos.func_177958_n() + 0.0, (double)pos.func_177956_o() + 0.0, (double)pos.func_177952_p() + 0.0));
    }
}

