/*
 * Decompiled with CFR 0.152.
 */
package trinity.blocks;

import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.DimensionManager;
import trinity.entities.EntityBlackHole;

public class ExoticBomb
extends Block {
    public int blastRadius;

    public ExoticBomb(String nameIn, Material material, int blastRadius) {
        super(material);
        this.blastRadius = blastRadius;
        this.func_149663_c("trinity." + nameIn);
        this.setRegistryName(new ResourceLocation("trinity", nameIn));
        this.setHarvestLevel("Pickaxe", 1);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(2.0f);
    }

    public void func_190948_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(TextFormatting.DARK_BLUE + "Creates a wormhole to a random location upon detonation.");
        tooltip.add(TextFormatting.DARK_RED + "Warning: wormholes are one-way, and may leave you VERY far from home!");
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        ExoticBomb.AtomicBomb(world, pos, this.blastRadius);
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        ExoticBomb.AtomicBomb(world, pos, this.blastRadius);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (world.func_175640_z(pos)) {
            world.func_175684_a(pos, (Block)this, 600);
        }
    }

    public static void AtomicBomb(World world, BlockPos pos, int blastRadius) {
        Chunk chunk = world.func_175726_f(pos);
        int[] dimension = DimensionManager.getRegisteredDimensions().values().stream().flatMap(Collection::stream).mapToInt(Integer::intValue).toArray();
        Random rand = new Random();
        int randomDim = ExoticBomb.getRandom(dimension);
        int randomX = rand.nextInt(50000000) - 30000000;
        int randomY = rand.nextInt(256);
        int randomZ = rand.nextInt(50000000) - 30000000;
        EntityBlackHole entity2 = new EntityBlackHole(world, 5.0f, randomDim, randomX, randomY, randomZ);
        entity2.field_70165_t = pos.func_177958_n();
        entity2.field_70163_u = pos.func_177956_o();
        entity2.field_70161_v = pos.func_177952_p();
        world.func_72838_d((Entity)entity2);
        world.func_175698_g(pos);
    }

    public static int getRandom(int[] array) {
        int rnd = new Random().nextInt(array.length);
        return array[rnd];
    }
}

