/*
 * Decompiled with CFR 0.152.
 */
package trinity.blocks;

import java.util.List;
import javax.annotation.Nullable;
import nc.capability.radiation.source.IRadiationSource;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import trinity.config.TrinityConfig;
import trinity.entities.EntityNuclearCloud;
import trinity.entities.EntityNuclearExplosion;
import trinity.entities.EntityThermonuclearBlast;
import trinity.explosion.ExplosionNukeGeneric;
import trinity.util.ThermonuclearBomb;

public class NuclearCore
extends Block {
    public int blastRadius;
    public boolean salted;

    public NuclearCore(String nameIn, Material material, int blastRadius, boolean salted) {
        super(material);
        this.blastRadius = blastRadius;
        this.salted = salted;
        this.func_149663_c("trinity." + nameIn);
        this.setRegistryName(new ResourceLocation("trinity", nameIn));
        this.setHarvestLevel("Pickaxe", 1);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(2.0f);
    }

    public void func_190948_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (this.salted) {
            tooltip.add("Crater Radius: " + (double)this.blastRadius * 0.75);
        }
        if (!this.salted) {
            tooltip.add("Crater Radius: " + this.blastRadius);
        }
        tooltip.add("Wasteland Radius: " + (double)this.blastRadius * TrinityConfig.fallout_multiplier);
        if (this.salted) {
            tooltip.add(TextFormatting.DARK_RED + "Danger: Leaves extremely radioactive fallout behind!");
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (world.func_175640_z(pos)) {
            NuclearCore.AtomicBomb(world, pos, this.blastRadius, this.salted);
        }
    }

    public static void AtomicBomb(World world, BlockPos pos, int blastRadius, boolean salted) {
        Chunk chunk = world.func_175726_f(pos);
        if (ThermonuclearBomb.ThermonuclearCheck(world, pos) && TrinityConfig.thermonuclear) {
            int X = pos.func_177958_n();
            int Y = pos.func_177956_o();
            int Z = pos.func_177952_p();
            for (int x = X - 3; x <= X + 3; ++x) {
                for (int y = Y - 3; y <= Y + 3; ++y) {
                    for (int z = Z - 3; z <= Z + 3; ++z) {
                        BlockPos clear = new BlockPos(x, y, z);
                        Block block = world.func_180495_p(clear).func_177230_c();
                        if (block == Blocks.field_150357_h || clear.func_177956_o() > 1) continue;
                        world.func_175698_g(clear);
                    }
                }
            }
            double multiplier = ThermonuclearBomb.ThermonuclearMultiplier(world, pos, false);
            int radius = (int)((double)Math.min(blastRadius, TrinityConfig.max_radius) * multiplier);
            int salt = (int)ThermonuclearBomb.ThermonuclearMultiplier(world, pos, true);
            ExplosionNukeGeneric.irradiate(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), Math.min(radius, TrinityConfig.max_radius) * 2);
            EntityNuclearCloud entity2 = new EntityNuclearCloud(world, 1000, (float)(radius * 2) * 0.005f);
            entity2.field_70165_t = pos.func_177958_n();
            entity2.field_70163_u = pos.func_177956_o();
            entity2.field_70161_v = pos.func_177952_p();
            world.func_72838_d((Entity)entity2);
            world.func_72838_d((Entity)EntityNuclearExplosion.statFacNoRad(world, Math.min((int)((float)blastRadius * 1.5f), TrinityConfig.max_radius), (double)pos.func_177958_n() + 0.0, (double)pos.func_177956_o() + 0.0, (double)pos.func_177952_p() + 0.0));
            EntityThermonuclearBlast blast = new EntityThermonuclearBlast(world);
            blast.field_70165_t = pos.func_177958_n();
            blast.field_70163_u = pos.func_177956_o();
            blast.field_70161_v = pos.func_177952_p();
            blast.setScale(radius);
            blast.setIntensity(salt);
            world.func_72838_d((Entity)blast);
            return;
        }
        EntityNuclearCloud entity2 = new EntityNuclearCloud(world, 1000, (float)(Math.min(blastRadius, TrinityConfig.max_radius) * 2) * 0.005f);
        entity2.field_70165_t = pos.func_177958_n();
        entity2.field_70163_u = pos.func_177956_o();
        entity2.field_70161_v = pos.func_177952_p();
        world.func_72838_d((Entity)entity2);
        world.func_175698_g(pos);
        ExplosionNukeGeneric.irradiate(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), Math.min(blastRadius, TrinityConfig.max_radius) * 2);
        if (!salted) {
            world.func_72838_d((Entity)EntityNuclearExplosion.statFac(world, Math.min(blastRadius, TrinityConfig.max_radius), (double)pos.func_177958_n() + 0.0, (double)pos.func_177956_o() + 0.0, (double)pos.func_177952_p() + 0.0));
        } else if (salted) {
            IRadiationSource chunkRadation;
            if ((chunk != null || chunk.hasCapability(IRadiationSource.CAPABILITY_RADIATION_SOURCE, null)) && (chunkRadation = (IRadiationSource)chunk.getCapability(IRadiationSource.CAPABILITY_RADIATION_SOURCE, null)) != null) {
                double promptRads = TrinityConfig.salted_burst;
                if (chunkRadation.getRadiationBuffer() < promptRads) {
                    chunkRadation.setRadiationBuffer(promptRads);
                } else {
                    chunkRadation.setRadiationBuffer(chunkRadation.getRadiationLevel() + promptRads);
                }
            }
            world.func_72838_d((Entity)EntityNuclearExplosion.statFacSalted(world, Math.min(blastRadius, TrinityConfig.max_radius), (double)pos.func_177958_n() + 0.0, (double)pos.func_177956_o() + 0.0, (double)pos.func_177952_p() + 0.0));
        }
    }
}

