/*
 * Decompiled with CFR 0.152.
 */
package trinity.entities;

import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityBlackHole
extends Entity {
    public static final DataParameter<Float> SCALE = EntityDataManager.func_187226_a(EntityBlackHole.class, (DataSerializer)DataSerializers.field_187193_c);
    public static final DataParameter<Integer> X = EntityDataManager.func_187226_a(EntityBlackHole.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> Y = EntityDataManager.func_187226_a(EntityBlackHole.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> Z = EntityDataManager.func_187226_a(EntityBlackHole.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> DIM = EntityDataManager.func_187226_a(EntityBlackHole.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final Random random = new Random();

    public EntityBlackHole(World worldIn) {
        super(worldIn);
        this.field_70158_ak = true;
        this.field_70178_ae = true;
    }

    public EntityBlackHole(World w, float scale, int dim, int x, int y, int z) {
        this(w);
        this.func_184212_Q().func_187227_b(SCALE, (Object)Float.valueOf(scale));
        this.func_184212_Q().func_187227_b(X, (Object)x);
        this.func_184212_Q().func_187227_b(Y, (Object)y);
        this.func_184212_Q().func_187227_b(Z, (Object)z);
        this.func_184212_Q().func_187227_b(DIM, (Object)dim);
    }

    public void func_70071_h_() {
        float scale = ((Float)this.func_184212_Q().func_187225_a(SCALE)).floatValue();
        EntityBlackHole.gravity(this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, (int)Math.ceil(scale * 15.0f));
    }

    public static void gravity(World world, int x, int y, int z, int radius) {
        double wat = radius;
        int i = MathHelper.func_76128_c((double)((double)x - wat - 1.0));
        int j = MathHelper.func_76128_c((double)((double)x + wat + 1.0));
        int k = MathHelper.func_76128_c((double)((double)y - wat - 1.0));
        int i2 = MathHelper.func_76128_c((double)((double)y + wat + 1.0));
        int l = MathHelper.func_76128_c((double)((double)z - wat - 1.0));
        int j2 = MathHelper.func_76128_c((double)((double)z + wat + 1.0));
        List list = world.func_72839_b(null, new AxisAlignedBB((double)i, (double)k, (double)l, (double)j, (double)i2, (double)j2));
        for (int i1 = 0; i1 < list.size(); ++i1) {
            double d7;
            double d6;
            double d5;
            double d9;
            double d4;
            Entity entity = (Entity)list.get(i1);
            if (entity instanceof EntityBlackHole || !((d4 = entity.func_70011_f((double)x, (double)y, (double)z) / (double)radius) <= 1.0) || !((d9 = (double)MathHelper.func_76133_a((double)((d5 = entity.field_70165_t - (double)x) * d5 + (d6 = entity.field_70163_u + (double)entity.func_70047_e() - (double)y) * d6 + (d7 = entity.field_70161_v - (double)z) * d7))) < wat) || entity instanceof EntityPlayer) continue;
            d5 /= d9;
            d6 /= d9;
            d7 /= d9;
            if (entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75098_d) continue;
            double d8 = 0.125 + random.nextDouble() * 0.25;
            entity.field_70159_w -= d5 * d8;
            entity.field_70181_x -= d6 * d8;
            entity.field_70179_y -= d7 * d8;
        }
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(SCALE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(DIM, (Object)0);
        this.field_70180_af.func_187214_a(X, (Object)0);
        this.field_70180_af.func_187214_a(Y, (Object)0);
        this.field_70180_af.func_187214_a(Z, (Object)0);
    }

    protected void func_70037_a(NBTTagCompound p_70037_1_) {
        this.setScale(p_70037_1_.func_74760_g("scale"));
        this.setScale(p_70037_1_.func_74762_e("dimension"));
        this.setScale(p_70037_1_.func_74762_e("X"));
        this.setScale(p_70037_1_.func_74762_e("Y"));
        this.setScale(p_70037_1_.func_74762_e("Z"));
    }

    protected void func_70014_b(NBTTagCompound p_70014_1_) {
        p_70014_1_.func_74776_a("scale", this.getScale());
        p_70014_1_.func_74768_a("dimension", this.getDimension());
        p_70014_1_.func_74768_a("X", this.getX());
        p_70014_1_.func_74768_a("Y", this.getY());
        p_70014_1_.func_74768_a("Z", this.getZ());
    }

    public void setScale(float i) {
        this.field_70180_af.func_187227_b(SCALE, (Object)Float.valueOf(i));
    }

    public float getScale() {
        float scale = ((Float)this.field_70180_af.func_187225_a(SCALE)).floatValue();
        return scale == 0.0f ? 1.0f : scale;
    }

    public void setDimension(int i) {
        this.field_70180_af.func_187227_b(DIM, (Object)i);
    }

    public int getDimension() {
        int dim = (Integer)this.field_70180_af.func_187225_a(DIM);
        return dim == 0 ? 1 : dim;
    }

    public void setX(int i) {
        this.field_70180_af.func_187227_b(X, (Object)i);
    }

    public int getX() {
        int x = (Integer)this.field_70180_af.func_187225_a(X);
        return x == 0 ? 1 : x;
    }

    public void setY(int i) {
        this.field_70180_af.func_187227_b(Y, (Object)i);
    }

    public int getY() {
        int y = (Integer)this.field_70180_af.func_187225_a(Y);
        return y == 0 ? 1 : y;
    }

    public void setZ(int i) {
        this.field_70180_af.func_187227_b(Z, (Object)i);
    }

    public int getZ() {
        int z = (Integer)this.field_70180_af.func_187225_a(Z);
        return z == 0 ? 1 : z;
    }
}

