/*
 * Decompiled with CFR 0.152.
 */
package trinity.entities;

import nc.init.NCBlocks;
import nc.worldgen.biome.NCBiomes;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockCactus;
import net.minecraft.block.BlockMobSpawner;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeOcean;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import trinity.config.TrinityConfig;
import trinity.handler.INuclearEffect;
import trinity.handler.Vec3;
import trinity.init.ModBlocks;
import trinity.world.TrinityBiomes;

public class EntityFalloutRain
extends Entity
implements INuclearEffect {
    private static final DataParameter<Integer> SCALE = EntityDataManager.func_187226_a(EntityFalloutRain.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> SALTED = EntityDataManager.func_187226_a(EntityFalloutRain.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> THERMONUCLEAR = EntityDataManager.func_187226_a(EntityFalloutRain.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> INTENSITY = EntityDataManager.func_187226_a(EntityFalloutRain.class, (DataSerializer)DataSerializers.field_187192_b);
    public int revProgress;
    public int radProgress;
    private boolean salted;
    private boolean thermonuclear;

    public EntityFalloutRain(World p_i1582_1_) {
        super(p_i1582_1_);
        this.func_70105_a(4.0f, 20.0f);
        this.field_70158_ak = true;
        this.field_70178_ae = true;
    }

    public EntityFalloutRain(World p_i1582_1_, boolean salt) {
        super(p_i1582_1_);
        this.func_70105_a(4.0f, 20.0f);
        this.field_70158_ak = true;
        this.field_70178_ae = true;
        this.salted = salt;
    }

    public EntityFalloutRain(World p_i1582_1_, int maxAge) {
        super(p_i1582_1_);
        this.func_70105_a(4.0f, 20.0f);
        this.field_70158_ak = true;
        this.field_70178_ae = true;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        double X = this.field_70165_t;
        double X2 = MathHelper.func_76128_c((double)(X - (double)this.getScale() - 1.0));
        double X3 = MathHelper.func_76128_c((double)(X + (double)this.getScale() - 1.0));
        double Y = this.field_70163_u;
        double Y2 = MathHelper.func_76128_c((double)(Y - (double)this.getScale() - 1.0));
        double Y3 = MathHelper.func_76128_c((double)(Y + (double)this.getScale() - 1.0));
        double Z = this.field_70161_v;
        double Z2 = MathHelper.func_76128_c((double)(Z - (double)this.getScale() - 1.0));
        double Z3 = MathHelper.func_76128_c((double)(Z + (double)this.getScale() - 1.0));
        AxisAlignedBB bb = new AxisAlignedBB(X2, Y2, Z2, X3, Y3, Z3);
        return bb;
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            for (int i = 0; i < TrinityConfig.fallout_speed; ++i) {
                Vec3 vec = Vec3.createVectorHelper((double)this.radProgress * 0.5, 0.0, 0.0);
                double circum = (double)(this.radProgress * 2) * Math.PI * 2.0;
                if (circum == 0.0) {
                    circum = 1.0;
                }
                double part = 360.0 / circum;
                vec.rotateAroundY((float)(part * (double)this.revProgress));
                int x = (int)(this.field_70165_t + vec.xCoord);
                int z = (int)(this.field_70161_v + vec.zCoord);
                double dist = (double)(this.radProgress * 100 / this.getScale()) * 0.5;
                pos.func_189532_c((double)x, this.field_70163_u, (double)z);
                this.contaminate(pos, dist);
                ++this.revProgress;
                if ((double)this.revProgress > circum) {
                    this.revProgress = 0;
                    ++this.radProgress;
                }
                if (!((double)this.radProgress > (double)this.getScale() * 2.0)) continue;
                this.func_70106_y();
            }
        }
    }

    private void contaminate(BlockPos.MutableBlockPos pos, double dist) {
        int depth = 0;
        int topBlock = this.field_70170_p.func_175672_r((BlockPos)pos).func_177956_o();
        for (int y = topBlock + 35; y >= topBlock - 10; --y) {
            BlockPos up;
            Chunk chunk;
            pos.func_185336_p(y);
            IBlockState b = this.field_70170_p.func_180495_p((BlockPos)pos);
            if (dist <= 100.0 / TrinityConfig.fallout_multiplier && !((chunk = this.field_70170_p.func_72964_e(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4)).func_177411_a((BlockPos)pos, this.field_70170_p.func_72959_q()) instanceof BiomeOcean)) {
                chunk.func_76605_m()[(pos.func_177952_p() & 0xF) << 4 | pos.func_177958_n() & 0xF] = (byte)Biome.func_185362_a((Biome)TrinityBiomes.NUCLEAR_CRATER);
                chunk.func_177427_f(true);
            }
            if (dist > 100.0 / TrinityConfig.fallout_multiplier) {
                chunk = this.field_70170_p.func_72964_e(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
                if (chunk.func_177411_a((BlockPos)pos, this.field_70170_p.func_72959_q()) instanceof BiomeOcean) {
                    chunk.func_76605_m()[(pos.func_177952_p() & 0xF) << 4 | pos.func_177958_n() & 0xF] = (byte)Biome.func_185362_a((Biome)TrinityBiomes.CONTAMINATED_OCEAN);
                    chunk.func_177427_f(true);
                } else if (!(chunk.func_177411_a((BlockPos)pos, this.field_70170_p.func_72959_q()) instanceof BiomeOcean) && chunk.func_177411_a((BlockPos)pos, this.field_70170_p.func_72959_q()) != TrinityBiomes.CONTAMINATED_OCEAN) {
                    chunk.func_76605_m()[(pos.func_177952_p() & 0xF) << 4 | pos.func_177958_n() & 0xF] = (byte)Biome.func_185362_a((Biome)NCBiomes.NUCLEAR_WASTELAND);
                    chunk.func_177427_f(true);
                }
            }
            if (b.func_185904_a() == Material.field_151579_a) continue;
            if (b.func_185904_a() == Material.field_151597_y || b.func_185904_a() == Material.field_151596_z || b.func_185904_a() == Material.field_151588_w) {
                this.field_70170_p.func_175698_g((BlockPos)pos);
            }
            if (b.func_177230_c().isFlammable((IBlockAccess)this.field_70170_p, (BlockPos)pos, EnumFacing.UP) && b.func_185904_a() != Material.field_151584_j) {
                if (dist < 65.0) {
                    if (this.field_70146_Z.nextInt(10) == 0) {
                        this.field_70170_p.func_175656_a(pos.func_177982_a(0, 1, 0), Blocks.field_150480_ab.func_176223_P());
                    } else {
                        this.field_70170_p.func_175698_g((BlockPos)pos);
                    }
                }
                if (dist > 65.0 && dist < 70.0) {
                    this.field_70170_p.func_175698_g(pos.func_177982_a(0, 1, 0));
                }
            }
            if (b.func_185904_a() == Material.field_151584_j || b.func_177230_c() instanceof BlockBush || b.func_177230_c() instanceof BlockMobSpawner) {
                this.field_70170_p.func_175698_g((BlockPos)pos);
                continue;
            }
            if (b.func_185904_a() == Material.field_151577_b) {
                up = pos.func_177982_a(0, 1, 0);
                if (this.field_70170_p.func_180495_p(up).func_185904_a() == Material.field_151585_k) {
                    this.field_70170_p.func_175698_g(up);
                }
                if (this.getThermonuclear() && this.getIntensity() > 0) {
                    int chance = this.field_70146_Z.nextInt(12);
                    if (chance < this.getIntensity() && chance > 0) {
                        this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.radioactive_earth2.func_176223_P());
                    } else {
                        this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.radioactive_earth.func_176223_P());
                    }
                }
                if (this.getSalted()) {
                    this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.radioactive_earth.func_176223_P());
                    return;
                }
                this.field_70170_p.func_175656_a((BlockPos)pos, NCBlocks.wasteland_earth.func_176223_P());
                return;
            }
            if (b.func_177230_c() == Blocks.field_150391_bh) {
                if (this.getThermonuclear() && this.getIntensity() > 0) {
                    int chance = this.field_70146_Z.nextInt(12);
                    if (chance < this.getIntensity() && chance > 0) {
                        this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.radioactive_earth2.func_176223_P());
                    } else {
                        this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.radioactive_earth.func_176223_P());
                    }
                }
                if (this.getSalted()) {
                    this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.radioactive_earth.func_176223_P());
                    return;
                }
                this.field_70170_p.func_175656_a((BlockPos)pos, NCBlocks.wasteland_earth.func_176223_P());
                return;
            }
            if (b.func_185904_a() == Material.field_151578_c) {
                up = pos.func_177982_a(0, 1, 0);
                if (++depth < 2 && this.field_70170_p.func_180495_p(up).func_185904_a() == Material.field_151585_k) {
                    this.field_70170_p.func_175698_g(up);
                }
                if (this.getThermonuclear() && this.getIntensity() > 0) {
                    int chance = this.field_70146_Z.nextInt(12);
                    if (chance < this.getIntensity() && chance > 0) {
                        this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.radioactive_earth2.func_176223_P());
                    } else {
                        this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.radioactive_earth.func_176223_P());
                    }
                }
                if (this.getSalted()) {
                    this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.radioactive_earth.func_176223_P());
                    return;
                }
                this.field_70170_p.func_175656_a((BlockPos)pos, NCBlocks.wasteland_earth.func_176223_P());
                return;
            }
            if (b.func_177230_c() == Blocks.field_150354_m) {
                if (dist < 30.0) {
                    up = new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p());
                    if (this.field_70170_p.func_175623_d(up)) {
                        this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.trinitite.func_176223_P());
                        return;
                    }
                    return;
                }
                if (this.getThermonuclear() && this.getIntensity() > 0) {
                    int chance = this.field_70146_Z.nextInt(12);
                    if (chance < this.getIntensity() && chance > 0) {
                        this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.salted_sand2.func_176223_P());
                    } else {
                        this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.salted_sand.func_176223_P());
                    }
                }
                if (!this.getSalted() || !(dist >= 30.0)) continue;
                this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.salted_sand.func_176223_P());
                continue;
            }
            if (b.func_177230_c() == Blocks.field_150435_aG && dist < 65.0) {
                this.field_70170_p.func_175656_a((BlockPos)pos, Blocks.field_150405_ch.func_176223_P());
                return;
            }
            if (b.func_177230_c() == NCBlocks.wasteland_earth) {
                if (this.getThermonuclear() && this.getIntensity() > 0) {
                    int chance = this.field_70146_Z.nextInt(12);
                    if (chance <= this.getIntensity() && chance > 0) {
                        this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.radioactive_earth2.func_176223_P());
                    } else {
                        this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.radioactive_earth.func_176223_P());
                    }
                }
                if (this.getSalted()) {
                    this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.radioactive_earth.func_176223_P());
                }
                return;
            }
            if (b.func_177230_c() instanceof BlockFluidClassic) break;
            if (b.func_177230_c() == Blocks.field_150341_Y) {
                this.field_70170_p.func_175656_a((BlockPos)pos, Blocks.field_150347_e.func_176223_P());
                return;
            }
            if (b.func_185904_a() == Material.field_151575_d) {
                if (dist < 65.0) {
                    if (this.field_70146_Z.nextInt(10) == 0) {
                        this.field_70170_p.func_175656_a((BlockPos)pos, Blocks.field_150480_ab.func_176223_P());
                    } else {
                        this.field_70170_p.func_175698_g((BlockPos)pos);
                    }
                    return;
                }
                if (!(dist > 65.0) || !(dist < 70.0)) continue;
                this.field_70170_p.func_175698_g((BlockPos)pos);
                return;
            }
            if (b.func_185904_a() == Material.field_151570_A && dist < 65.0) {
                this.field_70170_p.func_175656_a((BlockPos)pos, Blocks.field_150480_ab.func_176223_P());
                continue;
            }
            if (b.func_185904_a() == Material.field_151572_C) {
                if (dist < 65.0) {
                    this.field_70170_p.func_175656_a((BlockPos)pos, Blocks.field_150480_ab.func_176223_P());
                    continue;
                }
                this.field_70170_p.func_175698_g((BlockPos)pos);
                continue;
            }
            if (b.func_177230_c() instanceof BlockCactus && dist < 65.0) {
                this.field_70170_p.func_175656_a((BlockPos)pos, Blocks.field_150480_ab.func_176223_P());
                continue;
            }
            if (b.func_177230_c() == Blocks.field_150348_b && dist < 100.0 / TrinityConfig.fallout_multiplier && this.getThermonuclear()) {
                if (this.field_70146_Z.nextInt((int)((dist + 1.0) * 10.0)) > 1) continue;
                this.field_70170_p.func_175656_a((BlockPos)pos, Blocks.field_150353_l.func_176223_P());
                continue;
            }
            if (b.func_177230_c() == Blocks.field_150420_aW || b.func_177230_c() == Blocks.field_150419_aX) {
                this.field_70170_p.func_175698_g((BlockPos)pos);
                continue;
            }
            if (!b.func_177230_c().func_149721_r(this.field_70170_p.func_180495_p((BlockPos)pos))) continue;
            return;
        }
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(SCALE, (Object)0);
        this.field_70180_af.func_187214_a(SALTED, (Object)false);
        this.field_70180_af.func_187214_a(THERMONUCLEAR, (Object)false);
        this.field_70180_af.func_187214_a(INTENSITY, (Object)0);
    }

    protected void func_70037_a(NBTTagCompound p_70037_1_) {
        this.setScale(p_70037_1_.func_74762_e("scale"));
        this.setSalted(p_70037_1_.func_74767_n("salted"));
        this.setThermonuclear(p_70037_1_.func_74767_n("thermonuclear"));
        this.setIntensity(p_70037_1_.func_74762_e("intensity"));
        this.revProgress = p_70037_1_.func_74762_e("revProgress");
        this.radProgress = p_70037_1_.func_74762_e("radProgress");
    }

    protected void func_70014_b(NBTTagCompound p_70014_1_) {
        p_70014_1_.func_74768_a("scale", this.getScale());
        p_70014_1_.func_74757_a("salted", this.getSalted());
        p_70014_1_.func_74757_a("thermonuclear", this.getThermonuclear());
        p_70014_1_.func_74768_a("intensity", this.getIntensity());
        p_70014_1_.func_74768_a("revProgress", this.revProgress);
        p_70014_1_.func_74768_a("radProgress", this.radProgress);
    }

    public void setSalted(boolean i) {
        this.field_70180_af.func_187227_b(SALTED, (Object)i);
    }

    public boolean getSalted() {
        boolean salt = (Boolean)this.field_70180_af.func_187225_a(SALTED);
        return !salt ? false : salt;
    }

    public void setThermonuclear(boolean i) {
        this.field_70180_af.func_187227_b(THERMONUCLEAR, (Object)i);
    }

    public boolean getThermonuclear() {
        boolean thermo = (Boolean)this.field_70180_af.func_187225_a(THERMONUCLEAR);
        return !thermo ? false : thermo;
    }

    public void setIntensity(int i) {
        this.field_70180_af.func_187227_b(INTENSITY, (Object)i);
    }

    public int getIntensity() {
        int intensity = (Integer)this.field_70180_af.func_187225_a(INTENSITY);
        return intensity == 0 ? 1 : intensity;
    }

    public void setScale(int i) {
        this.field_70180_af.func_187227_b(SCALE, (Object)i);
    }

    public int getScale() {
        int scale = (Integer)this.field_70180_af.func_187225_a(SCALE);
        return scale == 0 ? 1 : scale;
    }
}

